/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.mpp.MPPComponent;

final class CompObj
extends MPPComponent {
    private final String m_applicationName;
    private Integer m_applicationVersion;
    private String m_applicationID;
    private String m_fileFormat;
    private static final Pattern PATTERN = Pattern.compile("Microsoft.Project.(\\d+)\\.0");

    CompObj(InputStream is) throws IOException {
        InputStreamHelper.skip(is, 28L);
        int length = this.readInt(is);
        this.m_applicationName = new String(this.readByteArray(is, length), 0, length - 1);
        Matcher matcher = PATTERN.matcher(this.m_applicationName);
        if (matcher.matches()) {
            this.m_applicationVersion = Integer.valueOf(matcher.group(1));
        }
        if (this.m_applicationName.equals("Microsoft Project 4.0")) {
            this.m_fileFormat = "MSProject.MPP4";
            this.m_applicationID = "MSProject.Project.4";
        } else {
            length = this.readInt(is);
            if (length > 0) {
                this.m_fileFormat = new String(this.readByteArray(is, length), 0, length - 1);
                length = this.readInt(is);
                if (length > 0) {
                    this.m_applicationID = new String(this.readByteArray(is, length), 0, length - 1);
                }
            }
        }
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public Integer getApplicationVersion() {
        return this.m_applicationVersion;
    }

    public String getApplicationID() {
        return this.m_applicationID;
    }

    public String getFileFormat() {
        return this.m_fileFormat;
    }

    public String toString() {
        return "[CompObj applicationName=" + this.m_applicationName + " applicationID=" + this.m_applicationID + " fileFormat=" + this.m_fileFormat;
    }
}

