/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.mpxj.common.ByteArrayHelper;
import net.sf.mpxj.mpp.MPPComponent;

final class FixFix
extends MPPComponent {
    private final Object[] m_array;
    private final int m_size;
    private final int m_diff;

    FixFix(int itemSize, InputStream is) throws IOException {
        this.m_size = is.available();
        this.m_diff = this.m_size % itemSize;
        int itemCount = this.m_size / itemSize;
        this.m_array = new Object[itemCount];
        for (int loop = 0; loop < itemCount; ++loop) {
            this.m_array[loop] = this.readByteArray(is, itemSize);
        }
    }

    public int getDiff() {
        return this.m_diff;
    }

    public int getSize() {
        return this.m_size;
    }

    public byte[] getByteArrayValue(int index) {
        byte[] result = null;
        if (this.m_array[index] != null) {
            result = (byte[])this.m_array[index];
        }
        return result;
    }

    public int getItemCount() {
        return this.m_array.length;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN FixFix");
        for (int loop = 0; loop < this.m_array.length; ++loop) {
            pw.println("   Data at index: " + loop);
            pw.println("  " + ByteArrayHelper.hexdump((byte[])this.m_array[loop], true));
        }
        pw.println("END FixFix");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

