//--------------------------------------------------------------
// OldTime.fx
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Old Time Movie", "Stylize", "Components", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------

// For each 'texture' declared here, Lightworks adds a matching
// input to your effect (so for a four input effect, you'd need
// to declare four textures and samplers)

DeclareInput( Noise );
DeclareInput( Input );

//--------------------------------------------------------------
// Parameters
//--------------------------------------------------------------
DeclareBoolParam( UseSource, "Use source video", kNoGroup, true );
DeclareFloatParam( ScratchAmount, "Scratch Amount", kNoGroup, kNoFlags, 0.05, 0.0, 1.0 );
DeclareFloatParam( NoiseAmount, "Noise Amount", kNoGroup, kNoFlags, 0.000001, 0.0, 1.0 );
DeclareFloatParam( R1X, "Origin 1", kNoGroup, "SpecifiesPointX", 0.1, 0.0, 1.0 );
DeclareFloatParam( R1Y, "Origin 1", kNoGroup, "SpecifiesPointY", 0.1, 0.0, 1.0 );
DeclareFloatParam( R2X, "Origin 2", kNoGroup, "SpecifiesPointX", 0.9, 0.0, 1.0 );
DeclareFloatParam( R2Y, "Origin 2", kNoGroup, "SpecifiesPointY", 0.9, 0.0, 1.0 );
DeclareBoolParam( NoiseTrack, "Show noise track", kNoGroup, false );
DeclareFloatParam( _Progress );

//--------------------------------------------------------------
// Pixel Shader
//
// This section defines the code which the GPU will
// execute for every pixel in an output image.
//
// Note that pixels are processed out of order, in parallel.
// Using shader model 2.0, so there's a 64 instruction limit -
// use multple passes if you need more.
//--------------------------------------------------------------
DeclareEntryPoint( OldTime )
{
   float2 RandomCoord1 = float2(R1X,R1Y);
   float2 RandomCoord2 = float2(R2X,R2Y);
   float2 randpoint = float2(lerp(R1X,R2X,_Progress),lerp(R1Y,R2Y,_Progress));
   float ScratchAmountInv = 1.0 / ScratchAmount;
   float4 color;
   if (UseSource) color = tex2D(Noise,uv1);
   else color = tex2D(Input,uv2);

   float2 sc = randpoint * float2(0.001f, 0.4f);
   sc.x = frac(uv1.x + sc.x);
   float scratch;
   scratch = 1.0f - tex2D(Noise, sc.yx).g;
   scratch = 2.0f * scratch * ScratchAmountInv;
   scratch = 1.0f - abs(1.0f - scratch);
   scratch = max(0, scratch);
   color.rgb += scratch.rrr;

   float2 rCoord = (uv1 + randpoint) * 0.5;
   float3 rand;
   rand = tex2D(Noise, rCoord.yx/2.0f);

   if(NoiseAmount > rand.g)
   {
      color.rgb = 1.0f;
   }

   float gray = dot(color, float4(0.3,0.59,0.11,0));
   color = float4(gray * float3(0.9,0.8,0.6), 1);

   float2 dist = 0.5 - uv1;

   float fluc = tex2D(Noise, randpoint.yx).g/2.0f;

   color.rgb *= (0.4 + fluc - dot(dist, dist)) * 2.5;

   if (NoiseTrack)
   {
      return tex2D(Noise,uv1);
   }
   else return color;
}
