//--------------------------------------------------------------
// YCrCb422ToRGB.fx
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( YCrCb422ToRGB, Internal, Colour, kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( gSourceImage, Point, Clamp );

DeclareFloat3Param( ccCoefsAdd1 );
DeclareFloat3x3Param( ccCoefsMul2 );
DeclareFloat3Param( ccCoefsAdd3 );

int isEven( int i )
{
   return ( ( 2 * ( i / 2 ) ) == i ) ? 1 : 0;
}

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
DeclareEntryPoint()
{
   // Source pixels are stored as:
   // Y0 = b, Cr = g, Y1 = r, Cb = a

   // TOTALLY CORRECT INFO:
   // For each input BGRA pixel, Y0 is in pix[0], Y1 is in pix[2]
   float3 yuv;

   int q = isEven( int( uv5.x ) );

   float4 src = tex2D( gSourceImage, uv2 );

   // Y
   yuv.r  = src[ q * 2 ];

   // UV
   yuv.gb = src.ag;

   float4 ret;

   ret.a = 1;

   ret.rgb = mul( yuv + ccCoefsAdd1, ccCoefsMul2 ) + ccCoefsAdd3;

   return ret;
}
