//--------------------------------------------------------------//
// Utils
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//

#define kTransparentBlack 0

#define IsOutOfBounds( POS ) any( saturate( POS ) - ( POS ) )

#define ReadPixel( SAMPLER, POS ) lerp( tex2D( SAMPLER, POS ), kTransparentBlack, IsOutOfBounds( POS ) )

#define DeclareInput( TEXTURE, SAMPLER ) \
                                         \
   texture TEXTURE;                      \
                                         \
   sampler SAMPLER = sampler_state       \
   {                                     \
      Texture   = <TEXTURE>;             \
      AddressU  = ClampToEdge;           \
      AddressV  = ClampToEdge;           \
      MinFilter = Linear;                \
      MagFilter = Linear;                \
      MipFilter = Linear;                \
   }
