//--------------------------------------------------------------//
// dve
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------//
#include "_utils.fx"

int _LwksEffectInfo
<
   string EffectGroup = "GenericPixelShader";
   string Description = "DVE";
   string Category    = "DVEs";
   bool CanSize       = true;
> = 0;

//--------------------------------------------------------------//
// Params
//--------------------------------------------------------------//
float CentreX
<
   string Description = "Position";
   string Flags = "SpecifiesPointX";
   float MinVal = -1.00;
   float MaxVal = 2.00;
> = 0.5;

float CentreY
<
   string Description = "Position";
   string Flags = "SpecifiesPointY";
   float MinVal = -1.00;
   float MaxVal = 2.00;
> = 0.5;

float MasterScale
<
   string Description = "Master";
   string Group = "Scale";
   float MinVal = 0.00;
   float MaxVal = 10.00;
> = 1.0;

float XScale
<
   string Description = "X";
   string Group = "Scale";
   float MinVal = 0.00;
   float MaxVal = 10.00;
> = 1.0;

float YScale
<
   string Description = "Y";
   string Group = "Scale";
   float MinVal = 0.00;
   float MaxVal = 10.00;
> = 1.0;

float CropLeft
<
   string Description = "Left";
   string Group = "Crop";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.0;

float CropTop
<
   string Description = "Top";
   string Group = "Crop";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.0;

float CropRight
<
   string Description = "Right";
   string Group = "Crop";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.0;

float CropBottom
<
   string Description = "Bottom";
   string Group = "Crop";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.0;

float ShadowTransparency
<
   string Description = "Transparency";
   string Group = "Shadow";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 0.75;

float ShadowXOffset
<
   string Description = "X Offset";
   string Group = "Shadow";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float ShadowYOffset
<
   string Description = "Y Offset";
   string Group = "Shadow";
   float MinVal = -1.00;
   float MaxVal = 1.00;
> = 0.0;

float Opacity
<
   string Description = "Opacity";
   float MinVal = 0.00;
   float MaxVal = 1.00;
> = 1.0;

float _MaxShadowOffset = 0.2;

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//
DeclareInput( Fg, FgSampler );
DeclareInput( Bg, BgSampler );

float _FgWidth  = 10.0;
float _FgHeight = 10.0;
float _FgXScale = 1.0;
float _FgYScale = 1.0;
float _BgXScale = 1.0;
float _BgYScale = 1.0;

//--------------------------------------------------------------//
// Code
//--------------------------------------------------------------//
float4 ps_main( float2 xy1 : TEXCOORD1, float2 xy2 : TEXCOORD2 ) : COLOR
{
   float4 ret;

   float4 bgPixel = ReadPixel( BgSampler, xy2 );

   float xScale = MasterScale * XScale;
   float yScale = MasterScale * YScale;

   float sourceL = CropLeft;
   float sourceT = CropTop;
   float sourceR = 1.0 - CropRight;
   float sourceB = 1.0 - CropBottom;

   float cx = CentreX - 0.5;
   float cy = CentreY - 0.5;

   cx *= _BgXScale;  // Arrange for the foreground image to be centred on the same background pixel, regardless of output shape & wide/narrow settings
   cy *= _BgYScale;

   cx = ( cx / _FgXScale ) + 0.5;
   cy = ( cy / _FgYScale ) + 0.5;

   float2 pos = xy1;
   pos.x += ( 0.5 - cx );
   pos.y += ( cy - 0.5 );

   pos.x = ( ( pos.x - 0.5 ) / xScale ) + 0.5;
   pos.y = ( ( pos.y - 0.5 ) / yScale ) + 0.5;

   if ( ( pos.x >= sourceL ) && ( pos.x <= sourceR ) && ( pos.y >= sourceT ) && ( pos.y <= sourceB ) )
   {
      float4 fgPixel = ReadPixel( FgSampler, pos );

      ret = lerp( bgPixel, fgPixel, Opacity * fgPixel.a );
   }
   else
   {
      pos.x -= ShadowXOffset * _MaxShadowOffset;
      pos.y -= ShadowYOffset * _MaxShadowOffset;

      if ( ( pos.x >= sourceL ) && ( pos.x <= sourceR ) && ( pos.y >= sourceT ) && ( pos.y <= sourceB ) )
      {
         ret = lerp( 0, bgPixel, ShadowTransparency );
         ret = lerp( bgPixel, ret, Opacity );
      }
      else
      {
         ret = bgPixel;
      }
   }

   return ret;
}

//--------------------------------------------------------------//
// Techniques
//--------------------------------------------------------------//
technique DVE { pass Single_Pass { PixelShader = compile PROFILE ps_main(); } }
