//--------------------------------------------------------------
// Glow
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
DeclareLightworksEffect( Glow, Stylize, Components, kNoNotes, kNoFlags );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareIntParam( SetTechnique, "Source", kNoGroup, kNoFlags, "Luminance|Red|Green|Blue" )
DeclareFloatParam( Tolerance, "Tolerance", kNoGroup, kNoFlags, 0.5, 0.0, 1.0 );
DeclareFloatParam( Feather, "Feather", kNoGroup, kNoFlags, 0.0, 0.0, 1.0 )
DeclareFloatParam( Size, "Size", kNoGroup, kNoFlags, 4.0, 1.0, 10.0 );
DeclareFloatParam( Strength, "Strength", kNoGroup, kNoFlags, 0.5, 0.0, 1.0 );
DeclareColourParam( Colour, "Colour", kNoGroup, kNoFlags, 1.0, 1.0, 1.0, 1.0 );

DeclareFloatParam( _OutputWidth );
DeclareFloatParam( _OutputHeight );
float _MaxFeather = 0.5;

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInput( Input );
DeclareMask;

//--------------------------------------------------------------
// Code
//--------------------------------------------------------------
float4 glowX( float2 xy1, sampler2D sam )
{
   float one   = Size / _OutputWidth;
   float tap1  = xy1.x + one;
   float tap2  = tap1 + one;
   float tap3  = tap2 + one;;
   float tap4  = tap3 + one;
   float tap5  = tap4 + one;
   float tap6  = tap5 + one;
   float ntap1 = xy1.x - one;
   float ntap2 = ntap1 - one;
   float ntap3 = ntap2 - one;;
   float ntap4 = ntap3 - one;
   float ntap5 = ntap4 - one;
   float ntap6 = ntap5 - one;

   float4 blurred = tex2D( sam, xy1 );
   blurred += tex2D( sam, float2( tap1,  xy1.y ) );
   blurred += tex2D( sam, float2( tap2,  xy1.y ) );
   blurred += tex2D( sam, float2( tap3,  xy1.y ) );
   blurred += tex2D( sam, float2( tap4,  xy1.y ) );
   blurred += tex2D( sam, float2( tap5,  xy1.y ) );
   blurred += tex2D( sam, float2( tap6,  xy1.y ) );
   blurred += tex2D( sam, float2( ntap1, xy1.y ) );
   blurred += tex2D( sam, float2( ntap2, xy1.y ) );
   blurred += tex2D( sam, float2( ntap3, xy1.y ) );
   blurred += tex2D( sam, float2( ntap4, xy1.y ) );
   blurred += tex2D( sam, float2( ntap5, xy1.y ) );
   blurred += tex2D( sam, float2( ntap6, xy1.y ) );

   return blurred / 13;
}
//--------------------------------------------------------------
float4 glowY( float2 xy1, sampler2D sam )
{
   float one  = Size / _OutputHeight;
   float tap1 = xy1.y + one;
   float tap2 = tap1 + one;
   float tap3 = tap2 + one;;
   float tap4 = tap3 + one;
   float tap5 = tap4 + one;
   float tap6 = tap5 + one;

   float ntap1 = xy1.y - one;
   float ntap2 = ntap1 - one;
   float ntap3 = ntap2 - one;;
   float ntap4 = ntap3 - one;
   float ntap5 = ntap4 - one;
   float ntap6 = ntap5 - one;

   float4 blurred = tex2D( sam, xy1 );
   blurred += tex2D( sam, float2( xy1.x, tap1 ) );
   blurred += tex2D( sam, float2( xy1.x, tap2 ) );
   blurred += tex2D( sam, float2( xy1.x, tap3 ) );
   blurred += tex2D( sam, float2( xy1.x, tap4 ) );
   blurred += tex2D( sam, float2( xy1.x, tap5 ) );
   blurred += tex2D( sam, float2( xy1.x, tap6 ) );
   blurred += tex2D( sam, float2( xy1.x, ntap1 ) );
   blurred += tex2D( sam, float2( xy1.x, ntap2 ) );
   blurred += tex2D( sam, float2( xy1.x, ntap3 ) );
   blurred += tex2D( sam, float2( xy1.x, ntap4 ) );
   blurred += tex2D( sam, float2( xy1.x, ntap5 ) );
   blurred += tex2D( sam, float2( xy1.x, ntap6 ) );

   float4 source = tex2D( Input, xy1 );
   float4 ret    = lerp( source, source + ( blurred / 13 ), Strength );
   ret.a = source.a;

   return lerp( source, ret, tex2D(Mask, xy1) );
}

//--------------------------------------------------------------
// Luma
//--------------------------------------------------------------
DeclarePass( LumaThreshold )
{
   float actualFeather = Feather * _MaxFeather;

   float4 ret = tex2D( Input, uv1 );

   float srcLum = ( ( ret.r * 0.3 ) + ( ret.g * 0.59 ) + ( ret.b * 0.11 ) ) * ret.a;

   if ( srcLum < Tolerance )
   {
      ret = float4( 0,0,0,0 );
   }
   else if ( srcLum < ( Tolerance + actualFeather ) )
   {
      ret = lerp( float4( 0,0,0,0 ), Colour, ( srcLum - Tolerance ) / actualFeather  );
   }
   else
   {
      ret = Colour;
   }

   return ret;
}
//--------------------------------------------------------------
DeclarePass( LumaGlowX )
{
   return glowX( uv1, LumaThreshold );
}
//--------------------------------------------------------------
DeclareEntryPoint( Luminance )
{
   return glowY( uv1, LumaGlowX );
}

//--------------------------------------------------------------
// Red
//--------------------------------------------------------------
DeclarePass( RedThreshold )
{
   float4 ret = tex2D( Input, uv1 );

   if ( ( ret.r * ret.a ) < Tolerance )
   {
      ret = float4( 0,0,0,0 );
   }

   return ret;
}
//--------------------------------------------------------------
DeclarePass( RedGlowX )
{
   return glowX( uv1, RedThreshold );
}
//--------------------------------------------------------------
DeclareEntryPoint( Red )
{
   return glowY( uv1, RedGlowX );
}

//--------------------------------------------------------------
// Green
//--------------------------------------------------------------
DeclarePass( GreenThreshold )
{
   float4 ret = tex2D( Input, uv1 );

   if ( ( ret.g * ret.a ) < Tolerance )
   {
      ret = float4( 0,0,0,0 );
   }

   return ret;
}
//--------------------------------------------------------------
DeclarePass( GreenGlowX )
{
   return glowX( uv1, GreenThreshold );
}
//--------------------------------------------------------------
DeclareEntryPoint( Green )
{
   return glowY( uv1, GreenGlowX );
}

//--------------------------------------------------------------
// Blue
//--------------------------------------------------------------
DeclarePass( BlueThreshold )
{
   float4 ret = tex2D( Input, uv1 );

   if ( ( ret.b * ret.a ) < Tolerance )
   {
      ret = float4( 0,0,0,0 );
   }

   return ret;
}
//--------------------------------------------------------------
DeclarePass( BlueGlowX )
{
   return glowX( uv1, BlueThreshold );
}
//--------------------------------------------------------------
DeclareEntryPoint( Blue )
{
   return glowY( uv1, BlueGlowX );
}
