//--------------------------------------------------------------
// Mix
//
// Copyright (c) LWKS Software Ltd.  All Rights Reserved
//--------------------------------------------------------------
#include "_utils.fx"

DeclareLightworksEffect( "Dissolve", "Mix", "User", kNoNotes, "CanSize" );

//--------------------------------------------------------------
// Params
//--------------------------------------------------------------
DeclareFloatParamAnimated( Amount, "Amount", kNoGroup, kNoFlags, 0.5, 0.0, 1.0 );

//--------------------------------------------------------------
// Inputs
//--------------------------------------------------------------
DeclareInputs( fg, bg );
DeclareMask;

//--------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------
DeclareEntryPoint()
{
   float4 fgPix = ReadPixel( fg, uv1 );
   float4 bgPix = ReadPixel( bg, uv2 );

   float4 result = lerp( fgPix, bgPix, Amount );
   return lerp( fgPix, result, tex2D( Mask, uv1 ) );
}
