/*
    This file is part of the Kasten Framework, made within the KDE community.

    SPDX-FileCopyrightText: 2019 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_DOCUMENTINFOTOOLVIEWFACTORY_HPP
#define KASTEN_DOCUMENTINFOTOOLVIEWFACTORY_HPP

// lib
#include "oktetakastencontrollers_export.hpp"
// Kasten gui
#include <Kasten/AbstractToolViewFactory>

namespace Kasten {

class OKTETAKASTENCONTROLLERS_EXPORT DocumentInfoToolViewFactory : public AbstractToolViewFactory
{
public:
    DocumentInfoToolViewFactory();
    DocumentInfoToolViewFactory(const DocumentInfoToolViewFactory&) = delete;
    DocumentInfoToolViewFactory(DocumentInfoToolViewFactory&&) = delete;

    ~DocumentInfoToolViewFactory() override;

    DocumentInfoToolViewFactory& operator=(const DocumentInfoToolViewFactory&) = delete;
    DocumentInfoToolViewFactory& operator=(DocumentInfoToolViewFactory&&) = delete;

public: // AbstractToolViewFactory API
    [[nodiscard]]
    std::unique_ptr<AbstractToolView> create(AbstractTool* tool) const override;

    [[nodiscard]]
    QString iconName() const override;
    [[nodiscard]]
    QString title() const override;
    [[nodiscard]]
    QString id() const override;
    [[nodiscard]]
    SidePosition defaultPosition() const override;
};

}

#endif
