/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.view;

import com.mxgraph.util.mxUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scilab.modules.graph.utils.ScilabGraphUtils;
import org.scilab.modules.jvm.LoadClassPath;

public enum SupportedLabelType {
    HTML,
    Latex,
    MathML;

    private static final Pattern BR_PATTERN;
    private static final char LATEX_TAG = '$';
    private static final char MATHML_TAG = '^';
    private static final String CLASSPATH_MATHML_NAME = "xcos_mathml_rendering";

    public static SupportedLabelType getFromText(String string) {
        if (string.length() > 0) {
            if (string.charAt(0) == '$' && string.charAt(string.length() - 1) == '$') {
                return Latex;
            }
            if (string.charAt(0) == '^' && string.charAt(string.length() - 1) == '^') {
                LoadClassPath.loadOnUse((String)CLASSPATH_MATHML_NAME);
                return MathML;
            }
        }
        return HTML;
    }

    public static SupportedLabelType getFromHTML(String string) {
        if (string.length() > 0 && string.charAt(0) == '<') {
            StringBuilder stringBuilder = new StringBuilder(mxUtils.getBodyMarkup((String)string, (boolean)false));
            ScilabGraphUtils.removeBlanks(stringBuilder);
            if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '$' && stringBuilder.charAt(stringBuilder.length() - 1) == '$') {
                return Latex;
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '^' && stringBuilder.charAt(stringBuilder.length() - 1) == '^') {
                LoadClassPath.loadOnUse((String)CLASSPATH_MATHML_NAME);
                return MathML;
            }
        } else {
            return SupportedLabelType.getFromText(string);
        }
        return HTML;
    }

    public String escape(String string) {
        StringBuilder stringBuilder = string.startsWith("<html") ? new StringBuilder(ScilabGraphUtils.getBodyMarkup((String)string, (boolean)true)) : new StringBuilder(string);
        switch (this) {
            case MathML: 
            case Latex: {
                ScilabGraphUtils.unescape(stringBuilder, 0);
                Matcher matcher = BR_PATTERN.matcher(stringBuilder);
                while (matcher.find()) {
                    stringBuilder.replace(matcher.start(), matcher.end(), "");
                    matcher.reset();
                }
                ScilabGraphUtils.removeBlanks(stringBuilder);
                stringBuilder.delete(0, 1);
                int n = stringBuilder.length();
                stringBuilder.delete(n - 1, n);
                break;
            }
        }
        return stringBuilder.toString();
    }

    static {
        BR_PATTERN = Pattern.compile("<br>\\p{Blank}*");
    }
}

