/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.editbox.SwingScilabEditBox;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.utils.UnitsConverter;
import org.scilab.modules.gui.widget.Widget;

public final class SwingViewWidget {
    private static final String OBLIQUEFONT = "oblique";
    private static final String ITALICFONT = "italic";
    private static final String BOLDFONT = "bold";
    private static final int COLORS_COEFF = 255;
    private static final int X_INDEX = 0;
    private static final int Y_INDEX = 1;
    private static final int WIDTH_INDEX = 2;
    private static final int HEIGHT_INDEX = 3;

    private SwingViewWidget() {
        throw new UnsupportedOperationException();
    }

    public static void update(Widget widget, int n, Object object) {
        Integer n2 = ((SwingViewObject)((Object)widget)).getId();
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 294: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray[0] == -1.0) {
                    ((JComponent)((Object)widget)).setOpaque(true);
                    widget.resetBackground();
                    break;
                }
                if (doubleArray[0] == -2.0) {
                    ((JComponent)((Object)widget)).setOpaque(false);
                    break;
                }
                ((JComponent)((Object)widget)).setOpaque(true);
                widget.setBackground(new Color((int)(doubleArray[0] * 255.0), (int)(doubleArray[1] * 255.0), (int)(doubleArray[2] * 255.0)));
                break;
            }
            case 36: {
                int n3 = (Integer)graphicController.getProperty(n2, 37);
                widget.setCallback(CommonCallBack.createCallback((String)object, n3, n2));
                break;
            }
            case 37: {
                String string = (String)graphicController.getProperty(n2, 36);
                if ((Integer)object == -1) {
                    widget.setCallback(null);
                    break;
                }
                widget.setCallback(CommonCallBack.createCallback(string, (Integer)object, n2));
                break;
            }
            case 295: {
                widget.setEnabled((Boolean)object);
                break;
            }
            case 296: {
                Font font;
                String string = (String)object;
                if (string.equals("") || (font = widget.getFont()) == null) break;
                font = string.equalsIgnoreCase(ITALICFONT) || string.equalsIgnoreCase(OBLIQUEFONT) ? (font.isBold() ? new Font(font.getName(), 3, font.getSize()) : new Font(font.getName(), 2, font.getSize())) : (font.isBold() ? new Font(font.getName(), 1, font.getSize()) : new Font(font.getName(), 0, font.getSize()));
                widget.setFont(font);
                break;
            }
            case 297: {
                Font font;
                String string = (String)object;
                if (string.equals("") || (font = widget.getFont()) == null) break;
                font = new Font(string, font.getStyle(), font.getSize());
                if (widget instanceof SwingScilabEditBox) {
                    ((SwingScilabEditBox)widget).setEditFont(font);
                    break;
                }
                widget.setFont(font);
                break;
            }
            case 298: {
                if ((Double)object == 0.0) break;
                UnitsConverter.UicontrolUnits uicontrolUnits = UnitsConverter.stringToUnitsEnum((String)graphicController.getProperty(n2, 299));
                Double d = UnitsConverter.convertToPoint((Double)object, uicontrolUnits, widget, false);
                Font font = widget.getFont();
                if (font == null) break;
                int n4 = d.intValue();
                font = new Font(font.getName(), font.getStyle(), n4);
                widget.setFont(font);
                break;
            }
            case 300: {
                Font font;
                String string = (String)object;
                if (string.equals("") || (font = widget.getFont()) == null) break;
                font = string.equalsIgnoreCase(BOLDFONT) ? (font.isItalic() ? new Font(font.getName(), 3, font.getSize()) : new Font(font.getName(), 1, font.getSize())) : (font.isItalic() ? new Font(font.getName(), 2, font.getSize()) : new Font(font.getName(), 0, font.getSize()));
                widget.setFont(font);
                break;
            }
            case 301: {
                Double[] doubleArray = (Double[])object;
                if (doubleArray[0] != -1.0) {
                    widget.setForeground(new Color((int)(doubleArray[0] * 255.0), (int)(doubleArray[1] * 255.0), (int)(doubleArray[2] * 255.0)));
                    break;
                }
                widget.resetForeground();
                break;
            }
            case 302: {
                String string = (String)object;
                if (string.equals("")) break;
                widget.setHorizontalAlignment((String)object);
                break;
            }
            case 80: {
                SwingViewWidget.updatePosition(widget, n2, object);
                break;
            }
            case 316: {
                Double[] doubleArray = (Double[])GraphicController.getController().getProperty(n2, 80);
                SwingViewWidget.updatePosition(widget, n2, doubleArray);
                break;
            }
            case 307: {
                widget.setRelief((String)object);
                break;
            }
            case 308: {
                if (((String[])object).length == 0) {
                    widget.setEmptyText();
                    break;
                }
                widget.setText(((String[])object)[0]);
                break;
            }
            case 312: {
                String[] stringArray = (String[])object;
                String string = stringArray[0];
                if (stringArray.length > 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html>" + string);
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append("<br>").append(stringArray[i]);
                    }
                    stringBuilder.append("</html>");
                    string = stringBuilder.toString();
                }
                if (string.equals("")) {
                    widget.setToolTipText(null);
                    break;
                }
                widget.setToolTipText(string);
                break;
            }
            case 320: {
                String string = (String)object;
                if (string.equals("")) break;
                widget.setVerticalAlignment((String)object);
                break;
            }
            case 27: {
                widget.setVisible((Boolean)object);
                if ((Component)((Object)widget) == null || ((Component)((Object)widget)).getParent() == null) break;
                ((Component)((Object)widget)).getParent().invalidate();
                ((Component)((Object)widget)).getParent().doLayout();
                break;
            }
            case 24: {
                ((SwingViewObject)((Object)widget)).update(80, graphicController.getProperty(n2, 80));
                break;
            }
        }
    }

    public static Double[] updatePosition(Widget widget, Integer n, Object object) {
        UnitsConverter.UicontrolUnits uicontrolUnits = UnitsConverter.stringToUnitsEnum((String)GraphicController.getController().getProperty(n, 316));
        Double[] doubleArray = UnitsConverter.convertPositionToPixels((Double[])object, uicontrolUnits, widget);
        widget.setDims(new Size(doubleArray[2].intValue(), doubleArray[3].intValue()));
        widget.setPosition(new Position(doubleArray[0].intValue(), doubleArray[1].intValue()));
        return doubleArray;
    }
}

