/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.canvas;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.OS;
import org.scilab.modules.gui.utils.Debug;
import org.scilab.modules.localization.Messages;

public class SwingScilabCanvasImpl {
    static boolean forceGLCanvas = false;
    static boolean noGLJPanel = false;
    static boolean testCanvasAtStartup = false;
    static boolean enableGLCanvas;
    private static SwingScilabCanvasImpl me;

    public static boolean switchToGLCanvas(boolean bl) {
        Debug.DEBUG("SwingScilabCanvasImpl", "switchToGLCanvas " + bl);
        if (!bl && noGLJPanel) {
            InterpreterManagement.requestScilabExec((String)Messages.gettext((String)"disp(\"WARNING: Despite of our previous warning, you choose to use Scilab with advanced graphics capabilities. Type \"\"help usecanvas\"\" for more information.\")"));
        }
        enableGLCanvas = bl;
        return enableGLCanvas;
    }

    public static boolean isGLCanvasEnabled() {
        return enableGLCanvas;
    }

    public static SwingScilabCanvasImpl getInstance() {
        if (me == null) {
            me = new SwingScilabCanvasImpl();
        }
        return me;
    }

    public Component createOpenGLComponent(int n) {
        if (enableGLCanvas) {
            return new SafeGLCanvas();
        }
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        if (n == 0) {
            gLCapabilities.setSampleBuffers(false);
        } else {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n);
        }
        return new SafeGLJPanel(gLCapabilities);
    }

    static {
        if (testCanvasAtStartup && OS.get() != OS.MAC) {
            String string;
            long l = Calendar.getInstance().getTimeInMillis();
            Debug.DEBUG("SwingScilabCanvasImpl", "=======================================");
            String string2 = System.getProperty("os.name");
            Debug.DEBUG("SwingScilabCanvasImpl", "os.name=" + string2);
            String string3 = System.getProperty("os.arch");
            Debug.DEBUG("SwingScilabCanvasImpl", "os.arch=" + string3);
            Debug.DEBUG("SwingScilabCanvasImpl", "=======================================");
            if (string2.contains("Windows") && string3.equals("amd64")) {
                string = System.getenv("SCILAB_MSTS_SESSION");
                if (string != null && string.equals("OK")) {
                    noGLJPanel = true;
                }
                if (noGLJPanel) {
                    InterpreterManagement.requestScilabExec((String)String.format("disp(\"%s\"), disp(\"%s\")", String.format(Messages.gettext((String)"WARNING: Due to your configuration limitations, Scilab switched in a mode where mixing uicontrols and graphics is not available. Type %s for more information."), "\"\"help usecanvas\"\""), String.format(Messages.gettext((String)"In some cases, %s fixes the issue"), "\"\"system_setproperty(''jogl.gljpanel.nohw'','''');\"\"")));
                }
            }
            if (!string2.contains("Windows")) {
                try {
                    string = new GLCanvas((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getDefault()));
                    Frame frame = new Frame();
                    frame.add((Component)((Object)string));
                    frame.setVisible(true);
                    string.getContext().makeCurrent();
                    GL gL = string.getGL();
                    String string4 = gL.glGetString(7936);
                    Debug.DEBUG("SwingScilabCanvasImpl", "GL_VENDOR=" + string4);
                    String string5 = gL.glGetString(7937);
                    Debug.DEBUG("SwingScilabCanvasImpl", "GL_RENDERER=" + string5);
                    String string6 = gL.glGetString(7938);
                    Debug.DEBUG("SwingScilabCanvasImpl", "GL_VERSION=" + string6);
                    Debug.DEBUG("SwingScilabCanvasImpl", "=======================================");
                    string.getContext().release();
                    frame.remove((Component)((Object)string));
                    frame.setVisible(false);
                    frame.dispose();
                    Debug.DEBUG("SwingScilabCanvasImpl", "Testing time = " + (Calendar.getInstance().getTimeInMillis() - l) + "ms");
                    noGLJPanel = false;
                    if (string2.contains("Linux")) {
                        noGLJPanel = true;
                        if (string4.contains("NVIDIA")) {
                            noGLJPanel = false;
                        }
                        if (string4.contains("ATI")) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string6, " ");
                            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ".");
                            int n = Integer.parseInt(stringTokenizer2.nextToken());
                            int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                            int n3 = Integer.parseInt(stringTokenizer2.nextToken());
                            Debug.DEBUG("SwingScilabCanvasImpl", "majorVersion = " + n + " minorVersion = " + n2 + " releaseVersion = " + n3);
                            if (n > 2 || n == 2 && n2 > 1 || n == 2 && n2 == 1 && n3 >= 7873) {
                                noGLJPanel = false;
                            }
                        }
                    }
                    if (noGLJPanel) {
                        InterpreterManagement.requestScilabExec((String)String.format("disp(\"%s\"), disp(\"%s\")", String.format(Messages.gettext((String)"WARNING: Due to your configuration limitations, Scilab switched in a mode where mixing uicontrols and graphics is not available. Type %s for more information."), "\"\"help usecanvas\"\""), String.format(Messages.gettext((String)"In some cases, %s fixes the issue"), "\"\"system_setproperty(''jogl.gljpanel.nohw'','''');\"\"")));
                    }
                }
                catch (GLException gLException) {
                    noGLJPanel = true;
                    InterpreterManagement.requestScilabExec((String)String.format("disp(\"%s\"), disp(\"%s\")", Messages.gettext((String)"Due to your video card drivers limitations, that are not able to manage OpenGL, Scilab will not be able to draw any graphics. Please update your driver."), String.format(Messages.gettext((String)"In some cases, %s fixes the issue"), "\"\"system_setproperty(''jogl.gljpanel.nohw'','''');\"\"")));
                }
                catch (HeadlessException headlessException) {
                    noGLJPanel = true;
                }
            }
        }
        enableGLCanvas = forceGLCanvas || noGLJPanel;
        me = null;
    }

    private static final class SafeGLCanvas
    extends GLCanvas {
        private static final long serialVersionUID = -3315164314205693678L;

        private SafeGLCanvas() {
        }
    }

    private final class SafeGLJPanel
    extends GLJPanel {
        private static final long serialVersionUID = -6166986369022555750L;

        public SafeGLJPanel(GLCapabilities gLCapabilities) {
            super((GLCapabilitiesImmutable)gLCapabilities);
        }

        public void display() {
            try {
                super.display();
            }
            catch (Exception exception) {
                super.reshape(this.getX(), this.getY(), this.getWidth(), this.getHeight());
                super.display();
            }
        }
    }
}

