/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.filechooser;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.scilab.modules.gui.bridge.filechooser.FileMask;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File file = null;
    JFileChooser fc;

    public ImagePreview(JFileChooser jFileChooser) {
        this.fc = jFileChooser;
        this.setPreferredSize(new Dimension(250, 200));
        jFileChooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.file == null) {
            this.thumbnail = null;
            return;
        }
        ImageIcon imageIcon = null;
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(this.file.getPath()));
            if (bufferedImage != null) {
                imageIcon = new ImageIcon(bufferedImage);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (imageIcon != null) {
            this.thumbnail = imageIcon.getIconWidth() > 230 ? new ImageIcon(imageIcon.getImage().getScaledInstance(230, -1, 4)) : imageIcon;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string)) {
            this.file = null;
            bl = true;
        } else if ("SelectedFileChangedProperty".equals(string)) {
            if (propertyChangeEvent.getNewValue() != null) {
                this.file = (File)propertyChangeEvent.getNewValue();
                bl = true;
            }
        } else if ("fileFilterChanged".equals(string)) {
            this.updateFileName(this.file);
            this.fc.setMultiSelectionEnabled(true);
            this.fc.setMultiSelectionEnabled(false);
        }
        if (bl) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    private void updateFileName(File file) {
        if (file != null) {
            FileMask fileMask;
            String string;
            Object object = file.getName();
            int n = ((String)object).lastIndexOf(46);
            if (n != -1) {
                object = ((String)object).substring(0, n);
            }
            if ((string = (fileMask = (FileMask)this.fc.getFileFilter()).getExtensionFromFilter()) != null && !string.equals("*")) {
                object = (String)object + "." + string;
                this.fc.setSelectedFile(new File((String)object));
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 5) {
                n = 5;
            }
            this.thumbnail.paintIcon(this, graphics, n, n2);
        }
    }
}

