/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.filechooser;

import java.io.File;
import org.scilab.modules.graphic_export.FileExporter;
import org.scilab.modules.graphic_objects.figure.Figure;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingView;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.filechooser.ExportData;
import org.scilab.modules.gui.bridge.filechooser.ExportOptionWindow;
import org.scilab.modules.gui.bridge.filechooser.JFXScilabFileChooser;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.localization.Messages;

public class JFXScilabExportFileChooser
extends JFXScilabFileChooser {
    private static final int NB_FILE_MASKS = 10;
    private final String[] description = new String[]{Messages.gettext((String)"Windows BMP image"), Messages.gettext((String)"GIF image"), Messages.gettext((String)"JPEG image"), Messages.gettext((String)"PNG image"), Messages.gettext((String)"PPM image"), Messages.gettext((String)"Enhanced Metafile image (EMF)"), Messages.gettext((String)"Encapsulated PostScript image (EPS)"), Messages.gettext((String)"PostScript image (PS)"), Messages.gettext((String)"PDF image"), Messages.gettext((String)"SVG image")};
    private final String[] extensions = new String[]{"*.bmp", "*.gif", "*.jpg|*.jpeg", "*.png", "*.ppm", "*.emf", "*.eps", "*.ps", "*.pdf", "*.svg"};
    private String exportName;
    private String extensionSelected;
    private Integer figureUID;

    public JFXScilabExportFileChooser(Integer n) {
        this.figureUID = n;
        this.exportCustomFileChooser(n);
    }

    public void exportCustomFileChooser(Integer n) {
        Figure figure = (Figure)GraphicController.getController().getObjectFromId(n);
        String string = figure.getName();
        int n2 = figure.getId();
        string = string != null && !string.isEmpty() ? string.replaceFirst("%d", Integer.toString(n2)) : Messages.gettext((String)"Untitled-export");
        this.setTitle(Messages.gettext((String)"Export"));
        File file = new File(string);
        this.setInitialFileName(file.getName());
        this.setAcceptAllFileFilterUsed(false);
        this.figureUID = n;
        this.addMask(this.extensions, this.description);
        this.setUiDialogType(1);
        this.displayAndWait();
        String[] stringArray = this.getSelection();
        if (stringArray.length != 0 && stringArray[0] != "") {
            this.exportName = stringArray[0];
            ConfigManager.saveLastOpenedDirectory(new File(this.exportName).getParentFile().getPath());
            String string2 = this.getExtension(this.exportName);
            if (string2.equals("emf") || string2.equals("eps") || string2.equals("ps") || string2.equals("pdf") || string2.equals("svg")) {
                this.vectorialExport(string2);
            } else {
                this.bitmapExport(string2);
            }
        }
    }

    public String getExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void bitmapExport(String string) {
        ExportData exportData = new ExportData(this.figureUID, this.exportName, string, null);
        FileExporter.fileExport((int)this.figureUID, (String)this.exportName, (String)exportData.getExportExtension(), (float)-1.0f, (int)0);
    }

    public void vectorialExport(String string) {
        SwingViewObject swingViewObject = SwingView.getFromId(this.figureUID);
        SimpleTab simpleTab = swingViewObject instanceof SimpleTab ? (SimpleTab)((Object)SwingView.getFromId(this.figureUID)) : null;
        ExportData exportData = new ExportData(this.figureUID, this.exportName, string, null);
        ExportOptionWindow exportOptionWindow = new ExportOptionWindow(exportData);
        exportOptionWindow.displayOptionWindow(simpleTab);
        exportOptionWindow.landscapePortraitOption();
    }
}

