/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.filechooser;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.scilab.modules.gui.filechooser.FileChooserInfos;
import org.scilab.modules.gui.filechooser.SimpleFileChooser;
import org.scilab.modules.gui.utils.SciFileFilter;

public class JFXScilabFileChooser
implements SimpleFileChooser {
    private static final long serialVersionUID = 1L;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    private String[] selection;
    private String selectionPath;
    private String title;
    private static Double xPos = Double.NaN;
    private static Double yPos = Double.NaN;
    private String[] selectionFileNames;
    private int selectionSize;
    private int filterIndex;
    private int maskSize = 0;
    private boolean acceptAllFileFilterUsed = false;
    private int dialogType = 0;
    private boolean directorySelectionOnly = false;
    private boolean multipleSelection = false;
    private JFXPanel jfxpanel = new JFXPanel();
    private DirectoryChooser directoryChooser = new DirectoryChooser();
    private FileChooser fileChooser = new FileChooser();
    private Stage stage;

    public void setParentFrame(JFrame jFrame) {
    }

    @Override
    public void displayAndWait() {
        FutureTask<ArrayList<File>> futureTask = new FutureTask<ArrayList<File>>(new getChosenFile());
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(futureTask);
        try {
            ArrayList<File> arrayList = futureTask.get();
            this.selectionSize = arrayList.size();
            if (this.selectionSize > 0) {
                this.selection = new String[this.selectionSize];
                this.selectionFileNames = new String[this.selectionSize];
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.selection[i] = arrayList.get(i).getAbsolutePath();
                    this.selectionPath = arrayList.get(i).getParentFile().getPath();
                    this.selectionFileNames[i] = arrayList.get(i).getName();
                }
                this.filterIndex = this.getSelectedFilterIndex() + 1;
            } else {
                this.selection = new String[1];
                this.selection[0] = "";
                this.selectionPath = "";
                this.selectionFileNames = new String[1];
                this.selectionFileNames[0] = "";
                this.filterIndex = 0;
            }
            FileChooserInfos.getInstance().setSelection(this.selection);
            FileChooserInfos.getInstance().setSelectionPathName(this.selectionPath);
            FileChooserInfos.getInstance().setSelectionFileNames(this.selectionFileNames);
            FileChooserInfos.getInstance().setSelectionSize(this.selectionSize);
            FileChooserInfos.getInstance().setFilterIndex(this.filterIndex);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean bl) {
        this.acceptAllFileFilterUsed = bl;
        if (bl) {
            SciFileFilter sciFileFilter = new SciFileFilter("*.*", null, 0);
            this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(sciFileFilter.getDescription(), new String[]{"*.*"}));
        }
    }

    @Override
    public void addMask(String[] stringArray, String[] stringArray2) {
        if (stringArray2 == null || stringArray2.length == 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                SciFileFilter sciFileFilter = new SciFileFilter(stringArray[i], null, i);
                this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(sciFileFilter.getDescription(), Arrays.asList(stringArray[i].split("\\|"))));
                if (!stringArray[i].equals("*.*")) continue;
                this.acceptAllFileFilterUsed = true;
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                SciFileFilter sciFileFilter = new SciFileFilter(stringArray[i], stringArray2[i], i);
                this.fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(sciFileFilter.getDescription(), Arrays.asList(stringArray[i].split("\\|"))));
                if (!stringArray[i].equals("*.*")) continue;
                this.acceptAllFileFilterUsed = true;
            }
        }
    }

    public void setFileFilter(FileChooser.ExtensionFilter extensionFilter) {
        this.fileChooser.setSelectedExtensionFilter(extensionFilter);
    }

    public void setFileFilter(FileFilter fileFilter) {
        String[] stringArray = ((FileNameExtensionFilter)fileFilter).getExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "*." + stringArray[i];
        }
        this.fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter(((FileNameExtensionFilter)fileFilter).getDescription(), stringArray));
    }

    public FileChooser.ExtensionFilter getFileFilterFromExtension(String string) {
        for (FileChooser.ExtensionFilter extensionFilter : this.fileChooser.getExtensionFilters()) {
            for (String string2 : extensionFilter.getExtensions()) {
                if (!string2.equals(string)) continue;
                return extensionFilter;
            }
        }
        return null;
    }

    public int getSelectedFilterIndex() {
        int n = 0;
        for (FileChooser.ExtensionFilter extensionFilter : this.fileChooser.getExtensionFilters()) {
            if (this.fileChooser.getSelectedExtensionFilter() == extensionFilter) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
    }

    public void setCurrentDirectory(File file) {
        File file2 = file.isDirectory() ? file : (file.exists() ? file.getParentFile() : new File(System.getProperty("user.dir")));
        if (this.directorySelectionOnly) {
            this.directoryChooser.setInitialDirectory(file2);
        } else {
            this.fileChooser.setInitialDirectory(file2);
        }
    }

    @Override
    public void setInitialDirectory(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return;
        }
        String string3 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null && System.getenv(string2) != null) {
            string3 = string3.replaceFirst(string2, System.getenv(string2));
        }
        this.setCurrentDirectory(new File(string3));
    }

    @Override
    public void setInitialFileName(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        File file = new File(string);
        this.fileChooser.setInitialFileName(file.getName());
    }

    @Override
    public int getSelectionSize() {
        return this.selectionSize;
    }

    @Override
    public String[] getSelection() {
        return this.selection;
    }

    @Override
    public void setDirectorySelectionOnly() {
        this.directorySelectionOnly = true;
    }

    @Override
    public void setMultipleSelection(boolean bl) {
        this.multipleSelection = bl;
    }

    @Override
    public String getSelectionPathName() {
        return this.selectionPath;
    }

    @Override
    public String[] getSelectionFileNames() {
        return this.selectionFileNames;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void setUiDialogType(int n) {
        this.dialogType = n;
    }

    class getChosenFile
    implements Callable<ArrayList<File>> {
        getChosenFile() {
        }

        @Override
        public ArrayList<File> call() throws Exception {
            Object object;
            ArrayList<File> arrayList = new ArrayList<File>();
            if (!(JFXScilabFileChooser.this.stage instanceof Stage)) {
                JFXScilabFileChooser.this.stage = new Stage();
                JFXScilabFileChooser.this.stage.setMaxHeight(0.0);
                JFXScilabFileChooser.this.stage.setWidth(0.0);
                JFXScilabFileChooser.this.stage.setResizable(false);
                JFXScilabFileChooser.this.stage.setAlwaysOnTop(true);
                JFXScilabFileChooser.this.stage.initStyle(StageStyle.UNIFIED);
                if (xPos.isNaN()) {
                    object = Toolkit.getDefaultToolkit().getScreenSize();
                    xPos = (double)(((Dimension)object).width / 2) - JFXScilabFileChooser.this.stage.getWidth() / 2.0;
                    yPos = (double)((Dimension)object).height / 3.0;
                }
                JFXScilabFileChooser.this.stage.setX(xPos.doubleValue());
                JFXScilabFileChooser.this.stage.setY(yPos.doubleValue());
            }
            JFXScilabFileChooser.this.stage.setTitle(JFXScilabFileChooser.this.title);
            JFXScilabFileChooser.this.stage.initModality(Modality.APPLICATION_MODAL);
            JFXScilabFileChooser.this.stage.show();
            if (JFXScilabFileChooser.this.dialogType == 0) {
                if (!JFXScilabFileChooser.this.multipleSelection) {
                    if (!JFXScilabFileChooser.this.directorySelectionOnly) {
                        object = JFXScilabFileChooser.this.fileChooser.showOpenDialog((Window)JFXScilabFileChooser.this.stage);
                        if (object != null) {
                            arrayList.add((File)object);
                        }
                    } else {
                        object = JFXScilabFileChooser.this.directoryChooser.showDialog((Window)JFXScilabFileChooser.this.stage);
                        if (object != null) {
                            arrayList.add((File)object);
                        }
                    }
                } else {
                    object = JFXScilabFileChooser.this.fileChooser.showOpenMultipleDialog((Window)JFXScilabFileChooser.this.stage);
                    if (object != null) {
                        for (int i = 0; i < object.size(); ++i) {
                            arrayList.add((File)object.get(i));
                        }
                    }
                }
            } else if (JFXScilabFileChooser.this.dialogType == 1) {
                Comparable<Boolean> comparable;
                object = JFXScilabFileChooser.this.fileChooser.getInitialFileName();
                if (object != null && object != "") {
                    String string;
                    comparable = false;
                    int n = ((String)object).lastIndexOf(46);
                    FileChooser.ExtensionFilter extensionFilter = null;
                    if (n > 0 && (extensionFilter = JFXScilabFileChooser.this.getFileFilterFromExtension(string = "*" + ((String)object).substring(n))) != null) {
                        JFXScilabFileChooser.this.fileChooser.setSelectedExtensionFilter(extensionFilter);
                        JFXScilabFileChooser.this.fileChooser.setInitialFileName(((String)object).substring(0, n));
                    }
                    if (extensionFilter == null && JFXScilabFileChooser.this.acceptAllFileFilterUsed && (extensionFilter = JFXScilabFileChooser.this.getFileFilterFromExtension("*.*")) != null) {
                        JFXScilabFileChooser.this.fileChooser.setSelectedExtensionFilter(extensionFilter);
                    }
                }
                if ((comparable = JFXScilabFileChooser.this.fileChooser.showSaveDialog((Window)JFXScilabFileChooser.this.stage)) != null) {
                    arrayList.add((File)comparable);
                }
            }
            xPos = JFXScilabFileChooser.this.stage.getX();
            yPos = JFXScilabFileChooser.this.stage.getY();
            JFXScilabFileChooser.this.stage.close();
            return arrayList;
        }
    }
}

