/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.frame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.graphic_objects.graphicModel.GraphicModel;
import org.scilab.modules.graphic_objects.uicontrol.Uicontrol;
import org.scilab.modules.graphic_objects.utils.LayoutType;
import org.scilab.modules.gui.SwingView;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.SwingViewWidget;
import org.scilab.modules.gui.bridge.frame.SwingScilabLayer;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabTabGroup;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.dockable.Dockable;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.BorderConvertor;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.PositionConverter;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.Size;
import org.scilab.modules.gui.widget.Widget;

public class SwingScilabScrollableFrame
extends JScrollPane
implements SwingViewObject,
Widget {
    private static final long serialVersionUID = -7401084975837285447L;
    private Integer uid;
    private JPanel panel = new JPanel();
    private Border defaultBorder = null;

    public SwingScilabScrollableFrame() {
        this.setViewportView(this.panel);
        this.panel.setLayout(null);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(this.getSize().width, this.getSize().height);
    }

    @Override
    public Position getPosition() {
        return PositionConverter.javaToScilab(this.getLocation(), this.getSize(), this.getParent());
    }

    @Override
    public void setDims(Size size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        Position position2 = PositionConverter.scilabToJava(position, this.getDims(), this.getParent());
        this.setLocation(position2.getX(), position2.getY());
    }

    public void addMember(SwingViewObject swingViewObject) {
        Object object;
        Object object2;
        if (!this.isEnabled()) {
            ((Component)((Object)swingViewObject)).setEnabled(false);
        }
        Uicontrol uicontrol = (Uicontrol)GraphicModel.getModel().getObjectFromId(swingViewObject.getId());
        if (this.getLayout() instanceof BorderLayout) {
            switch (uicontrol.getBorderPositionAsEnum()) {
                case BOTTOM: {
                    this.panel.add((Component)((Object)swingViewObject), "South");
                    break;
                }
                case TOP: {
                    this.panel.add((Component)((Object)swingViewObject), "North");
                    break;
                }
                case LEFT: {
                    this.panel.add((Component)((Object)swingViewObject), "West");
                    break;
                }
                case RIGHT: {
                    this.panel.add((Component)((Object)swingViewObject), "East");
                    break;
                }
                case CENTER: {
                    this.panel.add((Component)((Object)swingViewObject), "Center");
                    break;
                }
            }
            object2 = uicontrol.getBorderPreferredSize();
            if (!object2[0].equals(-1) && !object2[1].equals(-1)) {
                ((Component)((Object)swingViewObject)).setPreferredSize(new Dimension((Integer)object2[0], (Integer)object2[1]));
            }
        } else if (this.getLayout() instanceof GridBagLayout) {
            object2 = new GridBagConstraints();
            object = uicontrol.getGridBagGrid();
            ((GridBagConstraints)object2).gridx = object[0];
            ((GridBagConstraints)object2).gridy = object[1];
            ((GridBagConstraints)object2).gridwidth = object[2];
            ((GridBagConstraints)object2).gridheight = (Integer)object[3];
            Double[] doubleArray = uicontrol.getGridBagWeight();
            ((GridBagConstraints)object2).weightx = doubleArray[0];
            ((GridBagConstraints)object2).weighty = doubleArray[1];
            switch (uicontrol.getGridBagAnchorAsEnum()) {
                case LEFT: {
                    ((GridBagConstraints)object2).anchor = 17;
                    break;
                }
                case UPPER: {
                    ((GridBagConstraints)object2).anchor = 11;
                    break;
                }
                case LOWER: {
                    ((GridBagConstraints)object2).anchor = 15;
                    break;
                }
                case LOWER_LEFT: {
                    ((GridBagConstraints)object2).anchor = 16;
                    break;
                }
                case LOWER_RIGHT: {
                    ((GridBagConstraints)object2).anchor = 14;
                    break;
                }
                case RIGHT: {
                    ((GridBagConstraints)object2).anchor = 13;
                    break;
                }
                case UPPER_LEFT: {
                    ((GridBagConstraints)object2).anchor = 18;
                    break;
                }
                case UPPER_RIGHT: {
                    ((GridBagConstraints)object2).anchor = 12;
                    break;
                }
                default: {
                    ((GridBagConstraints)object2).anchor = 10;
                }
            }
            switch (uicontrol.getGridBagFillAsEnum()) {
                case BOTH: {
                    ((GridBagConstraints)object2).fill = 1;
                    break;
                }
                case HORIZONTAL: {
                    ((GridBagConstraints)object2).fill = 2;
                    break;
                }
                case VERTICAL: {
                    ((GridBagConstraints)object2).fill = 3;
                    break;
                }
                default: {
                    ((GridBagConstraints)object2).fill = 0;
                }
            }
            Double[] doubleArray2 = uicontrol.getMargins();
            ((GridBagConstraints)object2).insets = new Insets(doubleArray2[0].intValue(), doubleArray2[1].intValue(), doubleArray2[2].intValue(), doubleArray2[3].intValue());
            Integer[] integerArray = uicontrol.getGridBagPadding();
            ((GridBagConstraints)object2).ipadx = integerArray[0];
            ((GridBagConstraints)object2).ipady = integerArray[1];
            Integer[] integerArray2 = uicontrol.getGridBagPreferredSize();
            if (!integerArray2[0].equals(-1) && !integerArray2[1].equals(-1)) {
                ((Component)((Object)swingViewObject)).setPreferredSize(new Dimension(integerArray2[0], integerArray2[1]));
            }
            this.panel.add((Component)((Object)swingViewObject), object2);
            this.revalidate();
        } else if (this.getLayout() instanceof GridLayout) {
            this.panel.add((Component)((Object)swingViewObject), 0);
        } else {
            this.panel.add((Component)((Object)swingViewObject));
        }
        object2 = (SwingScilabPanel)((Object)SwingUtilities.getAncestorOfClass(SwingScilabPanel.class, this));
        if (object2 != null) {
            object = SwingScilabWindow.allScilabWindows.get(object2.getParentWindowId());
            ((Window)object).pack();
        }
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MenuBar getMenuBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ToolBar getToolBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getText() {
        return this.getName();
    }

    @Override
    public void setText(String string) {
        this.setName(string);
    }

    @Override
    public void setEmptyText() {
        this.setText(null);
    }

    public int addMember(Dockable dockable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        this.setVisible(false);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
    }

    @Override
    public void setVerticalAlignment(String string) {
    }

    @Override
    public void setId(Integer n) {
        this.uid = n;
    }

    @Override
    public Integer getId() {
        return this.uid;
    }

    @Override
    public void update(int n, Object object) {
        GraphicController graphicController = GraphicController.getController();
        switch (n) {
            case 308: {
                SwingScilabTabGroup swingScilabTabGroup;
                int n2;
                Container container = this.getParent();
                if (!(container instanceof SwingScilabTabGroup) || (n2 = (swingScilabTabGroup = (SwingScilabTabGroup)container).indexOfComponent(this)) == -1) break;
                swingScilabTabGroup.setTitleAt(n2, ((String[])object)[0]);
                break;
            }
            case 386: {
                Integer n3 = (Integer)object;
                Border border = BorderConvertor.getBorder(n3);
                this.setBorder(border);
                break;
            }
            case 370: {
                LayoutType layoutType = LayoutType.intToEnum((Integer)((Integer)object));
                this.invalidate();
                switch (layoutType) {
                    case BORDER: {
                        Integer[] integerArray = (Integer[])graphicController.getProperty(this.getId(), 385);
                        this.setLayout(new BorderLayout(integerArray[0], integerArray[1]));
                        break;
                    }
                    case GRIDBAG: {
                        this.setLayout(new GridBagLayout());
                        break;
                    }
                    case GRID: {
                        Integer[] integerArray = (Integer[])graphicController.getProperty(this.getId(), 384);
                        Integer[] integerArray2 = (Integer[])graphicController.getProperty(this.getId(), 383);
                        if (integerArray2[0] == 0 && integerArray2[1] == 0) {
                            integerArray2[0] = 1;
                        }
                        this.setLayout(new GridLayout(integerArray2[0], integerArray2[1], integerArray[0], integerArray[1]));
                        break;
                    }
                    default: {
                        this.setLayout(null);
                    }
                }
                this.validate();
                break;
            }
            case 383: 
            case 384: {
                Integer n4 = (Integer)GraphicController.getController().getProperty(this.getId(), 370);
                LayoutType layoutType = LayoutType.intToEnum((Integer)n4);
                if (layoutType != LayoutType.GRID) break;
                Integer[] integerArray = (Integer[])GraphicController.getController().getProperty(this.getId(), 384);
                Integer[] integerArray3 = (Integer[])GraphicController.getController().getProperty(this.getId(), 383);
                Integer[] integerArray4 = new Integer[]{0, 0};
                integerArray4[0] = integerArray3[0];
                integerArray4[1] = integerArray3[1];
                if (integerArray4[0] == 0 && integerArray4[1] == 0) {
                    integerArray4[0] = 1;
                }
                this.invalidate();
                GridLayout gridLayout = (GridLayout)this.getLayout();
                gridLayout.setRows(integerArray4[0]);
                gridLayout.setColumns(integerArray4[1]);
                gridLayout.setHgap(integerArray[0]);
                gridLayout.setVgap(integerArray[1]);
                this.validate();
                break;
            }
            case 385: {
                Integer n5 = (Integer)GraphicController.getController().getProperty(this.getId(), 370);
                LayoutType layoutType = LayoutType.intToEnum((Integer)n5);
                if (layoutType != LayoutType.BORDER) break;
                this.invalidate();
                Integer[] integerArray = (Integer[])object;
                BorderLayout borderLayout = (BorderLayout)this.getLayout();
                borderLayout.setHgap(integerArray[0]);
                borderLayout.setVgap(integerArray[1]);
                this.validate();
                break;
            }
            case 27: {
                boolean bl = true;
                Container container = this.getParent();
                if (container instanceof SwingScilabLayer) {
                    Boolean bl2 = (Boolean)object;
                    SwingScilabLayer swingScilabLayer = (SwingScilabLayer)container;
                    Boolean bl3 = swingScilabLayer.isLayerActive(this);
                    if (bl3 != bl2) {
                        graphicController.setProperty(this.uid, 27, (Object)bl3);
                    }
                    bl = false;
                } else if (container instanceof SwingScilabTabGroup) {
                    Boolean bl4 = (Boolean)object;
                    SwingScilabTabGroup swingScilabTabGroup = (SwingScilabTabGroup)container;
                    Boolean bl5 = swingScilabTabGroup.isTabActive(this);
                    if (bl5 != bl4) {
                        graphicController.setProperty(this.uid, 27, (Object)bl5);
                    }
                    bl = false;
                }
                if (!bl) break;
                this.setVisible((Boolean)object);
                break;
            }
            case 99: {
                Container container = this.getParent();
                if (container instanceof SwingScilabLayer) {
                    SwingScilabLayer swingScilabLayer = (SwingScilabLayer)container;
                    swingScilabLayer.updateModelProperties(null, swingScilabLayer.getActiveLayer());
                    break;
                }
                if (!(container instanceof SwingScilabTabGroup)) break;
                ((SwingScilabTabGroup)container).updateModelProperties();
                break;
            }
            default: {
                SwingViewWidget.update(this, n, object);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        SwingScilabTabGroup swingScilabTabGroup;
        Integer n;
        Object object;
        if (bl) {
            super.setEnabled(bl);
            this.panel.setEnabled(bl);
            object = (Integer[])GraphicController.getController().getProperty(this.uid, 22);
            for (var3_3 = 0; var3_3 < ((Serializable[])object).length; ++var3_3) {
                n = (Integer)GraphicController.getController().getProperty((Integer)object[var3_3], 29);
                if (n != 19) continue;
                Boolean bl2 = (Boolean)GraphicController.getController().getProperty((Integer)object[var3_3], 295);
                SwingView.getFromId((Integer)object[var3_3]).update(295, bl2);
            }
        } else {
            super.setEnabled(bl);
            this.panel.setEnabled(bl);
            object = this.panel.getComponents();
            for (var3_3 = 0; var3_3 < ((Serializable[])object).length; ++var3_3) {
                ((Component)object[var3_3]).setEnabled(false);
            }
        }
        if ((object = this.getParent()) instanceof SwingScilabTabGroup && (n = (swingScilabTabGroup = (SwingScilabTabGroup)object).getIndex(this)) != -1) {
            swingScilabTabGroup.setEnabledAt(n, bl);
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager != null) {
            if (layoutManager instanceof ScrollPaneLayout) {
                super.setLayout(layoutManager);
            } else if (this.panel != null) {
                this.panel.setLayout(layoutManager);
            }
        }
    }

    @Override
    public LayoutManager getLayout() {
        if (this.panel != null) {
            return this.panel.getLayout();
        }
        return null;
    }

    @Override
    public void setBorder(Border border) {
        if (this.panel != null) {
            this.panel.setBorder(border);
        }
    }

    @Override
    public Border getBorder() {
        if (this.panel != null) {
            return this.panel.getBorder();
        }
        return null;
    }

    @Override
    public void setBackground(Color color) {
        if (this.panel != null) {
            this.panel.setBackground(color);
        }
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ScrollPane.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("ScrollPane.foreground");
        if (color != null) {
            super.setForeground(color);
        }
    }
}

