/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.helpbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.DefaultHelpHistoryModel;
import javax.help.DefaultHelpModel;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.JHelpIndexNavigator;
import javax.help.JHelpNavigator;
import javax.help.JHelpSearchNavigator;
import javax.help.JHelpTOCNavigator;
import javax.help.SwingHelpUtilities;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicSearchNavigatorUI;
import javax.help.plaf.basic.BasicTOCNavigatorUI;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.bridge.helpbrowser.SwingScilabHelpBrowserViewer;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.helpbrowser.SimpleHelpBrowser;
import org.scilab.modules.gui.messagebox.MessageBox;
import org.scilab.modules.gui.messagebox.ScilabMessageBox;
import org.scilab.modules.gui.utils.HelpSearchField;
import org.scilab.modules.localization.Messages;

public class SwingScilabHelpBrowser
extends JPanel
implements SimpleHelpBrowser,
HelpModelListener {
    private static final long serialVersionUID = 5306766011092074961L;
    private static String defaultLanguage = "en_US";
    private static String jarExtension = "_help.jar";
    private static String mainJarPath = System.getenv("SCI") + "/modules/helptools/jar/scilab_";
    private String currentLanguage = "";
    private JHelp jhelp = new JHelp();
    private URL homePageURL;
    private HelpSearchField searchField;
    private ClassLoader classLoader;
    private static DefaultHelpHistoryModel helpHistory;

    public static DefaultHelpHistoryModel getHelpHistory() {
        return helpHistory;
    }

    public SwingScilabHelpBrowser(String[] stringArray, String string) {
        super(new BorderLayout());
        this.add((Component)this.jhelp);
        this.setFocusable(true);
        this.searchField = new HelpSearchField(this, null);
        if (ScilabConsole.isExistingConsole() && ScilabConsole.getConsole().getInfoBar() != null) {
            ScilabConsole.getConsole().getInfoBar().setText(Messages.gettext((String)"Loading help browser..."));
            ScilabConsole.getConsole().setCursor(Cursor.getPredefinedCursor(3));
        }
        this.loadJar(stringArray, string);
        if (ScilabConsole.isExistingConsole() && ScilabConsole.getConsole().getInfoBar() != null) {
            ScilabConsole.getConsole().getInfoBar().setText("");
            ScilabConsole.getConsole().setCursor(Cursor.getPredefinedCursor(0));
        }
        helpHistory = (DefaultHelpHistoryModel)this.jhelp.getHistoryModel();
        try {
            this.homePageURL = new URL(this.jhelp.getModel().getHelpSet().getHelpSetURL().toString().replace("jhelpset.hs", "ScilabHomePage.html"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.jhelp.getContentViewer().addHelpModelListener((HelpModelListener)this);
        this.setVisible(true);
    }

    public final void loadJar(String[] stringArray, String string) {
        Object object;
        File[] fileArray = stringArray != null ? new File[stringArray.length + 1] : new File[1];
        File file = new File(mainJarPath + string + jarExtension);
        this.currentLanguage = string;
        if (!file.exists()) {
            file = new File(mainJarPath + defaultLanguage + jarExtension);
            this.currentLanguage = defaultLanguage;
        }
        if (!file.exists()) {
            String string2 = "'SCI/modules/helptools/jar/scilab_" + defaultLanguage + jarExtension + "' has not been found on the system.\nAre you sure you built it?\nThe help will not be available.";
            if (ScilabConsole.isExistingConsole()) {
                MessageBox messageBox = ScilabMessageBox.createMessageBox();
                messageBox.setMessage(string2);
                messageBox.setModal(true);
                messageBox.setIcon("error");
                messageBox.displayAndWait();
            } else {
                System.out.println(string2);
            }
            return;
        }
        int n = 0;
        fileArray[n++] = file;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(stringArray[i]);
                object = file2.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.endsWith(jarExtension);
                    }
                });
                if (object == null || ((String[])object).length == 0) {
                    file2 = new File(stringArray[i] + "/../../jar");
                    object = file2.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return string.endsWith(jarExtension);
                        }
                    });
                }
                int n2 = -1;
                int n3 = -1;
                if (object == null) continue;
                for (int j = 0; j < ((String[])object).length; ++j) {
                    if (object[j].indexOf(defaultLanguage) != -1) {
                        n2 = j;
                    }
                    if (((String)object[j]).indexOf(string) == -1) continue;
                    n3 = j;
                }
                if (n3 != -1) {
                    fileArray[n++] = new File(String.valueOf(file2) + File.separator + (String)object[n3]);
                    continue;
                }
                if (n2 != -1) {
                    fileArray[n++] = new File(String.valueOf(file2) + File.separator + (String)object[n2]);
                    continue;
                }
                if (object == null || ((Object)object).length == 0) continue;
                fileArray[n++] = new File(String.valueOf(file2) + File.separator + (String)object[0]);
            }
        }
        this.jhelp.setModel((TextHelpModel)new DefaultHelpModel(new HelpSet()));
        URL[] uRLArray = new URL[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                uRLArray[i] = fileArray[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                uRLArray[i] = null;
            }
        }
        this.classLoader = new URLClassLoader(uRLArray);
        for (int i = 0; i < n; ++i) {
            HelpSet helpSet;
            URI uRI = fileArray[i].toURI();
            object = new StringBuilder("jar:");
            ((StringBuilder)object).append(uRI);
            ((StringBuilder)object).append("!/");
            ((StringBuilder)object).append(SwingScilabHelpBrowser.rootName(uRI));
            ((StringBuilder)object).append("/jhelpset.hs");
            URL uRL = null;
            try {
                uRL = new URL(((StringBuilder)object).toString());
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                continue;
            }
            try {
                helpSet = new HelpSet(this.classLoader, uRL);
            }
            catch (HelpSetException helpSetException) {
                System.err.println("Could not load file: " + String.valueOf(fileArray[i]) + ". Please check its contents, must be a Java Help file.");
                System.err.println("Error message: " + helpSetException.getLocalizedMessage());
                if (ScilabConsole.isExistingConsole() && ScilabConsole.getConsole().getInfoBar() != null) {
                    ScilabConsole.getConsole().getInfoBar().setText("");
                    ScilabConsole.getConsole().setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
            this.jhelp.getModel().getHelpSet().add(helpSet);
        }
        Enumeration enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof JHelpIndexNavigator)) continue;
            this.jhelp.removeHelpNavigator((JHelpNavigator)((JHelpIndexNavigator)e));
            break;
        }
        enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object e = enumeration.nextElement();
            if (!(e instanceof JHelpTOCNavigator)) continue;
            object = (BasicTOCNavigatorUI)((JHelpTOCNavigator)e).getUI();
            BasicHelpUI basicHelpUI = (BasicHelpUI)this.jhelp.getUI();
            JToolBar jToolBar = null;
            try {
                object5 = BasicHelpUI.class.getDeclaredField("toolbar");
                ((Field)object5).setAccessible(true);
                jToolBar = (JToolBar)((Field)object5).get(basicHelpUI);
                object4 = (JButton)jToolBar.getComponent(0);
                ((AbstractButton)object4).setIcon(new ImageIcon(FindIconHelper.findIcon((String)"go-previous")));
                object3 = (JButton)jToolBar.getComponent(1);
                ((AbstractButton)object3).setIcon(new ImageIcon(FindIconHelper.findIcon((String)"go-next")));
                object2 = (JButton)jToolBar.getComponent(3);
                ((AbstractButton)object2).setIcon(new ImageIcon(FindIconHelper.findIcon((String)"document-print")));
                JButton jButton = (JButton)jToolBar.getComponent(4);
                jButton.setIcon(new ImageIcon(FindIconHelper.findIcon((String)"printer")));
                this.jhelp.remove((Component)jToolBar);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object5 = null;
            try {
                object4 = BasicHelpUI.class.getDeclaredField("tabbedPane");
                ((Field)object4).setAccessible(true);
                object5 = (JTabbedPane)((Field)object4).get(basicHelpUI);
                ((JTabbedPane)object5).setIconAt(0, new ImageIcon(FindIconHelper.findIcon((String)"user-home")));
                ((JTabbedPane)object5).setIconAt(1, new ImageIcon(FindIconHelper.findIcon((String)"system-search")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            object4 = null;
            try {
                object3 = BasicHelpUI.class.getDeclaredField("splitPane");
                ((Field)object3).setAccessible(true);
                object4 = (JSplitPane)((Field)object3).get(basicHelpUI);
                ((JSplitPane)object4).setContinuousLayout(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object3 = null;
            try {
                object2 = BasicTOCNavigatorUI.class.getDeclaredField("sp");
                ((Field)object2).setAccessible(true);
                object3 = (JScrollPane)((Field)object2).get(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object3 == null) break;
            object2 = object3;
            ((Component)object2).addComponentListener(new ComponentAdapter((JScrollPane)object2){
                final /* synthetic */ JScrollPane val$sp;
                {
                    this.val$sp = jScrollPane;
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.val$sp.getHorizontalScrollBar().setValue(0);
                    this.val$sp.getVerticalScrollBar().setValue(0);
                    this.val$sp.removeComponentListener(this);
                }
            });
            break;
        }
    }

    public JToolBar getToolbar() {
        BasicHelpUI basicHelpUI = (BasicHelpUI)this.jhelp.getUI();
        JToolBar jToolBar = null;
        try {
            Field field = BasicHelpUI.class.getDeclaredField("toolbar");
            field.setAccessible(true);
            jToolBar = (JToolBar)field.get(basicHelpUI);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jToolBar;
    }

    public static boolean isMainJarExists(String string) {
        File file = new File(mainJarPath + string + jarExtension);
        return file.exists() || (file = new File(mainJarPath + defaultLanguage + jarExtension)).exists();
    }

    public String getCurrentURL() {
        return ((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).getCurrentURL();
    }

    public String getCurrentID() {
        if (this.jhelp.getModel().getCurrentID() != null) {
            String string = this.jhelp.getModel().getCurrentID().toString();
            int n = string.indexOf(" ");
            int n2 = string.indexOf(",");
            if (n != -1 && n2 != -1) {
                string = string.substring(n + 1, n2);
            }
            return string;
        }
        return null;
    }

    public void setCurrentID(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingScilabHelpBrowser.this.jhelp.setCurrentID(string);
                }
                catch (BadIDException badIDException) {
                    SwingScilabHelpBrowser.this.jhelp.setCurrentURL(SwingScilabHelpBrowser.this.homePageURL);
                }
            }
        });
    }

    public void showSearchField() {
        this.searchField.setTextComponent(((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).getAccessibleHTML());
        this.searchField.showField();
    }

    public void hideSearchField() {
        this.searchField.hideField();
    }

    public void increaseFont() {
        ((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).increaseFont();
    }

    public void decreaseFont() {
        ((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).decreaseFont();
    }

    public void idChanged(HelpModelEvent helpModelEvent) {
        this.searchField.setTextComponent(((SwingScilabHelpBrowserViewer)this.jhelp.getContentViewer().getUI()).getAccessibleHTML());
    }

    public void displayHomePage() {
        if (this.homePageURL != null) {
            this.setCurrentURL(this.homePageURL);
        }
    }

    public void setCurrentURL(final URL uRL) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingScilabHelpBrowser.this.jhelp.setCurrentURL(uRL);
            }
        });
    }

    public void setCurrentURL(String string) {
        URL uRL = this.homePageURL;
        try {
            if (string != null) {
                uRL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.setCurrentURL(uRL);
    }

    @Override
    public void display() {
    }

    @Override
    public void searchKeywork(String string) {
        Enumeration enumeration;
        if (string == null) {
            this.displayHomePage();
            return;
        }
        if (string.length() > 0 && string.charAt(0) == '%') {
            string = string.replace("%", "percent");
        }
        if (!(enumeration = this.jhelp.getHelpNavigators()).hasMoreElements()) {
            System.out.println("Scilab help files not loaded. Please check if " + mainJarPath + "*" + jarExtension + " files exist and are Java Help files.");
            return;
        }
        this.jhelp.setCurrentNavigator((JHelpNavigator)((JHelpTOCNavigator)enumeration.nextElement()));
        final String string2 = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingScilabHelpBrowser.this.jhelp.setCurrentID(string2);
                }
                catch (BadIDException badIDException) {
                    SwingScilabHelpBrowser.this.fullTextSearch(string2);
                }
            }
        });
    }

    @Override
    public void fullTextSearch(String string) {
        Enumeration enumeration = this.jhelp.getHelpNavigators();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof JHelpSearchNavigator)) continue;
            JHelpSearchNavigator jHelpSearchNavigator = (JHelpSearchNavigator)e;
            this.jhelp.setCurrentNavigator((JHelpNavigator)jHelpSearchNavigator);
            SearchQuery searchQuery = jHelpSearchNavigator.getSearchEngine().createQuery();
            searchQuery.addSearchListener((SearchListener)((BasicSearchNavigatorUI)jHelpSearchNavigator.getUI()));
            searchQuery.start(string, new Locale(this.currentLanguage));
            break;
        }
    }

    @Override
    public void close() {
    }

    private static String rootName(URI uRI) {
        String string = uRI.toString();
        int n = string.lastIndexOf(47);
        String string2 = n < 0 ? string : string.substring(n + 1);
        n = string2.lastIndexOf(46);
        String string3 = n < 0 ? string2 : string2.substring(0, n);
        return string3;
    }

    static {
        SwingHelpUtilities.setContentViewerUI((String)"org.scilab.modules.gui.bridge.helpbrowser.SwingScilabHelpBrowserViewer");
    }
}

