/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.bridge.textbox;

import java.awt.Color;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.textbox.SimpleTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.Position;
import org.scilab.modules.gui.utils.ScilabRelief;
import org.scilab.modules.gui.utils.ScilabSwingUtilities;
import org.scilab.modules.gui.utils.Size;

public class SwingScilabTextBox
extends JTextArea
implements SimpleTextBox {
    private static final long serialVersionUID = 3632560416759268432L;
    private Border defaultBorder = null;

    public SwingScilabTextBox() {
        this.setEditable(false);
        this.setOpaque(false);
        this.setFocusable(false);
    }

    @Override
    public void setText(String string) {
        super.setText(string);
    }

    @Override
    public void setEmptyText() {
        this.setText(null);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    @Override
    public void draw() {
        this.setVisible(true);
        this.doLayout();
    }

    @Override
    public Size getDims() {
        return new Size(super.getSize().width, super.getSize().height);
    }

    @Override
    public Position getPosition() {
        return new Position(super.getX(), super.getY());
    }

    @Override
    public void setDims(Size size) {
        super.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setPosition(Position position) {
        this.setLocation(position.getX(), position.getY());
    }

    @Override
    public MenuBar getMenuBar() {
        return null;
    }

    @Override
    public ToolBar getToolBar() {
        return null;
    }

    @Override
    public void addMenuBar(MenuBar menuBar) {
    }

    @Override
    public void addToolBar(ToolBar toolBar) {
    }

    @Override
    public void setCallback(CommonCallBack commonCallBack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHorizontalAlignment(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVerticalAlignment(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRelief(String string) {
        if (this.defaultBorder == null) {
            this.defaultBorder = this.getBorder();
        }
        this.setBorder(ScilabRelief.getBorderFromRelief(string, this.defaultBorder));
    }

    @Override
    public void destroy() {
        ScilabSwingUtilities.removeFromParent(this);
    }

    @Override
    public void addInfoBar(TextBox textBox) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextBox getInfoBar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetBackground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("TextArea.background");
        if (color != null) {
            this.setBackground(color);
        }
    }

    @Override
    public void resetForeground() {
        Color color = (Color)UIManager.getLookAndFeelDefaults().get("TextArea.foreground");
        if (color != null) {
            this.setForeground(color);
        }
    }
}

