/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.events;

import java.awt.Toolkit;
import org.scilab.modules.gui.events.GlobalKeyEventWatcher;
import org.scilab.modules.gui.events.GlobalMouseEventWatcher;

public final class GlobalEventWatcher {
    private static GlobalEventWatcher me;
    private static GlobalKeyEventWatcher keyWatcher;
    private static GlobalMouseEventWatcher mouseWatcher;
    private static boolean activated;
    private static Integer axesUID;
    private static boolean catchingCallback;

    private GlobalEventWatcher() {
    }

    public static GlobalEventWatcher getInstance() {
        if (me == null) {
            me = new GlobalEventWatcher();
        }
        return me;
    }

    public static void enable(GlobalKeyEventWatcher globalKeyEventWatcher) {
        keyWatcher = globalKeyEventWatcher;
        Toolkit.getDefaultToolkit().addAWTEventListener(globalKeyEventWatcher, 8L);
        activated = true;
    }

    public static void enable(GlobalMouseEventWatcher globalMouseEventWatcher) {
        mouseWatcher = globalMouseEventWatcher;
        Toolkit.getDefaultToolkit().addAWTEventListener(globalMouseEventWatcher, globalMouseEventWatcher.getEventMask());
        activated = true;
    }

    public static void disable() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(keyWatcher);
        Toolkit.getDefaultToolkit().removeAWTEventListener(mouseWatcher);
        activated = false;
        catchingCallback = false;
    }

    public static boolean isActivated() {
        return activated;
    }

    public static void setAxesUID(Integer n) {
        axesUID = n;
    }

    public static Integer getAxesUID() {
        return axesUID;
    }

    public static void enableCatchingCallback() {
        catchingCallback = true;
    }

    public static void disableCatchingCallback() {
        catchingCallback = false;
    }

    public static boolean isCatchingCallback() {
        return catchingCallback;
    }

    static {
        axesUID = null;
        catchingCallback = false;
    }
}

