/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.ged;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableModel;
import org.scilab.modules.graphic_objects.PolylineData;
import org.scilab.modules.gui.ged.ColorMapHandler;
import org.scilab.modules.gui.ged.MessagesGED;
import org.scilab.modules.gui.ged.SwingInspector;
import org.scilab.modules.gui.ged.actions.ShowHide;

public class ContentLayout
extends JPanel {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbc;
    private static String imagepath = System.getenv("SCI") + "/modules/gui/images/icons/";

    public ContentLayout() {
        this.setLayout(this.layout);
        this.gbc = new GridBagConstraints();
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(0, 0, 0, 0);
    }

    public void addSHbutton(JPanel jPanel, JToggleButton jToggleButton, int n, int n2) {
        jToggleButton.setBorder(null);
        jToggleButton.setBorderPainted(false);
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setMaximumSize(new Dimension(16, 16));
        jToggleButton.setMinimumSize(new Dimension(16, 16));
        jToggleButton.setPreferredSize(new Dimension(16, 16));
        jToggleButton.setRolloverEnabled(false);
        jToggleButton.setIcon(new ImageIcon(SwingInspector.icon_collapse));
        jToggleButton.setSelectedIcon(new ImageIcon(SwingInspector.icon_expand));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = n;
        this.gbc.gridy = n2;
        jPanel.add((Component)jToggleButton, this.gbc);
    }

    public void addSectionTitle(JPanel jPanel, JLabel jLabel, String string, int n) {
        jLabel.setText(string);
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 21;
        this.gbc.fill = 2;
        this.gbc.gridx = 1;
        this.gbc.gridy = n;
        this.gbc.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)jLabel, this.gbc);
    }

    public void addSeparator(JPanel jPanel, JSeparator jSeparator, int n) {
        jSeparator.setPreferredSize(new Dimension(5, 10));
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 21;
        this.gbc.fill = 2;
        this.gbc.gridx = 1;
        this.gbc.gridy = n;
        this.gbc.weightx = 0.1;
        this.gbc.insets = new Insets(0, 0, 1, 0);
        jPanel.add((Component)jSeparator, this.gbc);
    }

    public void addColorField(JPanel jPanel, JPanel jPanel2, final JDialog jDialog, JButton jButton, JLabel jLabel, int n, int n2) {
        jPanel2.setBackground(new Color(255, 255, 255));
        jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jPanel2.setPreferredSize(new Dimension(5, 20));
        jPanel2.setLayout(new GridBagLayout());
        jButton.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jButton.setContentAreaFilled(false);
        jButton.setMaximumSize(new Dimension(16, 16));
        jButton.setMinimumSize(new Dimension(16, 16));
        jButton.setPreferredSize(new Dimension(16, 16));
        jButton.setIcon(new ImageIcon(SwingInspector.icon_color_fill));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(true);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 2;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(2, 37, 2, 0);
        jPanel2.add((Component)jButton, this.gbc);
        jLabel.setText(" ");
        jLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel.setOpaque(true);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.ipadx = 22;
        this.gbc.ipady = -8;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(4, 11, 0, 68);
        jPanel2.add((Component)jLabel, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = n;
        this.gbc.gridy = n2;
        this.gbc.fill = 2;
        this.gbc.ipadx = 70;
        this.gbc.insets = new Insets(0, 4, 5, 0);
        jPanel.add((Component)jPanel2, this.gbc);
    }

    public void addColorDialog(final JDialog jDialog, final JColorChooser jColorChooser, JButton jButton, final JLabel jLabel, final Integer n, final Integer n2, final String string, final String string2, final Object object) {
        jDialog.setTitle(MessagesGED.choose_color);
        jDialog.setMinimumSize(new Dimension(567, 340));
        jDialog.setModal(true);
        jDialog.setResizable(true);
        jDialog.getContentPane().setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 18;
        jDialog.getContentPane().add((Component)jColorChooser, this.gbc);
        jButton.setText(" OK ");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    this.okActionPerformed();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(ContentLayout.class.getName()).log(Level.SEVERE, null, classNotFoundException);
                }
            }

            private void okActionPerformed() throws ClassNotFoundException {
                Color color = jColorChooser.getColor();
                double d = color.getRed();
                double d2 = color.getGreen();
                double d3 = color.getBlue();
                Integer n3 = ColorMapHandler.getScilabColor(d, d2, d3, n2);
                try {
                    Class[] classArray = new Class[]{Integer.TYPE, String.class};
                    Class<?> clazz = Class.forName("org.scilab.modules.gui.ged.graphic_objects." + string);
                    Method method = clazz.getMethod(string2, classArray);
                    Object[] objectArray = new Object[]{new Integer(n3), new Integer(n)};
                    method.invoke(object, objectArray);
                }
                catch (Throwable throwable) {
                    System.err.println(throwable);
                }
                jLabel.setBackground(color);
                jDialog.dispose();
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(0, 522, 2, 0);
        jDialog.getContentPane().add((Component)jButton, this.gbc);
    }

    public void addDataField(JPanel jPanel, JPanel jPanel2, JButton jButton, JLabel jLabel, int n, int n2) {
        jPanel2.setBackground(new Color(255, 255, 255));
        jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jPanel2.setPreferredSize(new Dimension(5, 20));
        jPanel2.setLayout(new GridBagLayout());
        jButton.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jButton.setContentAreaFilled(false);
        jButton.setMinimumSize(new Dimension(16, 16));
        jButton.setPreferredSize(new Dimension(16, 16));
        jButton.setIcon(new ImageIcon(SwingInspector.icon_table));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 18;
        this.gbc.weighty = 0.01;
        this.gbc.insets = new Insets(2, 10, 2, 0);
        jPanel2.add((Component)jButton, this.gbc);
        jLabel.setBackground(new Color(239, 77, 31));
        jLabel.setBorder(null);
        jLabel.setMaximumSize(new Dimension(100, 20));
        jLabel.setMinimumSize(new Dimension(50, 20));
        jLabel.setPreferredSize(new Dimension(50, 20));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.fill = 2;
        this.gbc.ipadx = 22;
        this.gbc.anchor = 19;
        this.gbc.weightx = 0.1;
        this.gbc.insets = new Insets(0, 11, 0, 0);
        jPanel2.add((Component)jLabel, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = n;
        this.gbc.gridy = n2;
        this.gbc.fill = 2;
        this.gbc.ipadx = 70;
        this.gbc.anchor = 21;
        this.gbc.weightx = 0.1;
        this.gbc.insets = new Insets(0, 4, 5, 0);
        jPanel.add((Component)jPanel2, this.gbc);
    }

    public void addDataDialog(JDialog jDialog, JScrollPane jScrollPane, final JTable jTable, JButton jButton, JButton jButton2, JButton jButton3, JButton jButton4, final Integer n) {
        jDialog.setTitle(MessagesGED.data_editor);
        jDialog.setMinimumSize(new Dimension(150, 340));
        jDialog.setModal(true);
        jDialog.setResizable(true);
        jDialog.getContentPane().setLayout(new GridBagLayout());
        jTable.setModel(new DefaultTableModel(new Object[][]{null, null}, new String[]{"X", "Y"}){
            Class[] types;
            {
                this.types = new Class[]{Double.class, Double.class, Double.class};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }
        });
        final DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
        jTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        jScrollPane.setViewportView(jTable);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 4;
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        jDialog.getContentPane().add((Component)jScrollPane, this.gbc);
        jButton.setIcon(new ImageIcon(imagepath + "16x16/actions/list-add.png"));
        jButton.setToolTipText(MessagesGED.append);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PolylineData.insertPoint((int)n, (int)(defaultTableModel.getRowCount() - 1), (double)0.0, (double)0.0, (double)0.0) != 0) {
                    defaultTableModel.addRow(new Object[]{0.0, 0.0});
                }
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(3, 10, 0, 0);
        jDialog.getContentPane().add((Component)jButton, this.gbc);
        jButton2.setIcon(new ImageIcon(imagepath + "16x16/actions/list-remove.png"));
        jButton2.setToolTipText(MessagesGED.delete);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jTable.getSelectedRow() != -1 && PolylineData.removePoint((int)n, (int)jTable.getSelectedRow()) != 0) {
                    defaultTableModel.removeRow(jTable.getSelectedRow());
                }
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(3, 3, 0, 0);
        jDialog.getContentPane().add((Component)jButton2, this.gbc);
        jButton3.setIcon(new ImageIcon(imagepath + "16x16/actions/view-refresh.png"));
        jButton3.setToolTipText(MessagesGED.refresh);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(3, 3, 0, 0);
        jDialog.getContentPane().add((Component)jButton3, this.gbc);
        jButton4.setIcon(new ImageIcon(imagepath + "16x16/actions/dynamic-blue-up.png"));
        jButton4.setToolTipText(MessagesGED.submit_close);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 3;
        this.gbc.gridy = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(3, 3, 0, 0);
        jDialog.getContentPane().add((Component)jButton4, this.gbc);
    }

    public void addShiftDialog(JDialog jDialog, JScrollPane jScrollPane, JTable jTable, JButton jButton, JButton jButton2) {
        jDialog.setTitle(MessagesGED.data_editor);
        jDialog.setMinimumSize(new Dimension(140, 340));
        jDialog.setModal(true);
        jDialog.setResizable(true);
        jDialog.getContentPane().setLayout(new GridBagLayout());
        jTable.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Null", "Null"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Double.class, Double.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        jScrollPane.setViewportView(jTable);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 1;
        this.gbc.anchor = 18;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        jDialog.getContentPane().add((Component)jScrollPane, this.gbc);
        jButton.setIcon(new ImageIcon(imagepath + "16x16/actions/view-refresh.png"));
        jButton.setToolTipText(MessagesGED.refresh);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(3, 10, 0, 0);
        jDialog.getContentPane().add((Component)jButton, this.gbc);
        jButton2.setIcon(new ImageIcon(imagepath + "16x16/actions/dynamic-blue-up.png"));
        jButton2.setToolTipText(MessagesGED.submit_close);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(3, 3, 0, 0);
        jDialog.getContentPane().add((Component)jButton2, this.gbc);
    }

    public void addJComboBox(JPanel jPanel, JComboBox jComboBox, String[] stringArray, int n, int n2) {
        jComboBox.setPreferredSize(new Dimension(5, 20));
        if (stringArray != null) {
            jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        }
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 21;
        this.gbc.fill = 2;
        this.gbc.gridx = n;
        this.gbc.gridy = n2;
        this.gbc.ipadx = 70;
        this.gbc.weightx = 0.1;
        this.gbc.insets = new Insets(0, 4, 5, 0);
        jPanel.add((Component)jComboBox, this.gbc);
    }

    public void addJLabel(JPanel jPanel, JLabel jLabel, String string, int n, int n2, int n3) {
        jLabel.setBackground(new Color(255, 255, 255));
        jLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jLabel.setOpaque(true);
        jLabel.setPreferredSize(new Dimension(5, 20));
        jLabel.setText(" " + string);
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 21;
        this.gbc.fill = 2;
        this.gbc.gridx = n;
        this.gbc.gridy = n2;
        this.gbc.ipadx = 70;
        this.gbc.weightx = 0.1;
        this.gbc.insets = new Insets(0, n3, 5, 0);
        jPanel.add((Component)jLabel, this.gbc);
    }

    public void addJTextField(JPanel jPanel, JTextField jTextField, boolean bl, int n, int n2) {
        jTextField.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jTextField.setPreferredSize(new Dimension(5, 20));
        jTextField.setEditable(bl);
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 21;
        this.gbc.fill = 2;
        this.gbc.gridx = n;
        this.gbc.gridy = n2;
        this.gbc.ipadx = 70;
        this.gbc.weightx = 0.1;
        this.gbc.insets = new Insets(0, 4, 5, 0);
        jPanel.add((Component)jTextField, this.gbc);
    }

    public void addHeader(JPanel jPanel, final JPanel jPanel2, final JToggleButton jToggleButton, String string, final String string2) {
        JLabel jLabel = new JLabel();
        JSeparator jSeparator = new JSeparator();
        jPanel.setName(string);
        this.addSHbutton(jPanel, jToggleButton, 0, 0);
        this.addSectionTitle(jPanel, jLabel, string, 0);
        this.addSeparator(jPanel, jSeparator, 1);
        jPanel2.setLayout(new GridBagLayout());
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jPanel2.setVisible(!jToggleButton.isSelected());
                ShowHide.checkAllButtons(string2);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 23;
        this.gbc.weightx = 0.1;
        this.gbc.insets = new Insets(0, 0, 12, 0);
        jPanel.add((Component)jPanel2, this.gbc);
    }

    public void addFiller(JPanel jPanel, Box.Filler filler, int n) {
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = n;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 3;
        this.gbc.weighty = 0.1;
        jPanel.add((Component)filler, this.gbc);
    }

    public void addInnerPanel(JPanel jPanel, JPanel jPanel2, JToggleButton jToggleButton, JLabel jLabel, JTextField jTextField, String string, int n) {
        jToggleButton.setSelected(true);
        jPanel2.setVisible(false);
        this.addSHbutton(jPanel, jToggleButton, 0, n);
        this.addJLabel(jPanel, jLabel, string, 1, n, 0);
        this.addJTextField(jPanel, jTextField, false, 2, n);
        jPanel2.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = n + 1;
        this.gbc.gridwidth = 2;
        this.gbc.fill = 2;
        this.gbc.weightx = 0.1;
        jPanel.add((Component)jPanel2, this.gbc);
    }

    public void addSectionPanel(JPanel jPanel, JPanel jPanel2, int n) {
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = n;
        this.gbc.fill = 2;
        this.gbc.weightx = 0.1;
        jPanel.add((Component)jPanel2, this.gbc);
    }

    public void addLabelComboBox(JPanel jPanel, JLabel jLabel, String string, JComboBox jComboBox, String[] stringArray, int n, int n2, int n3) {
        this.addJLabel(jPanel, jLabel, string, n2, n3, n);
        this.addJComboBox(jPanel, jComboBox, stringArray, n2 + 1, n3);
    }

    public void addLabelTextField(JPanel jPanel, JLabel jLabel, String string, JTextField jTextField, boolean bl, int n, int n2, int n3) {
        this.addJLabel(jPanel, jLabel, string, n2, n3, n);
        this.addJTextField(jPanel, jTextField, bl, n2 + 1, n3);
    }

    public void addLabelColorField(JPanel jPanel, JLabel jLabel, String string, JDialog jDialog, JLabel jLabel2, JPanel jPanel2, JButton jButton, int n, int n2, int n3) {
        this.addJLabel(jPanel, jLabel, string, n2, n3, n);
        this.addColorField(jPanel, jPanel2, jDialog, jButton, jLabel2, n2 + 1, n3);
    }

    public void add3CheckBoxField(JPanel jPanel, JPanel jPanel2, JCheckBox jCheckBox, JCheckBox jCheckBox2, JCheckBox jCheckBox3, int n, int n2) {
        jPanel2.setBackground(new Color(255, 255, 255));
        jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jPanel2.setPreferredSize(new Dimension(5, 20));
        jPanel2.setLayout(new GridBagLayout());
        jCheckBox.setIconTextGap(0);
        jCheckBox.setText("X");
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(0, 0, 4, 6);
        jPanel2.add((Component)jCheckBox, this.gbc);
        jCheckBox2.setIconTextGap(0);
        jCheckBox2.setText("Y");
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(0, 0, 4, 6);
        jPanel2.add((Component)jCheckBox2, this.gbc);
        jCheckBox3.setIconTextGap(0);
        jCheckBox3.setText("Z");
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(0, 0, 4, 0);
        jPanel2.add((Component)jCheckBox3, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = n;
        this.gbc.gridy = n2;
        this.gbc.fill = 2;
        this.gbc.ipadx = 70;
        this.gbc.insets = new Insets(0, 4, 5, 0);
        jPanel.add((Component)jPanel2, this.gbc);
    }

    public void addLabel3CheckBox(JPanel jPanel, JLabel jLabel, String string, JPanel jPanel2, JCheckBox jCheckBox, JCheckBox jCheckBox2, JCheckBox jCheckBox3, int n, int n2, int n3) {
        this.addJLabel(jPanel, jLabel, string, n2, n3, n);
        this.add3CheckBoxField(jPanel, jPanel2, jCheckBox, jCheckBox2, jCheckBox3, n2 + 1, n3);
    }
}

