/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.tabfactory;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.JTextArea;
import org.flexdock.docking.DockableFactory;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.jvm.LoadClassPath;
import org.scilab.modules.localization.Messages;

public class ScilabTabFactory
extends DockableFactory.Stub {
    private static final ScilabTabFactory instance = new ScilabTabFactory();
    private static final String EMPTYTAB = Messages.gettext((String)"Empty tab");
    private static final String NULLUUID = new UUID(0L, 0L).toString();
    private static final String ERROR = Messages.gettext((String)"The tab with uuid %s cannot be restored.\nPlease report a bug with the previous message and in attaching the file %s.");
    private Map<String, SwingScilabDockablePanel> cache = new HashMap<String, SwingScilabDockablePanel>();
    private Map<String, AbstractScilabTabFactory> factories = new HashMap<String, AbstractScilabTabFactory>();

    protected ScilabTabFactory() {
    }

    public Component getDockableComponent(String string) {
        return this.getTab(string);
    }

    public void addTabFactory(AbstractScilabTabFactory abstractScilabTabFactory) {
        if (!this.factories.containsKey(abstractScilabTabFactory.getClassName())) {
            this.factories.put(abstractScilabTabFactory.getClassName(), abstractScilabTabFactory);
        }
    }

    public AbstractScilabTabFactory addTabFactory(String string, String string2) {
        AbstractScilabTabFactory abstractScilabTabFactory = null;
        if (!this.factories.containsKey(string2)) {
            if (string != null && !string.isEmpty()) {
                LoadClassPath.loadOnUse((String)string);
            }
            try {
                Class<?> clazz = Class.forName(string2);
                abstractScilabTabFactory = (AbstractScilabTabFactory)clazz.newInstance();
                this.addTabFactory(abstractScilabTabFactory);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                System.out.println(instantiationException);
            }
        }
        return abstractScilabTabFactory;
    }

    public void removeTabFactory(AbstractScilabTabFactory abstractScilabTabFactory) {
        this.factories.values().remove(abstractScilabTabFactory);
    }

    public SwingScilabDockablePanel getTab(String string) {
        SwingScilabDockablePanel swingScilabDockablePanel = this.cache.get(string);
        if (swingScilabDockablePanel != null) {
            return swingScilabDockablePanel;
        }
        for (String string2 : this.factories.keySet()) {
            AbstractScilabTabFactory abstractScilabTabFactory = this.factories.get(string2);
            if (!abstractScilabTabFactory.isAValidUUID(string) || (swingScilabDockablePanel = abstractScilabTabFactory.getTab(string)) == null) continue;
            this.cache.put(string, swingScilabDockablePanel);
            return swingScilabDockablePanel;
        }
        WindowsConfigurationManager.removeNode(string);
        return ScilabTabFactory.makeEmptyTab(string);
    }

    public String getPackage(String string) {
        for (String string2 : this.factories.keySet()) {
            if (!this.factories.get(string2).isAValidUUID(string)) continue;
            return this.factories.get(string2).getPackage();
        }
        return "";
    }

    public String getClassName(String string) {
        for (String string2 : this.factories.keySet()) {
            if (!this.factories.get(string2).isAValidUUID(string)) continue;
            return this.factories.get(string2).getClassName();
        }
        return "";
    }

    public String getApplication(String string) {
        for (String string2 : this.factories.keySet()) {
            if (!this.factories.get(string2).isAValidUUID(string)) continue;
            return this.factories.get(string2).getApplication();
        }
        return "";
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void removeFromCache(String string) {
        this.cache.remove(string);
    }

    public SwingScilabDockablePanel getFromCache(String string) {
        return this.cache.get(string);
    }

    public void addToCache(SwingScilabDockablePanel swingScilabDockablePanel) {
        if (swingScilabDockablePanel != null) {
            this.cache.put(swingScilabDockablePanel.getPersistentId(), swingScilabDockablePanel);
        }
    }

    public static ScilabTabFactory getInstance() {
        return instance;
    }

    private static final SwingScilabDockablePanel makeEmptyTab(String string) {
        String string2 = string;
        if (string == null || string.isEmpty()) {
            string2 = NULLUUID;
        }
        SwingScilabDockablePanel swingScilabDockablePanel = new SwingScilabDockablePanel(EMPTYTAB, string2);
        String string3 = String.format(ERROR, string2, System.getProperty("user.home"));
        JTextArea jTextArea = new JTextArea(string3);
        jTextArea.setEditable(false);
        swingScilabDockablePanel.setContentPane(jTextArea);
        return swingScilabDockablePanel;
    }
}

