/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.tree;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.scilab.modules.gui.tree.ScilabTree;
import org.scilab.modules.gui.tree.Tree;

public class ScilabDisplayTree {
    private static String[][] myShapedTree;

    private ScilabDisplayTree() {
    }

    public static void scilabDisplayTree(String[] stringArray) {
        myShapedTree = ScilabDisplayTree.treeShaping(stringArray);
        ScilabDisplayTree.createGraphicTree();
    }

    public static Tree uicontrolScilabDisplayTree(String[] stringArray) {
        myShapedTree = ScilabDisplayTree.treeShaping(stringArray);
        ScilabTree scilabTree = ScilabDisplayTree.createTree(myShapedTree);
        return scilabTree;
    }

    public static String[][] treeShaping(String[] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][3];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i][0] = stringArray[i];
            if (i % 4 != 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ".");
            n = stringTokenizer.countTokens() - 1;
            stringArray2[i][1] = "" + n;
            if (n == 0) {
                stringArray2[i][2] = "root";
                continue;
            }
            n2 = stringArray[i].lastIndexOf(".");
            stringArray2[i][2] = stringArray[i].substring(0, n2);
        }
        return stringArray2;
    }

    public static void createGraphicTree() {
        ScilabTree scilabTree = ScilabDisplayTree.createTree(myShapedTree);
        scilabTree.showTree();
    }

    public static int getTreeDepth(String[][] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i % 4 != 0 || i <= 0 || Integer.parseInt(stringArray[i][1]) <= n) continue;
            n = Integer.parseInt(stringArray[i][1]);
        }
        return n;
    }

    public static ScilabTree createTree(String[][] stringArray) {
        ScilabTree scilabTree = null;
        Hashtable<String, ScilabTree> hashtable = new Hashtable<String, ScilabTree>();
        scilabTree = new ScilabTree(stringArray[1][0], stringArray[2][0], stringArray[3][0]);
        hashtable.put(stringArray[0][0], scilabTree);
        for (int i = 4; i < stringArray.length; i += 4) {
            scilabTree = new ScilabTree(stringArray[i + 1][0], stringArray[i + 2][0], stringArray[i + 3][0]);
            hashtable.put(stringArray[i][0], scilabTree);
            ((ScilabTree)hashtable.get(stringArray[i][2])).addChild(scilabTree);
        }
        return (ScilabTree)hashtable.get(stringArray[0][0]);
    }
}

