/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import org.scilab.modules.graphic_objects.graphicController.GraphicController;
import org.scilab.modules.gui.SwingViewObject;
import org.scilab.modules.gui.bridge.CallScilabBridge;
import org.scilab.modules.gui.widget.Widget;

public final class UnitsConverter {
    private static double POINT_PER_INCH = 72.0;
    private static double CM_PER_INCH = 2.54;
    protected static final String __GO_UI_POINTS_UNITS__ = "points";
    protected static final String __GO_UI_NORMALIZED_UNITS__ = "normalized";
    protected static final String __GO_UI_INCHES_UNITS__ = "inches";
    protected static final String __GO_UI_CENTIMETERS_UNITS__ = "centimeters";
    protected static final String __GO_UI_PIXELS_UNITS__ = "pixels";

    public static UicontrolUnits stringToUnitsEnum(String string) {
        if (string.compareTo(__GO_UI_POINTS_UNITS__) == 0) {
            return UicontrolUnits.POINTS;
        }
        if (string.compareTo(__GO_UI_NORMALIZED_UNITS__) == 0) {
            return UicontrolUnits.NORMALIZED;
        }
        if (string.compareTo(__GO_UI_INCHES_UNITS__) == 0) {
            return UicontrolUnits.INCHES;
        }
        if (string.compareTo(__GO_UI_CENTIMETERS_UNITS__) == 0) {
            return UicontrolUnits.CENTIMETERS;
        }
        if (string.compareTo(__GO_UI_PIXELS_UNITS__) == 0) {
            return UicontrolUnits.PIXELS;
        }
        return null;
    }

    public static double convertFromPoint(double d, UicontrolUnits uicontrolUnits, Widget widget, boolean bl) {
        int n = 0;
        SwingViewObject swingViewObject = (SwingViewObject)((Object)widget);
        int n2 = (Integer)GraphicController.getController().getProperty(swingViewObject.getId(), 29);
        if (n2 == 8) {
            uicontrolUnits = UicontrolUnits.PIXELS;
        }
        switch (uicontrolUnits) {
            case POINTS: {
                return d;
            }
            case NORMALIZED: {
                Component component = (Component)((Object)widget);
                Dimension dimension = component.getParent().getSize();
                n = bl ? dimension.width : dimension.height;
                return d / ((double)n * POINT_PER_INCH / (double)CallScilabBridge.getScreenResolution());
            }
            case INCHES: {
                return d / POINT_PER_INCH;
            }
            case CENTIMETERS: {
                return d * CM_PER_INCH / POINT_PER_INCH;
            }
            case PIXELS: {
                return d * (double)CallScilabBridge.getScreenResolution() / POINT_PER_INCH;
            }
        }
        return 0.0;
    }

    public static double convertToPoint(double d, UicontrolUnits uicontrolUnits, Widget widget, boolean bl) {
        int n = 0;
        SwingViewObject swingViewObject = (SwingViewObject)((Object)widget);
        int n2 = (Integer)GraphicController.getController().getProperty(swingViewObject.getId(), 29);
        if (n2 == 8) {
            uicontrolUnits = UicontrolUnits.PIXELS;
        }
        switch (uicontrolUnits) {
            case POINTS: {
                return (int)d;
            }
            case NORMALIZED: {
                Component component = (Component)((Object)widget);
                Dimension dimension = component.getParent().getSize();
                n = bl ? dimension.width : dimension.height;
                return d * (double)n * POINT_PER_INCH / (double)CallScilabBridge.getScreenResolution();
            }
            case INCHES: {
                return d * POINT_PER_INCH;
            }
            case CENTIMETERS: {
                return d * POINT_PER_INCH / CM_PER_INCH;
            }
            case PIXELS: {
                return Math.round(d * POINT_PER_INCH / (double)CallScilabBridge.getScreenResolution());
            }
        }
        return 0.0;
    }

    public static double convertFromPixel(int n, UicontrolUnits uicontrolUnits, Widget widget, boolean bl) {
        if (widget == null) {
            return n;
        }
        SwingViewObject swingViewObject = (SwingViewObject)((Object)widget);
        int n2 = (Integer)GraphicController.getController().getProperty(swingViewObject.getId(), 29);
        if (widget != null && n2 == 8) {
            uicontrolUnits = UicontrolUnits.PIXELS;
        }
        if (uicontrolUnits == UicontrolUnits.PIXELS) {
            return n;
        }
        return UnitsConverter.convertFromPoint(UnitsConverter.convertToPoint(n, UicontrolUnits.PIXELS, widget, bl), uicontrolUnits, widget, bl);
    }

    public static int convertToPixel(double d, UicontrolUnits uicontrolUnits, Widget widget, boolean bl) {
        SwingViewObject swingViewObject = (SwingViewObject)((Object)widget);
        int n = (Integer)GraphicController.getController().getProperty(swingViewObject.getId(), 29);
        if (widget != null && n == 8) {
            uicontrolUnits = UicontrolUnits.PIXELS;
        }
        if (uicontrolUnits == UicontrolUnits.PIXELS) {
            return (int)d;
        }
        return (int)UnitsConverter.convertFromPoint(UnitsConverter.convertToPoint(d, uicontrolUnits, widget, bl), UicontrolUnits.PIXELS, widget, bl);
    }

    public static Double[] convertPositionToPixels(Double[] doubleArray, UicontrolUnits uicontrolUnits, Widget widget) {
        Double[] doubleArray2 = new Double[]{new Double(UnitsConverter.convertToPixel(doubleArray[0], uicontrolUnits, widget, true)), new Double(UnitsConverter.convertToPixel(doubleArray[1], uicontrolUnits, widget, false)), new Double(UnitsConverter.convertToPixel(doubleArray[2], uicontrolUnits, widget, true)), new Double(UnitsConverter.convertToPixel(doubleArray[3], uicontrolUnits, widget, false))};
        return doubleArray2;
    }

    public static enum UicontrolUnits {
        POINTS,
        NORMALIZED,
        INCHES,
        CENTIMETERS,
        PIXELS;

    }
}

