/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.SwingUtilities;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.activation.ActiveDockableTracker;
import org.flexdock.docking.state.LayoutNode;
import org.flexdock.perspective.persist.xml.LayoutNodeSerializer;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.commons.xml.ScilabXPathFactory;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.commons.xml.XConfigurationEvent;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.console.ScilabConsole;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.Tab;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.utils.BarUpdater;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WindowsConfigurationManager
implements XConfigurationListener {
    private static final String RESTORATION_ERROR = Messages.gettext((String)"Restoration error");
    private static final String ERROR_IN_LOADING = Messages.gettext((String)"The configuration file has been corrupted and reset to the default one.");
    private static final String FATAL_ERROR = Messages.gettext((String)"The configuration file has been corrupted. Scilab needs to restart.");
    private static final int DEFAULTX = 0;
    private static final int DEFAULTY = 0;
    private static final int DEFAULTHEIGHT = 500;
    private static final int DEFAULTWIDTH = 500;
    private static final String LAYOUT_PATH = "//general/desktop-layout/body/layouts";
    private static final String SCI = "SCI";
    private static final String WINDOWS_CONFIG_FILE = System.getenv("SCI") + "/modules/gui/etc/windowsConfiguration.xml";
    private static final String DEFAULT_WINDOWS_CONFIG_FILE = System.getenv("SCI") + "/modules/gui/etc/integratedConfiguration.xml";
    private static final String NULLUUID = new UUID(0L, 0L).toString();
    private static final Map<SwingScilabDockablePanel, EndedRestoration> endedRestoration = new HashMap<SwingScilabDockablePanel, EndedRestoration>();
    private static final List<String> alreadyRestoredWindows = new ArrayList<String>();
    private static final Map<String, Object> defaultWinAttributes = new HashMap<String, Object>();
    private static final List<String> currentlyRestored = new ArrayList<String>();
    private static String USER_WINDOWS_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/windowsConfiguration.xml";
    private static boolean oneTry;
    private static Document doc;
    private static boolean mustInvalidate;
    private static boolean mustSave;
    private static int layoutId;

    private WindowsConfigurationManager() {
        XConfiguration.addXConfigurationListener((XConfigurationListener)this);
    }

    public static void resetLayout() {
        mustInvalidate = true;
    }

    public void configurationChanged(XConfigurationEvent xConfigurationEvent) {
        if (xConfigurationEvent.getModifiedPaths().contains(LAYOUT_PATH)) {
            Options options = WindowsConfigurationManager.getOptions();
            if (options.id != layoutId) {
                mustInvalidate = true;
                layoutId = options.id;
            }
            mustSave = options.mustSave;
        }
    }

    public static String getLayoutFilePath() {
        try {
            XPath xPath;
            NodeList nodeList;
            Document document = XConfiguration.getXConfigurationDocument();
            if (document != null && (nodeList = (NodeList)(xPath = ScilabXPathFactory.newInstance().newXPath()).compile("//general/desktop-layout/body/layouts/layout[@id=../@id]/@path").evaluate(document, XPathConstants.NODESET)) != null && nodeList.getLength() > 0) {
                return nodeList.item(0).getNodeValue().replace("$SCI", System.getenv(SCI));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return WINDOWS_CONFIG_FILE;
    }

    public static void createUserCopy() {
        if (WindowsConfigurationManager.isCopyNeeded() && mustSave) {
            ScilabCommonsUtils.copyFile((File)new File(WindowsConfigurationManager.getLayoutFilePath()), (File)new File(USER_WINDOWS_CONFIG_FILE));
            doc = null;
        }
    }

    private static void readDocument() {
        Object object;
        if (doc == null) {
            WindowsConfigurationManager.createUserCopy();
            doc = ScilabXMLUtilities.readDocument((String)USER_WINDOWS_CONFIG_FILE);
            object = WindowsConfigurationManager.getOptions();
            if (mustSave) {
                mustSave = ((Options)object).mustSave;
            }
            layoutId = ((Options)object).id;
        }
        if (doc == null && !oneTry) {
            WindowsConfigurationManager.reload();
        } else if (doc == null && oneTry) {
            System.err.println("Serious problem to copy and parse the configuration file.");
            System.err.println("Please check if you have the rights to write the file: " + USER_WINDOWS_CONFIG_FILE);
            System.err.println("If the previous file exists, please check if it is a valid XML");
            System.err.println("and if yes, please report a bug: https://gitlab.com/scilab/scilab/-/issues");
        } else if (doc != null) {
            object = doc.getDocumentElement();
            List list = ScilabXMLUtilities.getElementsWithAttributeEquals((Element)object, (String)"uuid", (String)NULLUUID);
            if (list == null || list.isEmpty() || list.size() >= 2) {
                WindowsConfigurationManager.reload();
            } else {
                Element element = (Element)list.get(0);
                if (element == null || !"org.scilab.modules.core.ConsoleTabFactory".equals(element.getAttribute("factory"))) {
                    WindowsConfigurationManager.reload();
                }
            }
        }
    }

    private static void displayLoadError() {
        System.err.println("Try to reload the default configuration file.");
        ScilabModalDialog.show(null, ERROR_IN_LOADING, RESTORATION_ERROR, ScilabModalDialog.IconType.ERROR_ICON);
    }

    private static void displayFatalError() {
        System.err.println("The configuration file is severely corrupted and cannot be read. It will be deleted.");
        ScilabModalDialog.show(null, FATAL_ERROR, RESTORATION_ERROR, ScilabModalDialog.IconType.ERROR_ICON);
    }

    private static void deleteConfFile() {
        File file = new File(USER_WINDOWS_CONFIG_FILE);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    private static void reload() {
        doc = null;
        WindowsConfigurationManager.displayLoadError();
        WindowsConfigurationManager.deleteConfFile();
        oneTry = true;
        WindowsConfigurationManager.readDocument();
    }

    private static void killScilab() {
        WindowsConfigurationManager.deleteConfFile();
        WindowsConfigurationManager.displayFatalError();
        System.exit(1);
    }

    private static void writeDocument() {
        if (mustSave) {
            ScilabXMLUtilities.writeDocument((Document)doc, (String)USER_WINDOWS_CONFIG_FILE);
        }
    }

    private static final boolean isCopyNeeded() {
        return !new File(USER_WINDOWS_CONFIG_FILE).exists();
    }

    public static void registerEndedRestoration(SwingScilabDockablePanel swingScilabDockablePanel, EndedRestoration endedRestoration) {
        WindowsConfigurationManager.endedRestoration.put(swingScilabDockablePanel, endedRestoration);
    }

    public static void unregisterEndedRestoration(SwingScilabDockablePanel swingScilabDockablePanel) {
        endedRestoration.remove(swingScilabDockablePanel);
    }

    public static void registerEndedRestoration(Tab tab, EndedRestoration endedRestoration) {
        WindowsConfigurationManager.registerEndedRestoration((SwingScilabDockablePanel)tab.getAsSimpleTab(), endedRestoration);
    }

    public static Element createNode(Element element, String string, Object[] objectArray) {
        WindowsConfigurationManager.readDocument();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!objectArray[i].equals("uuid")) continue;
            WindowsConfigurationManager.removeNode(element, string, (String)objectArray[i + 1]);
        }
        return ScilabXMLUtilities.createNode((Document)doc, (Element)element, (String)string, (Object[])objectArray);
    }

    public static void saveWindowProperties(SwingScilabWindow swingScilabWindow) {
        if (ScilabConstants.isGUI()) {
            WindowsConfigurationManager.readDocument();
            Element element = doc.getDocumentElement();
            Element element2 = WindowsConfigurationManager.createNode(element, "Window", new Object[]{"uuid", swingScilabWindow.getUUID(), "x", (int)swingScilabWindow.getLastPosition().getX(), "y", (int)swingScilabWindow.getLastPosition().getY(), "width", (int)swingScilabWindow.getLastDimension().getWidth(), "height", (int)swingScilabWindow.getLastDimension().getHeight(), "state", swingScilabWindow.getExtendedState()});
            LayoutNode layoutNode = swingScilabWindow.getDockingPort().exportLayout();
            LayoutNodeSerializer layoutNodeSerializer = new LayoutNodeSerializer();
            element2.appendChild(layoutNodeSerializer.serialize(doc, (Object)layoutNode));
            for (Dockable dockable : swingScilabWindow.getDockingPort().getDockables()) {
                WindowsConfigurationManager.saveTabProperties((SwingScilabDockablePanel)dockable, false);
            }
            WindowsConfigurationManager.writeDocument();
        }
    }

    public static SwingScilabWindow createWindow(String string, boolean bl) {
        WindowsConfigurationManager.readDocument();
        Element element = doc.getDocumentElement();
        boolean bl2 = string.equals(NULLUUID);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Element element2 = null;
        boolean bl3 = true;
        if (!bl2) {
            element2 = WindowsConfigurationManager.getElementWithUUID(element, "Window", string);
            if (element2 == null) {
                return null;
            }
            boolean bl4 = bl3 = !element2.getAttribute("x").equals("");
            if (bl3) {
                hashMap.put("x", Integer.TYPE);
                hashMap.put("y", Integer.TYPE);
            }
            hashMap.put("height", Integer.TYPE);
            hashMap.put("width", Integer.TYPE);
            hashMap.put("state", Integer.TYPE);
            ScilabXMLUtilities.readNodeAttributes((Element)element2, hashMap);
        } else {
            hashMap.putAll(defaultWinAttributes);
        }
        SwingScilabWindow swingScilabWindow = SwingScilabWindow.createWindow(true);
        swingScilabWindow.setVisible(false);
        String string2 = bl ? string : UUID.randomUUID().toString();
        swingScilabWindow.setUUID(string2);
        boolean bl5 = false;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (bl3) {
            Point point = new Point((Integer)hashMap.get("x"), (Integer)hashMap.get("y"));
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
                Rectangle rectangle = graphicsDevice.getDefaultConfiguration().getBounds();
                if (rectangle == null || !rectangle.contains(point)) continue;
                bl5 = true;
                swingScilabWindow.setLocation(point.x, point.y);
                break;
            }
        }
        int n = (Integer)hashMap.get("width");
        int n2 = (Integer)hashMap.get("height");
        if (!bl5) {
            Rectangle rectangle = graphicsDeviceArray[0].getDefaultConfiguration().getBounds();
            int n3 = (int)(rectangle.getX() + rectangle.getWidth() / 2.0 - (double)n / 2.0);
            int n4 = (int)(rectangle.getY() + rectangle.getHeight() / 2.0 - (double)n2 / 2.0);
            swingScilabWindow.setBounds(n3, n4, n, n2);
        } else {
            swingScilabWindow.setSize(n, n2);
        }
        int n5 = (Integer)hashMap.get("state");
        if ((n5 & 1) == 1) {
            --n5;
        }
        swingScilabWindow.setExtendedState(n5);
        return swingScilabWindow;
    }

    public static SwingScilabWindow restoreWindow(String string) {
        String string2 = UUID.randomUUID().toString();
        SwingScilabWindow swingScilabWindow = SwingScilabWindow.createWindow(true);
        swingScilabWindow.setUUID(string2);
        swingScilabWindow.setIsRestoring(true);
        final SwingScilabDockablePanel swingScilabDockablePanel = ScilabTabFactory.getInstance().getTab(string);
        swingScilabWindow.addTab(swingScilabDockablePanel);
        BarUpdater.forceUpdateBars(swingScilabDockablePanel.getParentWindowId(), swingScilabDockablePanel.getMenuBar(), swingScilabDockablePanel.getToolBar(), swingScilabDockablePanel.getInfoBar(), swingScilabDockablePanel.getName(), swingScilabDockablePanel.getWindowIcon());
        swingScilabWindow.pack();
        swingScilabWindow.setVisible(true);
        swingScilabWindow.requestFocus();
        swingScilabWindow.toFront();
        swingScilabWindow.setIsRestoring(false);
        endedRestoration.remove(swingScilabDockablePanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActiveDockableTracker.requestDockableActivation((Component)((Object)swingScilabDockablePanel));
            }
        });
        return swingScilabWindow;
    }

    public static SwingScilabWindow restoreWindow(String string, String string2, boolean bl, boolean bl2) {
        WindowsConfigurationManager.readDocument();
        boolean bl3 = string.equals(NULLUUID);
        final SwingScilabWindow swingScilabWindow = WindowsConfigurationManager.createWindow(string, !bl3);
        if (swingScilabWindow == null) {
            return null;
        }
        swingScilabWindow.setIsRestoring(true);
        if (bl) {
            Object object42;
            Object object2;
            if (!bl3) {
                object2 = new LayoutNodeSerializer();
                object42 = WindowsConfigurationManager.getDockingPort(string);
                LayoutNode object3 = (LayoutNode)object2.deserialize((Element)object42);
                swingScilabWindow.getDockingPort().importLayout(object3);
            } else if (string2 != null && !string2.isEmpty()) {
                object2 = ScilabTabFactory.getInstance().getTab(string2);
                ((SwingScilabDockablePanel)object2).setParentWindowId(swingScilabWindow.getId());
                DockingManager.dock((Component)object2, (DockingPort)swingScilabWindow.getDockingPort());
            }
            for (Object object42 : swingScilabWindow.getDockingPort().getDockables()) {
                ((SwingScilabDockablePanel)object42).setParentWindowId(swingScilabWindow.getId());
            }
            object2 = new SwingScilabDockablePanel[swingScilabWindow.getNbDockedObjects()];
            object2 = (SwingScilabDockablePanel[])swingScilabWindow.getDockingPort().getDockables().toArray((T[])object2);
            object42 = ClosingOperationsManager.getElderTab(new ArrayList<SwingScilabDockablePanel>(Arrays.asList(object2)));
            BarUpdater.forceUpdateBars(((SwingScilabDockablePanel)object42).getParentWindowId(), ((SwingScilabDockablePanel)object42).getMenuBar(), ((SwingScilabDockablePanel)object42).getToolBar(), ((SwingScilabDockablePanel)object42).getInfoBar(), ((SwingScilabDockablePanel)object42).getName(), ((SwingScilabDockablePanel)object42).getWindowIcon());
            if (!ScilabConsole.isExistingConsole() && ((Object)object2).length == 1 && object2[0].getPersistentId().equals(NULLUUID)) {
                return null;
            }
            for (Object object : object2) {
                EndedRestoration endedRestoration = WindowsConfigurationManager.endedRestoration.get(object);
                if (endedRestoration == null) continue;
                endedRestoration.finish();
                WindowsConfigurationManager.endedRestoration.remove(object);
            }
            if (((Object)object2).length == 1) {
                SwingScilabDockablePanel.removeActions((SwingScilabDockablePanel)object2[0]);
            } else {
                for (Object object : object2) {
                    SwingScilabDockablePanel.addActions((SwingScilabDockablePanel)object);
                }
            }
            if (bl2) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ SwingScilabDockablePanel val$mainTab;
                    {
                        this.val$mainTab = swingScilabDockablePanel;
                    }

                    @Override
                    public void run() {
                        Thread thread = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                List<String> list = currentlyRestored;
                                synchronized (list) {
                                    while (currentlyRestored.size() > 0) {
                                        try {
                                            currentlyRestored.wait();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            interruptedException.printStackTrace();
                                        }
                                    }
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        swingScilabWindow.setVisible(true);
                                        swingScilabWindow.requestFocus();
                                        swingScilabWindow.toFront();
                                        swingScilabWindow.setIsRestoring(false);
                                        ActiveDockableTracker.requestDockableActivation((Component)((Object)val$mainTab));
                                    }
                                });
                            }
                        });
                        thread.start();
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        swingScilabWindow.setIsRestoring(false);
                        swingScilabWindow.setVisible(true);
                    }
                });
            }
        }
        return swingScilabWindow;
    }

    private static final Element getDockingPort(String string) {
        WindowsConfigurationManager.readDocument();
        Element element = doc.getDocumentElement();
        Element element2 = WindowsConfigurationManager.getElementWithUUID(element, "Window", string);
        if (element2 == null) {
            return null;
        }
        NodeList nodeList = element2.getElementsByTagName("DockingPortNode");
        return (Element)nodeList.item(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void restorationFinished(SwingScilabDockablePanel swingScilabDockablePanel) {
        List<String> list = currentlyRestored;
        synchronized (list) {
            currentlyRestored.remove(swingScilabDockablePanel.getPersistentId());
            currentlyRestored.notify();
        }
    }

    public static final void removeWin(String string) {
        alreadyRestoredWindows.remove(string);
    }

    public static final Set<Element> getTabDependencies(String string) {
        WindowsConfigurationManager.readDocument();
        Element element = doc.getDocumentElement();
        List list = ScilabXMLUtilities.getElementsWithAttributeEquals((Element)element, (String)"depends", (String)string);
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        Element element2 = WindowsConfigurationManager.getElementWithUUID(doc.getDocumentElement(), string);
        if (element2 != null) {
            linkedHashSet.add(element2);
            for (Element element3 : list) {
                linkedHashSet.addAll(WindowsConfigurationManager.getTabDependencies(element3.getAttribute("uuid")));
            }
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set<Element> createDescendantTabs(String string) {
        Set<Element> set = WindowsConfigurationManager.getTabDependencies(string);
        Dimension dimension = new Dimension(0, 0);
        for (Element element : set) {
            ScilabTabFactory scilabTabFactory = ScilabTabFactory.getInstance();
            scilabTabFactory.addTabFactory(element.getAttribute("load"), element.getAttribute("factory"));
            Object object = currentlyRestored;
            synchronized (object) {
                currentlyRestored.add(element.getAttribute("uuid"));
            }
            object = scilabTabFactory.getTab(element.getAttribute("uuid"));
            if (element.getAttribute("width").isEmpty() || element.getAttribute("height").isEmpty()) continue;
            object.setMinimumSize(dimension);
            object.setPreferredSize(new Dimension(Integer.parseInt(element.getAttribute("width")), Integer.parseInt(element.getAttribute("width"))));
        }
        return set;
    }

    private static final Set<Element> createAdjacentTabs(Set<Element> set) {
        WindowsConfigurationManager.readDocument();
        Element element = doc.getDocumentElement();
        boolean bl = true;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Element element2 : set) {
            String string = element2.getAttribute("winuuid");
            if (string.isEmpty() || string.equals(NULLUUID)) continue;
            List list = ScilabXMLUtilities.getElementsWithAttributeEquals((Element)element, (String)"winuuid", (String)string);
            list.removeAll(set);
            bl = bl && list.size() == 0;
            linkedHashSet.addAll(list);
        }
        if (bl) {
            return set;
        }
        for (Element element2 : linkedHashSet) {
            set.addAll(WindowsConfigurationManager.createDescendantTabs(WindowsConfigurationManager.getElderParent(element2).getAttribute("uuid")));
        }
        return WindowsConfigurationManager.createAdjacentTabs(set);
    }

    private static final Element getElderParent(Element element) {
        WindowsConfigurationManager.readDocument();
        Element element2 = doc.getDocumentElement();
        String string = element.getAttribute("depends");
        if (!string.isEmpty()) {
            return WindowsConfigurationManager.getElderParent((Element)ScilabXMLUtilities.getElementsWithAttributeEquals((Element)element2, (String)"uuid", (String)string).get(0));
        }
        return element;
    }

    private static final void startRestoration(String string) {
        Object object;
        Object object3;
        Object object4;
        Set<Element> set;
        if (!ScilabConstants.isGUI()) {
            WindowsConfigurationManager.readDocument();
            set = doc.getDocumentElement();
            object4 = (Element)ScilabXMLUtilities.getElementsWithAttributeEquals(set, (String)"uuid", (String)string).get(0);
            if (object4 != null && !((String)(object3 = object4.getAttribute("winuuid"))).isEmpty() && !((String)object3).equals(NULLUUID)) {
                List list = ScilabXMLUtilities.getElementsWithAttributeEquals(set, (String)"winuuid", (String)object3);
                Iterator object22 = list.iterator();
                while (object22.hasNext()) {
                    object = (Element)object22.next();
                    if (!object.getNodeName().equals("Console")) continue;
                    WindowsConfigurationManager.restoreWindow(string);
                    return;
                }
            }
        }
        set = WindowsConfigurationManager.createDescendantTabs(string);
        set = WindowsConfigurationManager.createAdjacentTabs(set);
        object4 = new ArrayList();
        object3 = new ArrayList();
        for (Element element : set) {
            object = element.getAttribute("winuuid");
            if (((String)object).equals(NULLUUID) || WindowsConfigurationManager.getElementWithUUID((String)object) == null || !WindowsConfigurationManager.isDockableIdExisting((String)object, element.getAttribute("uuid"))) {
                object3.add(element.getAttribute("uuid"));
                continue;
            }
            if (object4.contains(object)) continue;
            object4.add(object);
        }
        boolean bl = true;
        if (object4.contains(NULLUUID)) {
            object4.remove(NULLUUID);
            object4.add(NULLUUID);
        }
        Iterator iterator = object4.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (alreadyRestoredWindows.contains(object)) continue;
            WindowsConfigurationManager.restoreWindow((String)object, string, true, bl);
            alreadyRestoredWindows.add((String)object);
            if (!bl) continue;
            bl = false;
        }
        Iterator iterator2 = object3.iterator();
        while (iterator2.hasNext()) {
            object = (String)iterator2.next();
            SwingScilabWindow swingScilabWindow = WindowsConfigurationManager.restoreWindow(NULLUUID, (String)object, true, bl);
            alreadyRestoredWindows.add(swingScilabWindow.getUUID());
            if (!bl) continue;
            bl = false;
        }
    }

    public static final Element getElementWithUUID(Element element, String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName(string);
        int n = WindowsConfigurationManager.getNodeListLength(nodeList);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("uuid").equals(string2)) continue;
            return element2;
        }
        return null;
    }

    public static final Element getElementWithUUID(String string) {
        WindowsConfigurationManager.readDocument();
        return WindowsConfigurationManager.getElementWithUUID(doc.getDocumentElement(), string);
    }

    public static final Element getElementWithUUID(Element element, String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        List list = ScilabXMLUtilities.getElementsWithAttributeEquals((Element)element, (String)"uuid", (String)string);
        if (list.size() != 0) {
            return (Element)list.get(0);
        }
        return null;
    }

    public static final boolean isDockableIdExisting(String string, String string2) {
        List list;
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            return false;
        }
        Element element = WindowsConfigurationManager.getElementWithUUID(string);
        return element != null && (list = ScilabXMLUtilities.getElementsWithAttributeEquals((Element)element, (String)"dockableId", (String)string2)).size() != 0;
    }

    private static final void validateWindows() {
        int n;
        NodeList nodeList;
        Object object;
        try {
            object = ScilabXPathFactory.newInstance().newXPath();
            nodeList = (NodeList)object.compile("//text()").evaluate(doc, XPathConstants.NODESET);
            for (n = 0; n < nodeList.getLength(); ++n) {
                nodeList.item(n).getParentNode().removeChild(nodeList.item(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = doc.getDocumentElement();
        nodeList = object.getElementsByTagName("Window");
        n = WindowsConfigurationManager.getNodeListLength(nodeList);
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add((Element)nodeList.item(i));
        }
        for (Element element : arrayList) {
            WindowsConfigurationManager.validateWindow(element.getAttribute("uuid"));
        }
    }

    private static final void validateWindow(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Element element = WindowsConfigurationManager.getElementWithUUID(string);
        if (element == null) {
            return;
        }
        Element element2 = (Element)element.getFirstChild();
        if (element2 == null) {
            element.getParentNode().removeChild(element);
            return;
        }
        Element element3 = WindowsConfigurationManager.validateDockingPortNode(string, element2);
        if (element3 == null) {
            element.removeChild(element2);
            return;
        }
        element.removeChild(element2);
        element.appendChild(element3);
    }

    private static final Element validateDockingPortNode(String string, Element element) {
        Element element2 = (Element)element.getFirstChild();
        if (element2 == null) {
            return null;
        }
        if (element2.getTagName().equals("DockableNode")) {
            if ((element2 = WindowsConfigurationManager.validateDockableNode(string, element2)) == null) {
                return null;
            }
            return element;
        }
        if ((element2 = WindowsConfigurationManager.validateSplitNode(string, element2)) == null) {
            return null;
        }
        Element element3 = (Element)element.cloneNode(false);
        element3.appendChild(element2);
        return element3;
    }

    private static final Element validateDockableNode(String string, Element element) {
        String string2 = element.getAttribute("dockableId");
        Element element2 = WindowsConfigurationManager.getElementWithUUID(string2);
        if (element2 == null || !element2.getAttribute("winuuid").equals(string)) {
            return null;
        }
        return element;
    }

    private static final Element validateSplitNode(String string, Element element) {
        NodeList nodeList = element.getChildNodes();
        Element element2 = WindowsConfigurationManager.validateDockingPortNode(string, (Element)nodeList.item(0));
        Element element3 = WindowsConfigurationManager.validateDockingPortNode(string, (Element)nodeList.item(1));
        if (element2 != null && element3 != null) {
            Element element4 = (Element)element.cloneNode(false);
            element4.appendChild(element2);
            element4.appendChild(element3);
            return element4;
        }
        if (element2 == null && element3 == null) {
            return null;
        }
        if (element2 == null) {
            return (Element)element3.getFirstChild().cloneNode(true);
        }
        return (Element)element2.getFirstChild().cloneNode(true);
    }

    private static final void removeNode(Element element, String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        Element element2 = WindowsConfigurationManager.getElementWithUUID(element, string, string2);
        if (element2 != null) {
            element.removeChild(element2);
        }
    }

    public static final void removeNode(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Element element = WindowsConfigurationManager.getElementWithUUID(string);
        if (element != null && element.getParentNode() != null) {
            element.getParentNode().removeChild(element);
        }
    }

    public static void saveTabProperties(SwingScilabDockablePanel swingScilabDockablePanel, boolean bl) {
        if (ScilabConstants.isGUI()) {
            WindowsConfigurationManager.readDocument();
            ScilabTabFactory scilabTabFactory = ScilabTabFactory.getInstance();
            String string = swingScilabDockablePanel.getPersistentId();
            Element element = doc.getDocumentElement();
            String string2 = scilabTabFactory.getApplication(string);
            if (string2.isEmpty()) {
                return;
            }
            String string3 = bl ? NULLUUID : swingScilabDockablePanel.getParentWindowUUID();
            Dimension dimension = swingScilabDockablePanel.getSize();
            WindowsConfigurationManager.createNode(element, string2, new Object[]{"winuuid", string3, "uuid", string, "load", scilabTabFactory.getPackage(string), "factory", scilabTabFactory.getClassName(string), "width", (int)dimension.getWidth(), "height", (int)dimension.getHeight()});
            WindowsConfigurationManager.writeDocument();
        }
    }

    public static void clean() {
        if (ScilabConstants.isGUI()) {
            WindowsConfigurationManager.readDocument();
            WindowsConfigurationManager.validateWindows();
            Element element = doc.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            int n = WindowsConfigurationManager.getNodeListLength(nodeList);
            for (int i = 0; i < n; ++i) {
                String string;
                List list;
                if (!(nodeList.item(i) instanceof Element) || (list = ScilabXMLUtilities.getElementsWithAttributeEquals((Element)element, (String)"winuuid", (String)(string = ((Element)nodeList.item(i)).getAttribute("uuid")))) != null && list.size() != 0) continue;
                element.removeChild(nodeList.item(i));
                WindowsConfigurationManager.removeWin(string);
            }
            WindowsConfigurationManager.writeDocument();
        }
    }

    public static final void makeDependency(String string, String string2) {
        if (ScilabConstants.isGUI()) {
            WindowsConfigurationManager.readDocument();
            Element element = WindowsConfigurationManager.getElementWithUUID(doc.getDocumentElement(), string2);
            if (element != null) {
                element.setAttribute("depends", string);
            }
            WindowsConfigurationManager.writeDocument();
        }
    }

    public static void removeDependency(String string) {
        if (ScilabConstants.isGUI()) {
            WindowsConfigurationManager.readDocument();
            Element element = WindowsConfigurationManager.getElementWithUUID(doc.getDocumentElement(), string);
            if (element != null) {
                element.removeAttribute("depends");
            }
            WindowsConfigurationManager.writeDocument();
        }
    }

    public static boolean restoreUUID(final String string) {
        WindowsConfigurationManager.readDocument();
        WindowsConfigurationManager.clean();
        Element element = WindowsConfigurationManager.getElementWithUUID(string);
        if (element == null) {
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                WindowsConfigurationManager.startRestoration(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                WindowsConfigurationManager.killScilab();
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        WindowsConfigurationManager.startRestoration(string);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                WindowsConfigurationManager.killScilab();
            }
        }
        if (ScilabConstants.isGUI()) {
            WindowsConfigurationManager.writeDocument();
        }
        doc = null;
        return true;
    }

    public static String[] getApplicationUUIDs(String string) {
        WindowsConfigurationManager.readDocument();
        NodeList nodeList = doc.getDocumentElement().getElementsByTagName(string);
        String[] stringArray = new String[WindowsConfigurationManager.getNodeListLength(nodeList)];
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            stringArray[i] = element.getAttribute("uuid");
        }
        return stringArray;
    }

    private static final int getNodeListLength(NodeList nodeList) {
        int n = 0;
        try {
            n = nodeList.getLength();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n;
    }

    private static final Options getOptions() {
        return ((Options[])XConfiguration.get(Options.class, (Document)XConfiguration.getXConfigurationDocument(), (String)LAYOUT_PATH))[0];
    }

    static {
        mustSave = true;
        try {
            if (ScilabConstants.SCIHOME != null && ScilabConstants.SCIHOME.canRead() && ScilabConstants.SCIHOME.canWrite()) {
                USER_WINDOWS_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/windowsConfiguration.xml";
            } else {
                USER_WINDOWS_CONFIG_FILE = DEFAULT_WINDOWS_CONFIG_FILE;
                mustSave = false;
            }
            new WindowsConfigurationManager();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    File file;
                    if (mustInvalidate && (file = new File(USER_WINDOWS_CONFIG_FILE)).exists() && file.isFile()) {
                        file.delete();
                    }
                }
            };
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("org.scilab.modules.core.Scilab");
            Method method = clazz.getDeclaredMethod("registerFinalHook", Runnable.class);
            method.invoke(null, runnable);
            defaultWinAttributes.put("x", new Integer(0));
            defaultWinAttributes.put("y", new Integer(0));
            defaultWinAttributes.put("height", new Integer(500));
            defaultWinAttributes.put("width", new Integer(500));
            defaultWinAttributes.put("state", new Integer(0));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @XConfiguration.XConfAttribute
    private static class Options {
        public boolean mustSave;
        public int id;

        private Options() {
        }

        @XConfiguration.XConfAttribute(tag="layouts", attributes={"id", "save-desktop"})
        private void set(int n, boolean bl) {
            this.id = n;
            this.mustSave = bl;
        }
    }

    public static interface EndedRestoration {
        public void finish();
    }
}

