/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;

public class ScilabPolynomial
implements ScilabType {
    private static final long serialVersionUID = 870624048944109684L;
    private static final int VERSION = 0;
    private double[][][] realPart;
    private double[][][] imaginaryPart;
    private String varName;
    private String polyVarName = "x";
    private boolean swaped;

    public ScilabPolynomial() {
        this.realPart = null;
        this.imaginaryPart = null;
    }

    public ScilabPolynomial(double[] dArray) {
        this.realPart = new double[1][1][];
        this.realPart[0][0] = dArray;
        this.imaginaryPart = null;
    }

    public ScilabPolynomial(double[] dArray, String string) {
        this(dArray);
        this.setPolyVarName(string);
    }

    public ScilabPolynomial(double[] dArray, double[] dArray2) {
        this.realPart = new double[1][1][];
        this.realPart[0][0] = dArray;
        this.imaginaryPart = new double[1][1][];
        this.imaginaryPart[0][0] = dArray2;
    }

    public ScilabPolynomial(double[] dArray, double[] dArray2, String string) {
        this(dArray, dArray2);
        this.setPolyVarName(string);
    }

    public ScilabPolynomial(double[][][] dArray) {
        this.realPart = dArray;
        this.imaginaryPart = null;
    }

    public ScilabPolynomial(double[][][] dArray, String string) {
        this(dArray);
        this.setPolyVarName(string);
    }

    public ScilabPolynomial(double[][][] dArray, double[][][] dArray2) {
        this.realPart = dArray;
        this.imaginaryPart = dArray2;
    }

    public ScilabPolynomial(double[][][] dArray, double[][][] dArray2, String string) {
        this(dArray, dArray2);
        this.setPolyVarName(string);
    }

    public ScilabPolynomial(String string, String string2, double[][][] dArray, double[][][] dArray2, boolean bl) {
        this.varName = string;
        this.polyVarName = string2;
        this.swaped = bl;
        this.realPart = dArray;
        this.imaginaryPart = dArray2;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_poly;
    }

    @Override
    public boolean isEmpty() {
        return this.realPart == null && this.imaginaryPart == null;
    }

    public boolean isReal() {
        return this.imaginaryPart == null;
    }

    public double[][][] getRealPart() {
        return this.realPart;
    }

    public void setRealPart(double[][][] dArray) {
        this.realPart = dArray;
    }

    public double[][][] getImaginaryPart() {
        return this.imaginaryPart;
    }

    public void setImaginaryPart(double[][][] dArray) {
        this.imaginaryPart = dArray;
    }

    public String getPolyVarName() {
        return this.polyVarName;
    }

    public void setPolyVarName(String string) {
        this.polyVarName = string;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return this.swaped;
    }

    public double[][] getSerializedComplexPolynomial() {
        return new double[0][0];
    }

    @Override
    public int getHeight() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.realPart.length;
    }

    @Override
    public int getWidth() {
        if (this.isEmpty() || this.realPart.length == 0) {
            return 0;
        }
        return this.realPart[0].length;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.deepHashCode((Object[])this.imaginaryPart);
        n = 31 * n + (this.polyVarName == null ? 0 : this.polyVarName.hashCode());
        n = 31 * n + Arrays.deepHashCode((Object[])this.realPart);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScilabPolynomial) {
            ScilabPolynomial scilabPolynomial = (ScilabPolynomial)object;
            if (scilabPolynomial.getPolyVarName().equals(this.getPolyVarName())) {
                if (this.isReal() && scilabPolynomial.isReal()) {
                    return Arrays.deepEquals((Object[])this.getRealPart(), (Object[])scilabPolynomial.getRealPart());
                }
                return Arrays.deepEquals((Object[])this.getRealPart(), (Object[])scilabPolynomial.getRealPart()) && Arrays.deepEquals((Object[])this.getImaginaryPart(), (Object[])scilabPolynomial.getImaginaryPart());
            }
            return false;
        }
        return false;
    }

    @Override
    public Object getSerializedObject() {
        if (this.isReal()) {
            return new Object[]{this.polyVarName, this.realPart};
        }
        return new Object[]{this.polyVarName, this.realPart, this.imaginaryPart};
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                this.realPart = (double[][][])objectInput.readObject();
                this.imaginaryPart = (double[][][])objectInput.readObject();
                this.varName = (String)objectInput.readObject();
                this.polyVarName = objectInput.readUTF();
                this.swaped = objectInput.readBoolean();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabPolynomial with a version " + n + " does not exist");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeObject(this.realPart);
        objectOutput.writeObject(this.imaginaryPart);
        objectOutput.writeObject(this.varName);
        objectOutput.writeUTF(this.polyVarName);
        objectOutput.writeBoolean(this.swaped);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isEmpty()) {
            stringBuilder.append("[]");
            return stringBuilder.toString();
        }
        stringBuilder.append("[");
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                stringBuilder.append("poly([");
                for (int k = 0; k < this.realPart[i][j].length; ++k) {
                    if (this.isReal()) {
                        stringBuilder.append(Double.toString(this.realPart[i][j][k]));
                    } else {
                        stringBuilder.append(Double.toString(this.realPart[i][j][k]));
                        if (this.imaginaryPart[i][j][k] != 0.0) {
                            stringBuilder.append("+");
                            stringBuilder.append(Double.toString(this.imaginaryPart[i][j][k]));
                            stringBuilder.append("*%i");
                        }
                    }
                    if (k >= this.realPart[i][j].length - 1) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append("], \"");
                stringBuilder.append(this.getPolyVarName());
                stringBuilder.append("\", \"coeff\")");
                if (j >= this.getWidth() - 1) continue;
                stringBuilder.append(", ");
            }
            if (i >= this.getHeight() - 1) continue;
            stringBuilder.append(" ; ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

