/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.datatable;

import java.awt.Cursor;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.UI_data;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;
import org.scilab.modules.ui_data.variableeditor.celleditor.ScilabGenericCellEditor;
import org.scilab.modules.ui_data.variableeditor.undo.CellsUndoManager;
import org.scilab.modules.ui_data.variableeditor.undo.CellsUndoableEdit;

public class SwingEditvarTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -4255704246347716837L;
    private static final String GUILL = "\"";
    private static final String EQUAL = "=";
    private static final String COMMA = ",";
    private static final String SEMI = ";";
    private int scilabMatrixRowCount;
    private int scilabMatrixColCount;
    private int currentRow = -1;
    private int currentCol = -1;
    private String type;
    private String varName;
    private ScilabGenericCellEditor cellEditor;
    private SwingScilabVariableEditor editor;
    private CellsUndoManager undoManager;
    private Vector copyVector;

    public SwingEditvarTableModel(SwingScilabVariableEditor swingScilabVariableEditor, String string, String string2, Object[][] objectArray, ScilabGenericCellEditor scilabGenericCellEditor, int n, int n2) {
        this.editor = swingScilabVariableEditor;
        this.varName = string;
        this.scilabMatrixRowCount = objectArray.length;
        this.scilabMatrixColCount = 0;
        if (this.scilabMatrixRowCount != 0) {
            this.scilabMatrixColCount = objectArray[0].length;
        }
        this.type = string2;
        this.setDataVector(objectArray, n, n2);
        this.cellEditor = scilabGenericCellEditor;
        this.undoManager = new CellsUndoManager(swingScilabVariableEditor);
    }

    public void changeData(String string, Object[][] objectArray, ScilabGenericCellEditor scilabGenericCellEditor, int n, int n2) {
        this.type = string;
        this.cellEditor = scilabGenericCellEditor;
        this.scilabMatrixRowCount = objectArray.length;
        this.scilabMatrixColCount = 0;
        if (this.scilabMatrixRowCount != 0) {
            this.scilabMatrixColCount = objectArray[0].length;
        }
        this.setDataVector(objectArray, n, n2);
    }

    public void changeData(Vector vector, int n, int n2) {
        this.dataVector = vector;
        this.scilabMatrixRowCount = n;
        this.scilabMatrixColCount = n2;
        this.updateFullMatrix(null, 0, 0);
    }

    public void setDataVector(Object[][] objectArray, int n, int n2) {
        int n3 = 0;
        if (objectArray.length != 0) {
            n3 = objectArray[0].length;
        }
        int n4 = Math.max(n2, n3);
        Vector<Integer> vector = new Vector<Integer>(n4);
        for (int i = 0; i < n4; ++i) {
            vector.addElement(i + 1);
        }
        super.setDataVector(this.convertData(objectArray, n, n2), vector);
    }

    protected Vector convertData(Object[][] objectArray, int n, int n2) {
        int n3;
        Vector<Object> vector;
        int n4;
        int n5 = Math.max(objectArray.length, n);
        int n6 = 0;
        if (objectArray.length != 0) {
            n6 = Math.max(objectArray[0].length, n2);
        }
        Vector vector2 = new Vector(n5);
        for (n4 = 0; n4 < objectArray.length; ++n4) {
            vector = new Vector<Object>(n6);
            for (n3 = 0; n3 < objectArray[n4].length; ++n3) {
                vector.addElement(objectArray[n4][n3]);
            }
            for (n3 = 0; n3 < n2 - objectArray[n4].length; ++n3) {
                vector.addElement(null);
            }
            vector2.addElement(vector);
        }
        for (n4 = 0; n4 < n - objectArray.length; ++n4) {
            vector = new Vector(n6);
            for (n3 = 0; n3 < n6; ++n3) {
                vector.addElement(null);
            }
            vector2.addElement(vector);
        }
        return vector2;
    }

    public boolean enlarge(int n, int n2) {
        boolean bl = false;
        if (n2 > this.getColumnCount()) {
            this.addColumns(n2 - this.getColumnCount());
            bl = true;
        }
        if (n > this.getRowCount()) {
            int n3 = n - this.getRowCount();
            for (int i = 0; i < n3; ++i) {
                Vector<Object> vector = new Vector<Object>(this.getColumnCount());
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    vector.addElement(null);
                }
                this.dataVector.addElement(vector);
            }
            bl = true;
        }
        return bl;
    }

    public Vector cloneDatas() {
        Vector<Object> vector = new Vector<Object>(this.dataVector.size());
        for (int i = 0; i < this.dataVector.size(); ++i) {
            Vector vector2 = (Vector)this.dataVector.get(i);
            if (vector2 != null) {
                vector.addElement(vector2.clone());
                continue;
            }
            vector.addElement(null);
        }
        return vector;
    }

    public void addColumns(int n) {
        this.columnIdentifiers.setSize(this.getColumnCount() + n);
        for (int i = 0; i < this.getRowCount(); ++i) {
            ((Vector)this.dataVector.elementAt(i)).setSize(this.getColumnCount());
        }
    }

    public void addRows(int n) {
        this.enlarge(this.getRowCount() + n, this.getColumnCount());
    }

    public ScilabGenericCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public CellsUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(CellsUndoManager cellsUndoManager) {
        this.undoManager = cellsUndoManager;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public int getScilabMatrixRowCount() {
        return this.scilabMatrixRowCount;
    }

    public int getScilabMatrixColCount() {
        return this.scilabMatrixColCount;
    }

    public String getScilabValueAt(int n, int n2, boolean bl) {
        Object object = this.cellEditor.getDataAsScilabString(this.getValueAt(n, n2));
        if (!bl && this.getValueAt(n, n2) == null) {
            return null;
        }
        if (((String)object).length() == 0) {
            object = this.getDefaultStringValue();
        }
        if (this.type.equals("String")) {
            object = GUILL + SwingEditvarTableModel.getDataAsScilabString((String)object) + GUILL;
        }
        return object;
    }

    public String getScilabValueAt(int n, int n2) {
        return this.getScilabValueAt(n, n2, true);
    }

    public void emptyValueAt(int n, int n2) {
        super.setValueAt(null, n, n2);
    }

    public void setValueAtAndUpdate(boolean bl, boolean bl2, Object object, int n, int n2) {
        Object object2 = bl2 ? this.getValueAt(n, n2) : null;
        int n3 = this.scilabMatrixRowCount;
        int n4 = this.scilabMatrixColCount;
        this.copyVector = null;
        boolean bl3 = this.setValue(object, n, n2);
        if (bl3) {
            this.fireTableChanged(new TableModelEvent(this));
        } else {
            this.fireTableCellUpdated(n, n2);
        }
        if (bl) {
            if (bl3) {
                this.updateFullMatrix(this.copyVector, n3, n4);
            } else {
                this.updateMatrix(object2, n, n2);
            }
        }
    }

    public boolean setValue(Object object, int n, int n2) {
        int n3;
        Vector vector;
        int n4;
        if (object == null || object instanceof String && ((String)object).length() == 0) {
            return false;
        }
        Object object2 = this.getDefaultValue();
        boolean bl = false;
        if (n >= this.scilabMatrixRowCount) {
            for (n4 = this.scilabMatrixRowCount; n4 <= n; ++n4) {
                vector = (Vector)this.dataVector.elementAt(n4);
                for (n3 = 0; n3 <= Math.max(n2, this.scilabMatrixColCount - 1); ++n3) {
                    vector.setElementAt(object2, n3);
                    if (this.copyVector == null) {
                        this.copyVector = (Vector)this.dataVector.clone();
                    }
                    if (bl) continue;
                    bl = true;
                }
            }
        }
        if (n2 >= this.scilabMatrixColCount) {
            for (n4 = 0; n4 <= Math.max(n, this.scilabMatrixRowCount - 1); ++n4) {
                vector = (Vector)this.dataVector.elementAt(n4);
                for (n3 = this.scilabMatrixColCount; n3 <= n2; ++n3) {
                    vector.setElementAt(object2, n3);
                    if (this.copyVector == null) {
                        this.copyVector = (Vector)this.dataVector.clone();
                    }
                    if (bl) continue;
                    bl = true;
                }
            }
        }
        object = this.escapeQuotes(object);
        ((Vector)this.dataVector.elementAt(n)).setElementAt(object, n2);
        if (n2 >= this.scilabMatrixColCount || n >= this.scilabMatrixRowCount) {
            if (n2 >= this.scilabMatrixColCount) {
                this.scilabMatrixColCount = n2 + 1;
            }
            if (n >= this.scilabMatrixRowCount) {
                this.scilabMatrixRowCount = n + 1;
            }
        }
        return bl;
    }

    private Object escapeQuotes(Object object) {
        char c;
        char c2;
        String string;
        if ("String".equals(this.type) && (string = object.toString()).length() > 1 && (c2 = string.charAt(0)) == (c = string.charAt(string.length() - 1)) && (c2 == '\"' || c2 == '\'')) {
            object = string.substring(1, string.length() - 1);
        }
        return object;
    }

    public boolean setValues(Vector vector, int n, int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < vector.size(); n3 += 1) {
            n4 = Math.max(n4, ((Vector)vector.get(n3)).size());
        }
        n3 = this.enlarge(n + vector.size(), n2 + n4) ? 1 : 0;
        for (int i = 0; i < vector.size(); ++i) {
            for (int j = 0; j < ((Vector)vector.get(i)).size(); ++j) {
                n3 = this.setValue(((Vector)vector.get(i)).get(j), n + i, n2 + j) || n3 != 0 ? 1 : 0;
            }
        }
        return n3 != 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.setValueAtAndUpdate(true, true, object, n, n2);
        this.currentRow = n;
        this.currentCol = n2;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public int getCurrentCol() {
        return this.currentCol;
    }

    public void removeRow(int n, int n2, int n3) {
        if (n == this.scilabMatrixRowCount - 1 && n2 == 0 && n3 >= this.scilabMatrixColCount - 1) {
            --this.scilabMatrixRowCount;
            Vector vector = (Vector)this.dataVector.get(n);
            for (int i = 0; i < this.scilabMatrixColCount; ++i) {
                vector.setElementAt(null, i);
            }
        }
    }

    public void removeCol(int n, int n2, int n3) {
        if (n == this.scilabMatrixColCount - 1 && n2 == 0 && n3 >= this.scilabMatrixRowCount - 1) {
            --this.scilabMatrixColCount;
            for (int i = 0; i < this.scilabMatrixRowCount; ++i) {
                ((Vector)this.dataVector.get(i)).setElementAt(null, n);
            }
        }
    }

    public void removeColumns(int[] nArray) {
        Vector vector = null;
        int n = this.scilabMatrixRowCount;
        int n2 = this.scilabMatrixColCount;
        int n3 = 0;
        int[] nArray2 = nArray;
        int n4 = nArray2.length;
        for (int i = 0; i < n4; ++i) {
            Integer n5 = nArray2[i];
            if (n5 - n3 >= this.scilabMatrixColCount) continue;
            if (vector == null) {
                vector = this.cloneDatas();
            }
            if (n5 - n3 == this.scilabMatrixColCount - 1) {
                for (var10_10 = 0; var10_10 < this.scilabMatrixRowCount; ++var10_10) {
                    ((Vector)this.dataVector.get(var10_10)).setElementAt(null, n5 - n3);
                }
            } else {
                for (var10_10 = 0; var10_10 < this.scilabMatrixRowCount; ++var10_10) {
                    ((Vector)this.dataVector.get(var10_10)).removeElementAt(n5 - n3);
                }
            }
            --this.scilabMatrixColCount;
            ++n3;
        }
        if (vector != null) {
            this.fireTableStructureChanged();
            this.updateFullMatrix(vector, n, n2);
        }
    }

    public void removeRows(int[] nArray) {
        Vector vector = null;
        int n = this.scilabMatrixRowCount;
        int n2 = this.scilabMatrixColCount;
        int n3 = 0;
        int[] nArray2 = nArray;
        int n4 = nArray2.length;
        for (int i = 0; i < n4; ++i) {
            Integer n5 = nArray2[i];
            if (n5 - n3 >= this.scilabMatrixRowCount) continue;
            if (vector == null) {
                vector = this.cloneDatas();
            }
            if (n5 - n3 == this.scilabMatrixRowCount - 1) {
                Vector vector2 = (Vector)this.dataVector.get(n5 - n3);
                for (int j = 0; j < this.scilabMatrixColCount; ++j) {
                    vector2.setElementAt(null, j);
                }
            } else {
                this.dataVector.removeElementAt(n5 - n3);
            }
            --this.scilabMatrixRowCount;
            this.fireTableRowsDeleted(n5 - n3, n5 - n3);
            ++n3;
        }
        if (vector != null) {
            this.updateFullMatrix(vector, n, n2);
        }
    }

    public void insertColumn(int n) {
        if (n < this.scilabMatrixColCount - 1) {
            Vector vector = this.cloneDatas();
            int n2 = this.scilabMatrixRowCount;
            int n3 = this.scilabMatrixColCount;
            Object object = this.getDefaultValue();
            for (int i = 0; i < this.scilabMatrixRowCount; ++i) {
                ((Vector)this.dataVector.get(i)).insertElementAt(object, n);
            }
            ++this.scilabMatrixColCount;
            this.updateFullMatrix(vector, n2, n3);
        }
    }

    public void insertRow(int n) {
        if (n < this.scilabMatrixRowCount - 1) {
            int n2;
            Vector vector = this.cloneDatas();
            int n3 = this.scilabMatrixRowCount;
            int n4 = this.scilabMatrixColCount;
            Object object = this.getDefaultValue();
            Vector<Object> vector2 = new Vector<Object>(this.getColumnCount());
            for (n2 = 0; n2 < this.scilabMatrixColCount; ++n2) {
                vector2.addElement(object);
            }
            for (n2 = this.scilabMatrixColCount; n2 < this.getColumnCount(); ++n2) {
                vector2.addElement(null);
            }
            this.dataVector.insertElementAt(vector2, n);
            ++this.scilabMatrixRowCount;
            this.updateFullMatrix(vector, n3, n4);
        }
    }

    public void updateFullMatrix(Object object, int n, int n2) {
        String[] stringArray = this.getSubMatrix(0, this.scilabMatrixRowCount - 1, 0, this.scilabMatrixColCount - 1);
        UI_data.putScilabVariable("L?8625083632641564278", stringArray, this.scilabMatrixRowCount, this.scilabMatrixColCount);
        String string = this.type.equals("Sparse") || this.type.equals("Complex Sparse") || this.type.equals("Boolean Sparse") ? SwingEditvarTableModel.buildScilabRequest(this.varName + "=sparse(evstr(L?8625083632641564278))", "editvar(\"" + this.varName + "\"),clear(\"L?8625083632641564278\")") : SwingEditvarTableModel.buildScilabRequest(this.varName + "=evstr(L?8625083632641564278)", "editvar(\"" + this.varName + "\"),clear(\"L?8625083632641564278\")");
        this.execCommand(string, object, n, n2);
    }

    private String[] getSubMatrix(int n, int n2, int n3, int n4) {
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        String[] stringArray = new String[n5 * n6];
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                stringArray[j * n5 + i] = this.getScilabValueAt(i + n, j + n3);
            }
        }
        return stringArray;
    }

    public String getScilabSubMatrix(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        if (nArray.length == 0 || nArray2.length == 0) {
            return null;
        }
        int n = this.getScilabMatrixRowCount() - 1;
        int n2 = this.getScilabMatrixColCount() - 1;
        String string = SwingEditvarTableModel.getLimits(nArray, n, nArray3);
        if (string == null) {
            return null;
        }
        String string2 = SwingEditvarTableModel.getLimits(nArray2, n2, nArray4);
        if (string2 == null) {
            return null;
        }
        if (nArray3[0] == n + 1 && nArray4[0] == n2 + 1) {
            return this.getVarName();
        }
        return this.getVarName() + "(" + string + COMMA + string2 + ")";
    }

    public String getScilabSubMatrix(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        return this.getScilabSubMatrix(nArray, nArray2, nArray3, nArray4);
    }

    private static String getLimits(int[] nArray, int n, int[] nArray2) {
        int n2;
        if (nArray.length == 0 || nArray[0] > n) {
            return null;
        }
        Vector<Integer> vector = new Vector<Integer>(2 * nArray.length);
        vector.addElement(nArray[0]);
        for (n2 = 1; n2 < nArray.length && nArray[n2] <= n; ++n2) {
            if (nArray[n2] == nArray[n2 - 1] + 1) continue;
            vector.addElement(nArray[n2 - 1]);
            vector.addElement(nArray[n2]);
        }
        if (n2 == nArray.length) {
            vector.addElement(nArray[nArray.length - 1]);
        } else {
            vector.addElement(n);
        }
        if (vector.size() == 2) {
            nArray2[0] = (Integer)vector.get(1) - (Integer)vector.get(0) + 1;
            if ((Integer)vector.get(0) == 0 && (Integer)vector.get(1) == n) {
                return ":";
            }
            if (vector.get(0) == vector.get(1)) {
                return Integer.toString((Integer)vector.get(0) + 1);
            }
            return (Integer)vector.get(0) + 1 + ":" + ((Integer)vector.get(1) + 1);
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        nArray2[0] = 0;
        for (n2 = 0; n2 < vector.size(); n2 += 2) {
            nArray2[0] = nArray2[0] + ((Integer)vector.get(n2 + 1) - (Integer)vector.get(n2) + 1);
            stringBuilder.append((Integer)vector.get(n2) + 1);
            if (vector.get(n2) != vector.get(n2 + 1)) {
                stringBuilder.append(":");
                stringBuilder.append((Integer)vector.get(n2 + 1) + 1);
            }
            if (n2 == vector.size() - 2) {
                stringBuilder.append("]");
                continue;
            }
            stringBuilder.append(COMMA);
        }
        return stringBuilder.toString();
    }

    public void refreshMatrix() {
        this.execCommand("editvar(\"" + this.varName + "\");");
    }

    public String getVarName() {
        return this.varName;
    }

    private Object getDefaultValue() {
        Double[] doubleArray = null;
        if (this.type.equals("Double")) {
            doubleArray = new Double(0.0);
        } else if (this.type.equals("String")) {
            doubleArray = "";
        } else if (this.type.equals("Integer")) {
            doubleArray = new Integer(0);
        } else if (this.type.equals("Complex")) {
            doubleArray = new Double[]{0.0, 0.0};
        } else if (this.type.equals("Boolean")) {
            doubleArray = Boolean.FALSE;
        } else if (this.type.equals("Sparse") || this.type.equals("Complex Sparse") || this.type.equals("Boolean Sparse")) {
            doubleArray = "";
        }
        return doubleArray;
    }

    private String getDefaultStringValue() {
        if (this.type.equals("Double") || this.type.equals("Complex") || this.type.equals("Integer") || this.type.equals("Sparse") || this.type.equals("Complex Sparse")) {
            return "0";
        }
        if (this.type.equals("String")) {
            return "";
        }
        if (this.type.equals("Boolean") || this.type.equals("Boolean Sparse")) {
            return "%f";
        }
        return null;
    }

    public void updateMatrix(Object object, int n, int n2) {
        String string = this.getScilabValueAt(n, n2);
        Object object2 = "";
        if (this.scilabMatrixRowCount != 1 || this.scilabMatrixColCount != 1) {
            object2 = "(" + (n + 1) + COMMA + (n2 + 1) + ")";
        }
        String string2 = this.varName + (String)object2 + EQUAL + SwingEditvarTableModel.getDataAsScilabString(string);
        String string3 = "editvar(\"" + this.varName + "\"," + this.varName + "(" + (n + 1) + COMMA + (n2 + 1) + ")," + (n + 1) + COMMA + (n2 + 1) + ");";
        String string4 = SwingEditvarTableModel.buildScilabRequest(string2, string3);
        this.execCommand(string4, object, n, n2);
    }

    public void execCommand(String string) {
        this.execCommand(string, null, 0, 0);
    }

    private void execCommand(String string, final Object object, final int n, final int n2) {
        try {
            CommonCallBack commonCallBack = new CommonCallBack(""){

                public void callBack() {
                    Object object2;
                    SwingEditvarTableModel.this.editor.setCursor(Cursor.getPredefinedCursor(0));
                    if (object != null && !object.equals(object2 = object instanceof Vector ? (Vector)SwingEditvarTableModel.this.dataVector.clone() : SwingEditvarTableModel.this.getValueAt(n, n2))) {
                        SwingEditvarTableModel.this.undoManager.addEdit(new CellsUndoableEdit(SwingEditvarTableModel.this, object2, object, n, n2));
                    }
                }
            };
            this.editor.setCursor(Cursor.getPredefinedCursor(3));
            ScilabInterpreterManagement.asynchronousScilabExec((ActionListener)commonCallBack, (String)string);
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            System.err.println((Object)interpreterException);
        }
    }

    public static String buildScilabRequest(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("L$8625083632641564277=warning(\"query\");warning(\"off\");");
        stringBuilder.append("if execstr(\"");
        stringBuilder.append(string);
        stringBuilder.append("\",\"errcatch\") <> 0 then messagebox(\"Could not edit variable: \" + lasterror() + \"\"");
        stringBuilder.append(",\"Variable editor\",\"error\",\"modal\");");
        stringBuilder.append("end;");
        stringBuilder.append("warning(L$8625083632641564277);clear(\"L$8625083632641564277\");");
        stringBuilder.append(string2);
        stringBuilder.append(SEMI);
        stringBuilder.append("updatebrowsevar()");
        return stringBuilder.toString();
    }

    private String getMatrix() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.scilabMatrixRowCount; ++i) {
            for (int j = 0; j < this.scilabMatrixColCount; ++j) {
                stringBuilder.append(this.getScilabValueAt(i, j));
                if (j < this.scilabMatrixColCount - 1) {
                    stringBuilder.append(COMMA);
                    continue;
                }
                if (i >= this.scilabMatrixRowCount - 1) continue;
                stringBuilder.append(SEMI);
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void refresh() {
        try {
            ScilabInterpreterManagement.asynchronousScilabExec(null, (String)("editvar(\"" + this.varName + "\")"));
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            System.err.println((Object)interpreterException);
        }
    }

    public static String getDataAsScilabString(String string) {
        return string.replace(GUILL, "\"\"").replace("'", "''");
    }
}

