/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser.actions;

import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.FileBrowser;
import org.scilab.modules.ui_data.filebrowser.FileUtils;
import org.scilab.modules.ui_data.filebrowser.SwingScilabTreeTable;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class ChangeCWDAction
extends CommonCallBack {
    private SwingScilabTreeTable table;

    public ChangeCWDAction(SwingScilabTreeTable swingScilabTreeTable) {
        super(null);
        this.table = swingScilabTreeTable;
    }

    public void callBack() {
        this.changeDir(this.table.getComboBox().getBaseDir());
    }

    public JButton createButton() {
        JButton jButton = new JButton();
        jButton.setToolTipText(UiDataMessages.SELECTDIR);
        jButton.addActionListener((ActionListener)new CommonCallBack(null){

            public void callBack() {
                SwingScilabFileChooser swingScilabFileChooser = new SwingScilabFileChooser();
                swingScilabFileChooser.setCurrentDirectory(new File(ChangeCWDAction.this.table.getComboBox().getBaseDir()));
                swingScilabFileChooser.setTitle(UiDataMessages.SELECTADIR);
                swingScilabFileChooser.setMultipleSelection(false);
                swingScilabFileChooser.setDirectorySelectionOnly();
                swingScilabFileChooser.displayAndWait();
                String[] stringArray = swingScilabFileChooser.getSelection();
                if (stringArray != null && stringArray.length != 0) {
                    ChangeCWDAction.this.changeDir(stringArray[0]);
                }
            }
        });
        jButton.setIcon(FileUtils.getClosedDirIcon());
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        return jButton;
    }

    public JButton createParentDirButton() {
        JButton jButton = new JButton();
        jButton.setToolTipText(UiDataMessages.PARENTDIR);
        jButton.addActionListener((ActionListener)new CommonCallBack(null){

            public void callBack() {
                File file;
                File file2 = new File(ChangeCWDAction.this.table.getComboBox().getBaseDir());
                if (file2.exists() && (file = file2.getParentFile()) != null && file.exists() && file.canRead()) {
                    ChangeCWDAction.this.changeDir(file.getAbsolutePath());
                }
            }
        });
        jButton.setIcon(FileUtils.getUpDirIcon());
        return jButton;
    }

    private void changeDir(String string) {
        File file = new File(string);
        if (file.exists() && file.isDirectory() && file.canRead()) {
            InterpreterManagement.requestScilabExec((String)("chdir('" + string + "');"));
            FileBrowser.setBaseDir(string);
        }
    }
}

