/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variablebrowser;

import java.awt.Component;
import javax.swing.SwingUtilities;
import org.flexdock.view.View;
import org.scilab.modules.commons.gui.ScilabGUIUtilities;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.ui_data.BrowseVar;
import org.scilab.modules.ui_data.tabfactory.VariableBrowserTab;
import org.scilab.modules.ui_data.tabfactory.VariableBrowserTabFactory;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variablebrowser.SwingScilabVariableBrowser;
import org.scilab.modules.ui_data.variablebrowser.VariableBrowser;

public final class ScilabVariableBrowser
implements VariableBrowser {
    private static ScilabVariableBrowser instance;
    private static SwingScilabVariableBrowser browserTab;

    private ScilabVariableBrowser() {
        TextBox textBox = ScilabTextBox.createTextBox();
        browserTab = new SwingScilabVariableBrowser(BrowseVar.COLUMNNAMES, BrowseVar.COLUMNSALIGNMENT);
        browserTab.addInfoBar(textBox);
        browserTab.setTitle(UiDataMessages.VARIABLE_BROWSER);
    }

    public static SwingScilabVariableBrowser createVarBrowserTab() {
        if (instance == null) {
            instance = new ScilabVariableBrowser();
        }
        return browserTab;
    }

    public static boolean isBrowseVarOpened() {
        return instance != null;
    }

    public static VariableBrowser openVariableBrowser() {
        if (instance == null) {
            boolean bl = WindowsConfigurationManager.restoreUUID((String)"3b649047-6a71-4998-bd8e-00d367a4793c");
            if (!bl) {
                VariableBrowserTab.getVariableBrowserInstance();
                SwingScilabWindow swingScilabWindow = SwingScilabWindow.createWindow((boolean)true);
                swingScilabWindow.addTab((SwingScilabPanel)browserTab);
                swingScilabWindow.setLocation(0, 0);
                swingScilabWindow.setSize(500, 500);
                swingScilabWindow.setVisible(true);
                swingScilabWindow.toFront();
            }
        } else {
            int n;
            SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)browserTab));
            if (swingScilabWindow != null && ((n = swingScilabWindow.getExtendedState()) & 1) == 1) {
                swingScilabWindow.setExtendedState(n - 1);
            }
        }
        ScilabGUIUtilities.toFront((View)browserTab, (String)UiDataMessages.VARIABLE_BROWSER);
        return instance;
    }

    public static void setVariableBrowserData(final Object[][] objectArray) {
        if (instance != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (instance != null) {
                        instance.setData(objectArray);
                    }
                }
            });
        }
    }

    public static void updateVariableBrowser() {
        if (instance != null) {
            SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)browserTab));
            swingScilabWindow.repaint();
        }
    }

    public static void closeVariableBrowser() {
        if (instance != null) {
            instance = null;
        }
    }

    public static VariableBrowser getVariableBrowser() {
        return instance;
    }

    @Override
    public void close() {
        ClosingOperationsManager.startClosingOperationWithoutSave((SwingScilabDockablePanel)browserTab);
    }

    @Override
    public void setData(Object[][] objectArray) {
        browserTab.setData(objectArray);
    }

    @Override
    public void updateRowFiltering() {
        browserTab.updateRowFiltering();
    }

    public void setVisible(boolean bl) {
        browserTab.setVisible(bl);
    }

    static {
        ScilabTabFactory.getInstance().addTabFactory((AbstractScilabTabFactory)VariableBrowserTabFactory.getInstance());
    }
}

