/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variablebrowser.actions;

import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.ui_data.utils.UiDataMessages;
import org.scilab.modules.ui_data.variablebrowser.SwingScilabVariableBrowser;

public final class ModifyAction
extends CommonCallBack {
    private static final long serialVersionUID = 1L;
    private static ImageIcon icon = new ImageIcon(FindIconHelper.findIcon((String)"rrze_table"));
    private static final char MNEMONIC = 'M';
    private static final String KEY = "MODIFY";
    private final SwingScilabVariableBrowser variableBrowser;

    public ModifyAction(SwingScilabVariableBrowser swingScilabVariableBrowser) {
        super("");
        this.variableBrowser = swingScilabVariableBrowser;
    }

    public static JButton createButton(SwingScilabVariableBrowser swingScilabVariableBrowser, String string) {
        JButton jButton = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        jButton.addActionListener((ActionListener)((Object)new ModifyAction(swingScilabVariableBrowser)));
        jButton.setToolTipText(string);
        jButton.setIcon(icon);
        return jButton;
    }

    public MenuItem createMenuItem() {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setText(UiDataMessages.MODIFY + " '" + this.getSelectedVariable() + "'");
        menuItem.setMnemonic('M');
        menuItem.setCallback((CommonCallBack)this);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setIcon((Icon)icon);
        return menuItem;
    }

    public void callBack() {
        this.variableBrowser.startEditVar(this.getSelectedVariableVisibility(), this.getSelectedVariable());
    }

    private String getSelectedVariable() {
        int n = this.variableBrowser.getTable().getSelectedRow();
        if (n != -1) {
            return this.variableBrowser.getTable().getValueAt(n, 1).toString();
        }
        return "";
    }

    private String getSelectedVariableVisibility() {
        int n = this.variableBrowser.getTable().getSelectedRow();
        if (n != -1) {
            return this.variableBrowser.getTable().getValueAt(n, 4).toString();
        }
        return "";
    }
}

