/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.scilab.modules.action_binding.InterpreterManagement;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.window.SwingScilabDockingWindow;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.ui_data.variableeditor.ScilabTabbedPane;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;
import org.scilab.modules.ui_data.variableeditor.VariableEditor;

public final class ScilabVariableEditor
extends SwingScilabDockingWindow
implements VariableEditor {
    private static Map<String, Component> map = new HashMap<String, Component>();
    private static ScilabVariableEditor instance;
    private static SwingScilabVariableEditor editorTab;
    private static ScilabTabbedPane tabPane;

    private ScilabVariableEditor(String string, Object[][] objectArray, String string2) {
        editorTab = new SwingScilabVariableEditor(string2, string, objectArray);
        tabPane = editorTab.getTabPane();
        TextBox textBox = ScilabTextBox.createTextBox();
        editorTab.addInfoBar(textBox);
        this.addTab((SwingScilabPanel)editorTab);
        map.put(string2, tabPane.getSelectedComponent());
    }

    @Override
    public void close() {
        SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingScilabWindow.allScilabWindows.get(editorTab.getParentWindowId());
        ChangeListener[] changeListenerArray = tabPane.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            tabPane.removeChangeListener(changeListenerArray[i]);
        }
        instance = null;
        map.clear();
        super.close();
    }

    public static void closeEditVar() {
        if (instance != null) {
            instance.close();
        }
    }

    public static void close(String string) {
        map.remove(string);
    }

    @Override
    public void updateData(String string, String string2, Object[][] objectArray) {
        if (map.containsKey(string)) {
            editorTab.updateData(map.get(string), string, string2, objectArray);
        } else {
            editorTab.setData(string, string2, objectArray);
            map.put(string, tabPane.getSelectedComponent());
        }
    }

    @Override
    public void updateData(String string, String string2, Object[][] objectArray, double[] dArray, double[] dArray2) {
        if (map.containsKey(string)) {
            editorTab.updateData(map.get(string), string, string2, objectArray, dArray, dArray2);
        }
    }

    public static ScilabVariableEditor getVariableEditor() {
        return instance;
    }

    public static ScilabVariableEditor getVariableEditor(final String string, final Object[][] objectArray, final String string2) {
        if (instance == null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        instance = new ScilabVariableEditor(string, objectArray, string2);
                        instance.setVisible(true);
                    }
                });
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n;
                    SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)editorTab));
                    swingScilabWindow.setVisible(true);
                    swingScilabWindow.toFront();
                    JTable jTable = editorTab.getCurrentTable();
                    int n2 = -1;
                    int n3 = -1;
                    if (jTable != null) {
                        n2 = jTable.getSelectedRow();
                        n3 = jTable.getSelectedColumn();
                    }
                    boolean bl = map.containsKey(string2);
                    instance.updateData(string2, string, objectArray);
                    if (bl && n2 != -1 && n3 != -1) {
                        jTable.setRowSelectionInterval(n2, n2);
                        jTable.setColumnSelectionInterval(n3, n3);
                    }
                    if (((n = swingScilabWindow.getExtendedState()) & 1) == 1) {
                        swingScilabWindow.setExtendedState(n - 1);
                    }
                }
            });
        }
        editorTab.setName(Messages.gettext((String)"Variable Editor") + " - " + string2 + "  (" + string + ")");
        return instance;
    }

    public static void refreshVariableEditor(String string, Object[][] objectArray, double[] dArray, double[] dArray2, String string2) {
        if (instance != null) {
            instance.updateData(string2, string, objectArray, dArray, dArray2);
        }
    }

    @Override
    public String getVariablename() {
        String string = tabPane.getScilabTitleAt(tabPane.getSelectedIndex());
        return string.substring("Var - ".length());
    }

    @Override
    public void setVariableName(String string) {
        tabPane.setTitleAt(tabPane.getSelectedIndex(), "Var - " + string);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        editorTab.setVisible(bl);
    }

    public void macosxAbout() {
        InterpreterManagement.requestScilabExec((String)"about()");
    }

    public boolean macosxQuit() {
        InterpreterManagement.requestScilabExec((String)"exit()");
        return false;
    }

    public void macosxPreferences() {
        InterpreterManagement.requestScilabExec((String)"preferences();");
    }
}

