/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.variableeditor.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.ui_data.datatable.SwingEditvarTableModel;
import org.scilab.modules.ui_data.variableeditor.SwingScilabVariableEditor;

public final class CutAction
extends CommonCallBack {
    private static final String KEY = "OSSCKEY X";
    private static final String CUT = "Cut";
    private final SwingScilabVariableEditor editor;

    public CutAction(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        super(string);
        this.editor = swingScilabVariableEditor;
    }

    public static void registerAction(SwingScilabVariableEditor swingScilabVariableEditor, JTable jTable) {
        jTable.getActionMap().put(CUT, (Action)((Object)new CutAction(swingScilabVariableEditor, CUT)));
        jTable.getInputMap().put(ScilabKeyStroke.getKeyStroke((String)KEY), CUT);
    }

    public void callBack() {
        JTable jTable = this.editor.getCurrentTable();
        int[] nArray = jTable.getSelectedColumns();
        int[] nArray2 = jTable.getSelectedRows();
        if (nArray.length > 0 && nArray2.length > 0) {
            int n;
            jTable.setColumnSelectionInterval(nArray[0], nArray[nArray.length - 1]);
            jTable.setRowSelectionInterval(nArray2[0], nArray2[nArray2.length - 1]);
            StringBuffer stringBuffer = new StringBuffer();
            SwingEditvarTableModel swingEditvarTableModel = (SwingEditvarTableModel)jTable.getModel();
            int n2 = swingEditvarTableModel.getScilabMatrixRowCount();
            int n3 = swingEditvarTableModel.getScilabMatrixColCount();
            if (nArray2[0] >= n2 || nArray[0] >= n3) {
                return;
            }
            Object object = nArray.length == 1 && nArray2.length == 1 || nArray2.length >= 2 && nArray.length >= 2 && nArray2[1] >= n2 && nArray[1] >= n3 ? swingEditvarTableModel.getValueAt(nArray2[0], nArray[0]) : swingEditvarTableModel.cloneDatas();
            for (n = nArray2[0]; n <= nArray2[nArray2.length - 1]; ++n) {
                for (int i = nArray[0]; i <= nArray[nArray.length - 1]; ++i) {
                    String string = swingEditvarTableModel.getScilabValueAt(n, i, false);
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    swingEditvarTableModel.emptyValueAt(n, i);
                    if (i >= nArray[nArray.length - 1]) continue;
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
            for (n = nArray2[nArray2.length - 1]; n >= nArray2[0]; --n) {
                swingEditvarTableModel.removeRow(n, nArray[0], nArray[nArray.length - 1]);
            }
            for (n = nArray[nArray.length - 1]; n >= nArray[0]; --n) {
                swingEditvarTableModel.removeCol(n, nArray2[0], nArray2[nArray2.length - 1]);
            }
            if (object instanceof Vector) {
                swingEditvarTableModel.updateFullMatrix(object, n2, n3);
            } else {
                swingEditvarTableModel.updateMatrix(object, nArray2[0], nArray[0]);
            }
            StringSelection stringSelection = new StringSelection(stringBuffer.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    public static JButton createButton(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        JButton jButton = new JButton();
        ScilabLAF.setDefaultProperties((AbstractButton)jButton);
        jButton.addActionListener((ActionListener)((Object)new CutAction(swingScilabVariableEditor, string)));
        jButton.setToolTipText(string);
        ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"edit-cut"));
        jButton.setIcon(imageIcon);
        return jButton;
    }

    public static MenuItem createMenuItem(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback((CommonCallBack)new CutAction(swingScilabVariableEditor, string));
        menuItem.setText(string);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(ScilabKeyStroke.getKeyStroke((String)KEY));
        return menuItem;
    }

    public static SwingScilabMenuItem createJMenuItem(SwingScilabVariableEditor swingScilabVariableEditor, String string) {
        return (SwingScilabMenuItem)CutAction.createMenuItem(swingScilabVariableEditor, string).getAsSimpleMenuItem();
    }
}

