/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.commons;

import java.awt.Font;
import java.lang.reflect.Method;
import org.scilab.modules.commons.ScilabCommons;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.commons.xml.XConfigurationEvent;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.localization.WindowsDefaultLanguage;
import org.w3c.dom.Document;

public class ScilabGeneralPrefs
implements XConfigurationListener {
    private static final String ENV_PATH = "//general/body/environment";
    private static final String FONT_PATH = "//fonts/body/fonts";
    private static final String LANG_PATH = "//general/body/languages";
    private static final ScilabGeneralPrefs instance = new ScilabGeneralPrefs();
    private static Font desktopFont;

    private ScilabGeneralPrefs() {
    }

    public static ScilabGeneralPrefs getInstance() {
        return instance;
    }

    public static void openPreferences(String string) {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass("org.scilab.modules.preferences.ScilabPreferences");
            Method method = clazz.getDeclaredMethod("openPreferences", String.class);
            method.invoke(null, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @Override
    public void configurationChanged(XConfigurationEvent xConfigurationEvent) {
        Object object;
        Document document;
        boolean bl = xConfigurationEvent.getModifiedPaths().contains("ALL");
        if (bl || xConfigurationEvent.getModifiedPaths().contains(ENV_PATH)) {
            document = XConfiguration.getXConfigurationDocument();
            object = XConfiguration.get(GeneralEnvironment.class, document, ENV_PATH)[0];
            ScilabCommons.setieee(((GeneralEnvironment)object).code);
            ScilabCommons.setformat(((GeneralEnvironment)object).format, ((GeneralEnvironment)object).width);
            ScilabCommons.setRecursionLimit(((GeneralEnvironment)object).recursionLimit);
            ScilabCommons.setPolynomialDisplay(((GeneralEnvironment)object).PolynomialDisplay);
        }
        if (xConfigurationEvent.getModifiedPaths().contains(LANG_PATH)) {
            document = XConfiguration.getXConfigurationDocument();
            object = XConfiguration.get(Language.class, document, LANG_PATH)[0];
            WindowsDefaultLanguage.setdefaultlanguage((String)((Language)object).lang);
        }
        if (bl || xConfigurationEvent.getModifiedPaths().contains(FONT_PATH)) {
            desktopFont = null;
        }
    }

    public static Font getDesktopFont() {
        if (desktopFont == null) {
            Document document = XConfiguration.getXConfigurationDocument();
            DesktopFont desktopFont = XConfiguration.get(DesktopFont.class, document, FONT_PATH)[0];
            ScilabGeneralPrefs.desktopFont = desktopFont.font;
        }
        return desktopFont;
    }

    @XConfiguration.XConfAttribute
    private static class GeneralEnvironment {
        public int code;
        public String format;
        public int width;
        public int recursionLimit;
        public int PolynomialDisplay;

        private GeneralEnvironment() {
        }

        @XConfiguration.XConfAttribute(attributes={"fpe", "printing-format", "width", "recursion-limit", "polynomial-display"})
        private void set(int n, String string, int n2, int n3, int n4) {
            this.code = n;
            this.format = string;
            this.width = Math.min(Math.max(0, n2), 25);
            this.recursionLimit = n3;
            this.PolynomialDisplay = n4;
        }
    }

    @XConfiguration.XConfAttribute
    private static class Language {
        public String lang;

        private Language() {
        }

        @XConfiguration.XConfAttribute(attributes={"lang"})
        private void set(String string) {
            this.lang = string;
        }
    }

    @XConfiguration.XConfAttribute
    private static class DesktopFont {
        public Font font;

        private DesktopFont() {
        }

        @XConfiguration.XConfAttribute(tag="fonts", attributes={"font-face", "font-name", "font-size", "system"})
        private void set(String string, String string2, int n, boolean bl) {
            if (bl) {
                this.font = new Font("monospaced", 0, 13);
            } else {
                this.font = new Font(string2, 0, n);
                int n2 = 0;
                if (string.contains("bold")) {
                    n2 |= 1;
                } else if (string.contains("italic")) {
                    n2 |= 2;
                }
                if (n2 != 0) {
                    this.font = this.font.deriveFont(n2);
                }
            }
        }
    }
}

