/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.commons.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class ScilabCaret
extends DefaultCaret {
    private static final long serialVersionUID = 8230195712653828841L;
    private static Color selectionColor;
    private static Color inactiveSelectionColor;
    private JTextComponent editor;
    private boolean overwriteMode;
    private boolean mustAdjustVisibility = true;

    public ScilabCaret(JTextComponent jTextComponent) {
        this.editor = jTextComponent;
        this.setSelectionColor(jTextComponent.getSelectionColor(), UIManager.getColor("TextComponent.selectionBackgroundInactive"));
    }

    @Override
    protected void adjustVisibility(Rectangle rectangle) {
        if (this.mustAdjustVisibility) {
            super.adjustVisibility(rectangle);
        }
    }

    public void setMustAdjustVisibility(boolean bl) {
        this.mustAdjustVisibility = bl;
    }

    public boolean getMustAdjustVisibility() {
        return this.mustAdjustVisibility;
    }

    public void setSelectionColor(Color color, Color color2) {
        selectionColor = color;
        inactiveSelectionColor = color2;
        if (inactiveSelectionColor == null) {
            float f = 0.6f * (float)selectionColor.getRed() / 255.0f + 0.4f * (float)Color.LIGHT_GRAY.getRed() / 255.0f;
            float f2 = 0.6f * (float)selectionColor.getGreen() / 255.0f + 0.4f * (float)Color.LIGHT_GRAY.getGreen() / 255.0f;
            float f3 = 0.6f * (float)selectionColor.getBlue() / 255.0f + 0.4f * (float)Color.LIGHT_GRAY.getBlue() / 255.0f;
            inactiveSelectionColor = new Color(f, f2, f3);
        }
    }

    public Color getSelectionColor() {
        return selectionColor;
    }

    public Color getInactiveSelectionColor() {
        return inactiveSelectionColor;
    }

    @Override
    public void setSelectionVisible(boolean bl) {
        super.setSelectionVisible(true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.editor.setSelectionColor(selectionColor);
        this.editor.repaint();
        super.focusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.editor.setSelectionColor(inactiveSelectionColor);
        this.editor.repaint();
        super.focusLost(focusEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.editor.setSelectionColor(selectionColor);
        super.mouseDragged(mouseEvent);
    }

    public void setOverwriteMode(boolean bl) {
        this.overwriteMode = bl;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isVisible() && this.overwriteMode) {
            Rectangle rectangle = null;
            int n = this.editor.getCaretPosition();
            try {
                rectangle = this.editor.modelToView(n);
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
            if (rectangle != null && (rectangle.width != 0 || rectangle.height != 0)) {
                if (this.x != rectangle.x || this.y != rectangle.y) {
                    this.repaint();
                    this.x = rectangle.x;
                    this.y = rectangle.y;
                    this.height = rectangle.height;
                    this.width = this.editor.getFontMetrics(this.editor.getFont()).charWidth('W') + 1;
                } else {
                    graphics.setColor(this.editor.getCaretColor());
                    graphics.setXORMode(this.editor.getBackground());
                    graphics.fillRect(this.x, this.y, this.width, this.height);
                }
            }
        } else {
            super.paint(graphics);
        }
    }

    @Override
    protected synchronized void damage(Rectangle rectangle) {
        if (this.overwriteMode) {
            if (rectangle == null) {
                return;
            }
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.height = rectangle.height;
            this.repaint();
        } else {
            super.damage(rectangle);
        }
    }
}

