/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.jvm;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.Arrays;
import jdk.internal.loader.NativeLibraries;

public class LibraryPath {
    private static final String JAVALIBRARYPATH = "java.library.path";

    protected LibraryPath() {
        throw new UnsupportedOperationException();
    }

    private static boolean pathAlreadyExists(String string, String string2) {
        String[] stringArray;
        for (String string3 : stringArray = string.split("" + File.pathSeparatorChar)) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static void addPath(String string) throws IOException {
        if (!LibraryPath.pathAlreadyExists(System.getProperty(JAVALIBRARYPATH), string)) {
            String string2 = System.getProperty(JAVALIBRARYPATH) + File.pathSeparator + string;
            System.setProperty(JAVALIBRARYPATH, string2);
            try {
                Class<?>[] classArray = NativeLibraries.class.getDeclaredClasses();
                Class clazz2 = Arrays.stream(classArray).filter(clazz -> clazz.getSimpleName().equals("LibraryPaths")).findFirst().get();
                Field field = clazz2.getDeclaredField("USER_PATHS");
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup());
                VarHandle varHandle = lookup.findVarHandle(Field.class, "modifiers", Integer.TYPE);
                varHandle.set(field, field.getModifiers() & 0xFFFFFFEF);
                field.setAccessible(true);
                String[] stringArray = (String[])field.get(null);
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = string;
                field.set(null, stringArray2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IOException("Error NoSuchFieldException, could not add path to java.library.path");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Error IllegalAccessException, could not add path to java.library.path");
            }
        }
    }

    public static String[] getLibraryPath() {
        String string = System.getProperty(JAVALIBRARYPATH);
        String[] stringArray = string.split("" + File.pathSeparatorChar);
        return stringArray;
    }
}

