/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import java.util.function.Consumer;
import org.cef.CefApp;
import org.cef.CefBrowserSettings;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserFactory;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefPaintEvent;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefPrintDialogCallback;
import org.cef.callback.CefPrintJobCallback;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefPrintHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefScreenInfo;
import org.cef.handler.CefWindowHandler;
import org.cef.misc.BoolRef;
import org.cef.misc.CefPrintSettings;
import org.cef.network.CefRequest;

public class CefClient
extends CefClientHandler
implements CefContextMenuHandler,
CefDialogHandler,
CefDisplayHandler,
CefDownloadHandler,
CefDragHandler,
CefFocusHandler,
CefJSDialogHandler,
CefKeyboardHandler,
CefLifeSpanHandler,
CefLoadHandler,
CefPrintHandler,
CefRenderHandler,
CefRequestHandler,
CefWindowHandler {
    private HashMap<Integer, CefBrowser> browser_ = new HashMap();
    private CefContextMenuHandler contextMenuHandler_ = null;
    private CefDialogHandler dialogHandler_ = null;
    private CefDisplayHandler displayHandler_ = null;
    private CefDownloadHandler downloadHandler_ = null;
    private CefDragHandler dragHandler_ = null;
    private CefFocusHandler focusHandler_ = null;
    private CefJSDialogHandler jsDialogHandler_ = null;
    private CefKeyboardHandler keyboardHandler_ = null;
    private CefLifeSpanHandler lifeSpanHandler_ = null;
    private CefLoadHandler loadHandler_ = null;
    private CefPrintHandler printHandler_ = null;
    private CefRequestHandler requestHandler_ = null;
    private boolean isDisposed_ = false;
    private volatile CefBrowser focusedBrowser_ = null;
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (CefClient.this.focusedBrowser_ != null) {
                Component component = CefClient.this.focusedBrowser_.getUIComponent();
                Object object = propertyChangeEvent.getOldValue();
                if (CefClient.this.isPartOf(object, component)) {
                    CefClient.this.focusedBrowser_.setFocus(false);
                    CefClient.this.focusedBrowser_ = null;
                }
            }
        }
    };

    CefClient() throws UnsatisfiedLinkError {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.propertyChangeListener);
    }

    private boolean isPartOf(Object object, Component component) {
        Component[] componentArray;
        Component[] componentArray2;
        int n;
        int n2;
        if (object == component) {
            return true;
        }
        if (object instanceof Container && (n2 = 0) < (n = (componentArray2 = (componentArray = ((Container)object).getComponents())).length)) {
            Component component2 = componentArray2[n2];
            return this.isPartOf(component2, component);
        }
        return false;
    }

    @Override
    public void dispose() {
        this.isDisposed_ = true;
        this.cleanupBrowser(-1);
    }

    public CefBrowser createBrowser(String string, boolean bl, boolean bl2) {
        return this.createBrowser(string, bl, bl2, null);
    }

    public CefBrowser createBrowser(String string, boolean bl, boolean bl2, CefRequestContext cefRequestContext) {
        if (this.isDisposed_) {
            throw new IllegalStateException("Can't create browser. CefClient is disposed");
        }
        return CefBrowserFactory.create(this, string, bl, bl2, cefRequestContext, null);
    }

    public CefBrowser createBrowser(String string, boolean bl, boolean bl2, CefRequestContext cefRequestContext, CefBrowserSettings cefBrowserSettings) {
        if (this.isDisposed_) {
            throw new IllegalStateException("Can't create browser. CefClient is disposed");
        }
        return CefBrowserFactory.create(this, string, bl, bl2, cefRequestContext, cefBrowserSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CefBrowser getBrowser(int n) {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            return this.browser_.get(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object[] getAllBrowser() {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            return this.browser_.values().toArray();
        }
    }

    @Override
    protected CefContextMenuHandler getContextMenuHandler() {
        return this;
    }

    @Override
    protected CefDialogHandler getDialogHandler() {
        return this;
    }

    @Override
    protected CefDisplayHandler getDisplayHandler() {
        return this;
    }

    @Override
    protected CefDownloadHandler getDownloadHandler() {
        return this;
    }

    @Override
    protected CefDragHandler getDragHandler() {
        return this;
    }

    @Override
    protected CefFocusHandler getFocusHandler() {
        return this;
    }

    @Override
    protected CefJSDialogHandler getJSDialogHandler() {
        return this;
    }

    @Override
    protected CefKeyboardHandler getKeyboardHandler() {
        return this;
    }

    @Override
    protected CefLifeSpanHandler getLifeSpanHandler() {
        return this;
    }

    @Override
    protected CefLoadHandler getLoadHandler() {
        return this;
    }

    @Override
    protected CefPrintHandler getPrintHandler() {
        return this;
    }

    @Override
    protected CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    protected CefRequestHandler getRequestHandler() {
        return this;
    }

    @Override
    protected CefWindowHandler getWindowHandler() {
        return this;
    }

    public CefClient addContextMenuHandler(CefContextMenuHandler cefContextMenuHandler) {
        if (this.contextMenuHandler_ == null) {
            this.contextMenuHandler_ = cefContextMenuHandler;
        }
        return this;
    }

    public void removeContextMenuHandler() {
        this.contextMenuHandler_ = null;
    }

    @Override
    public void onBeforeContextMenu(CefBrowser cefBrowser, CefFrame cefFrame, CefContextMenuParams cefContextMenuParams, CefMenuModel cefMenuModel) {
        if (this.contextMenuHandler_ != null && cefBrowser != null) {
            this.contextMenuHandler_.onBeforeContextMenu(cefBrowser, cefFrame, cefContextMenuParams, cefMenuModel);
        }
    }

    @Override
    public boolean onContextMenuCommand(CefBrowser cefBrowser, CefFrame cefFrame, CefContextMenuParams cefContextMenuParams, int n, int n2) {
        if (this.contextMenuHandler_ != null && cefBrowser != null) {
            return this.contextMenuHandler_.onContextMenuCommand(cefBrowser, cefFrame, cefContextMenuParams, n, n2);
        }
        return false;
    }

    @Override
    public void onContextMenuDismissed(CefBrowser cefBrowser, CefFrame cefFrame) {
        if (this.contextMenuHandler_ != null && cefBrowser != null) {
            this.contextMenuHandler_.onContextMenuDismissed(cefBrowser, cefFrame);
        }
    }

    public CefClient addDialogHandler(CefDialogHandler cefDialogHandler) {
        if (this.dialogHandler_ == null) {
            this.dialogHandler_ = cefDialogHandler;
        }
        return this;
    }

    public void removeDialogHandler() {
        this.dialogHandler_ = null;
    }

    @Override
    public boolean onFileDialog(CefBrowser cefBrowser, CefDialogHandler.FileDialogMode fileDialogMode, String string, String string2, Vector<String> vector, Vector<String> vector2, Vector<String> vector3, CefFileDialogCallback cefFileDialogCallback) {
        if (this.dialogHandler_ != null && cefBrowser != null) {
            return this.dialogHandler_.onFileDialog(cefBrowser, fileDialogMode, string, string2, vector, vector2, vector3, cefFileDialogCallback);
        }
        return false;
    }

    public CefClient addDisplayHandler(CefDisplayHandler cefDisplayHandler) {
        if (this.displayHandler_ == null) {
            this.displayHandler_ = cefDisplayHandler;
        }
        return this;
    }

    public void removeDisplayHandler() {
        this.displayHandler_ = null;
    }

    @Override
    public void onAddressChange(CefBrowser cefBrowser, CefFrame cefFrame, String string) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            this.displayHandler_.onAddressChange(cefBrowser, cefFrame, string);
        }
    }

    @Override
    public void onTitleChange(CefBrowser cefBrowser, String string) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            this.displayHandler_.onTitleChange(cefBrowser, string);
        }
    }

    @Override
    public void onFullscreenModeChange(CefBrowser cefBrowser, boolean bl) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            this.displayHandler_.onFullscreenModeChange(cefBrowser, bl);
        }
    }

    @Override
    public boolean onTooltip(CefBrowser cefBrowser, String string) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            return this.displayHandler_.onTooltip(cefBrowser, string);
        }
        return false;
    }

    @Override
    public void onStatusMessage(CefBrowser cefBrowser, String string) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            this.displayHandler_.onStatusMessage(cefBrowser, string);
        }
    }

    @Override
    public boolean onConsoleMessage(CefBrowser cefBrowser, CefSettings.LogSeverity logSeverity, String string, String string2, int n) {
        if (this.displayHandler_ != null && cefBrowser != null) {
            return this.displayHandler_.onConsoleMessage(cefBrowser, logSeverity, string, string2, n);
        }
        return false;
    }

    @Override
    public boolean onCursorChange(CefBrowser cefBrowser, int n) {
        if (cefBrowser == null) {
            return false;
        }
        if (this.displayHandler_ != null && this.displayHandler_.onCursorChange(cefBrowser, n)) {
            return true;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            return cefRenderHandler.onCursorChange(cefBrowser, n);
        }
        return false;
    }

    public CefClient addDownloadHandler(CefDownloadHandler cefDownloadHandler) {
        if (this.downloadHandler_ == null) {
            this.downloadHandler_ = cefDownloadHandler;
        }
        return this;
    }

    public void removeDownloadHandler() {
        this.downloadHandler_ = null;
    }

    @Override
    public boolean onBeforeDownload(CefBrowser cefBrowser, CefDownloadItem cefDownloadItem, String string, CefBeforeDownloadCallback cefBeforeDownloadCallback) {
        if (this.downloadHandler_ != null && cefBrowser != null) {
            return this.downloadHandler_.onBeforeDownload(cefBrowser, cefDownloadItem, string, cefBeforeDownloadCallback);
        }
        return false;
    }

    @Override
    public void onDownloadUpdated(CefBrowser cefBrowser, CefDownloadItem cefDownloadItem, CefDownloadItemCallback cefDownloadItemCallback) {
        if (this.downloadHandler_ != null && cefBrowser != null) {
            this.downloadHandler_.onDownloadUpdated(cefBrowser, cefDownloadItem, cefDownloadItemCallback);
        }
    }

    public CefClient addDragHandler(CefDragHandler cefDragHandler) {
        if (this.dragHandler_ == null) {
            this.dragHandler_ = cefDragHandler;
        }
        return this;
    }

    public void removeDragHandler() {
        this.dragHandler_ = null;
    }

    @Override
    public boolean onDragEnter(CefBrowser cefBrowser, CefDragData cefDragData, int n) {
        if (this.dragHandler_ != null && cefBrowser != null) {
            return this.dragHandler_.onDragEnter(cefBrowser, cefDragData, n);
        }
        return false;
    }

    public CefClient addFocusHandler(CefFocusHandler cefFocusHandler) {
        if (this.focusHandler_ == null) {
            this.focusHandler_ = cefFocusHandler;
        }
        return this;
    }

    public void removeFocusHandler() {
        this.focusHandler_ = null;
    }

    @Override
    public void onTakeFocus(CefBrowser cefBrowser, boolean bl) {
        Container container;
        if (cefBrowser == null) {
            return;
        }
        cefBrowser.setFocus(false);
        if (container != null) {
            FocusTraversalPolicy focusTraversalPolicy = null;
            for (container = cefBrowser.getUIComponent().getParent(); container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) == null; container = container.getParent()) {
            }
            if (focusTraversalPolicy != null) {
                Component component;
                Component component2 = component = bl ? focusTraversalPolicy.getComponentAfter(container, cefBrowser.getUIComponent()) : focusTraversalPolicy.getComponentBefore(container, cefBrowser.getUIComponent());
                if (component == null) {
                    focusTraversalPolicy.getDefaultComponent(container).requestFocus();
                } else {
                    component.requestFocus();
                }
            }
        }
        this.focusedBrowser_ = null;
        if (this.focusHandler_ != null) {
            this.focusHandler_.onTakeFocus(cefBrowser, bl);
        }
    }

    @Override
    public boolean onSetFocus(CefBrowser cefBrowser, CefFocusHandler.FocusSource focusSource) {
        if (cefBrowser == null) {
            return false;
        }
        boolean bl = false;
        if (this.focusHandler_ != null) {
            bl = this.focusHandler_.onSetFocus(cefBrowser, focusSource);
        }
        return bl;
    }

    @Override
    public void onGotFocus(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return;
        }
        this.focusedBrowser_ = cefBrowser;
        cefBrowser.setFocus(true);
        if (this.focusHandler_ != null) {
            this.focusHandler_.onGotFocus(cefBrowser);
        }
    }

    public CefClient addJSDialogHandler(CefJSDialogHandler cefJSDialogHandler) {
        if (this.jsDialogHandler_ == null) {
            this.jsDialogHandler_ = cefJSDialogHandler;
        }
        return this;
    }

    public void removeJSDialogHandler() {
        this.jsDialogHandler_ = null;
    }

    @Override
    public boolean onJSDialog(CefBrowser cefBrowser, String string, CefJSDialogHandler.JSDialogType jSDialogType, String string2, String string3, CefJSDialogCallback cefJSDialogCallback, BoolRef boolRef) {
        if (this.jsDialogHandler_ != null && cefBrowser != null) {
            return this.jsDialogHandler_.onJSDialog(cefBrowser, string, jSDialogType, string2, string3, cefJSDialogCallback, boolRef);
        }
        return false;
    }

    @Override
    public boolean onBeforeUnloadDialog(CefBrowser cefBrowser, String string, boolean bl, CefJSDialogCallback cefJSDialogCallback) {
        if (this.jsDialogHandler_ != null && cefBrowser != null) {
            return this.jsDialogHandler_.onBeforeUnloadDialog(cefBrowser, string, bl, cefJSDialogCallback);
        }
        return false;
    }

    @Override
    public void onResetDialogState(CefBrowser cefBrowser) {
        if (this.jsDialogHandler_ != null && cefBrowser != null) {
            this.jsDialogHandler_.onResetDialogState(cefBrowser);
        }
    }

    @Override
    public void onDialogClosed(CefBrowser cefBrowser) {
        if (this.jsDialogHandler_ != null && cefBrowser != null) {
            this.jsDialogHandler_.onDialogClosed(cefBrowser);
        }
    }

    public CefClient addKeyboardHandler(CefKeyboardHandler cefKeyboardHandler) {
        if (this.keyboardHandler_ == null) {
            this.keyboardHandler_ = cefKeyboardHandler;
        }
        return this;
    }

    public void removeKeyboardHandler() {
        this.keyboardHandler_ = null;
    }

    @Override
    public boolean onPreKeyEvent(CefBrowser cefBrowser, CefKeyboardHandler.CefKeyEvent cefKeyEvent, BoolRef boolRef) {
        if (this.keyboardHandler_ != null && cefBrowser != null) {
            return this.keyboardHandler_.onPreKeyEvent(cefBrowser, cefKeyEvent, boolRef);
        }
        return false;
    }

    @Override
    public boolean onKeyEvent(CefBrowser cefBrowser, CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
        if (this.keyboardHandler_ != null && cefBrowser != null) {
            return this.keyboardHandler_.onKeyEvent(cefBrowser, cefKeyEvent);
        }
        return false;
    }

    public CefClient addLifeSpanHandler(CefLifeSpanHandler cefLifeSpanHandler) {
        if (this.lifeSpanHandler_ == null) {
            this.lifeSpanHandler_ = cefLifeSpanHandler;
        }
        return this;
    }

    public void removeLifeSpanHandler() {
        this.lifeSpanHandler_ = null;
    }

    @Override
    public boolean onBeforePopup(CefBrowser cefBrowser, CefFrame cefFrame, String string, String string2) {
        if (this.isDisposed_) {
            return true;
        }
        if (this.lifeSpanHandler_ != null && cefBrowser != null) {
            return this.lifeSpanHandler_.onBeforePopup(cefBrowser, cefFrame, string, string2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterCreated(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return;
        }
        Integer n = cefBrowser.getIdentifier();
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            this.browser_.put(n, cefBrowser);
        }
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onAfterCreated(cefBrowser);
        }
    }

    @Override
    public void onAfterParentChanged(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return;
        }
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onAfterParentChanged(cefBrowser);
        }
    }

    @Override
    public boolean doClose(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return false;
        }
        if (this.lifeSpanHandler_ != null) {
            return this.lifeSpanHandler_.doClose(cefBrowser);
        }
        return cefBrowser.doClose();
    }

    @Override
    public void onBeforeClose(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return;
        }
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onBeforeClose(cefBrowser);
        }
        cefBrowser.onBeforeClose();
        this.cleanupBrowser(cefBrowser.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupBrowser(int n) {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            if (n >= 0) {
                this.browser_.remove(n);
            } else if (!this.browser_.isEmpty()) {
                Collection<CefBrowser> collection = this.browser_.values();
                for (CefBrowser cefBrowser : collection) {
                    cefBrowser.close(true);
                }
                return;
            }
            if (this.browser_.isEmpty() && this.isDisposed_) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.propertyChangeListener);
                this.removeContextMenuHandler(this);
                this.removeDialogHandler(this);
                this.removeDisplayHandler(this);
                this.removeDownloadHandler(this);
                this.removeDragHandler(this);
                this.removeFocusHandler(this);
                this.removeJSDialogHandler(this);
                this.removeKeyboardHandler(this);
                this.removeLifeSpanHandler(this);
                this.removeLoadHandler(this);
                this.removePrintHandler(this);
                this.removeRenderHandler(this);
                this.removeRequestHandler(this);
                this.removeWindowHandler(this);
                super.dispose();
                CefApp.getInstance().clientWasDisposed(this);
            }
        }
    }

    public CefClient addLoadHandler(CefLoadHandler cefLoadHandler) {
        if (this.loadHandler_ == null) {
            this.loadHandler_ = cefLoadHandler;
        }
        return this;
    }

    public void removeLoadHandler() {
        this.loadHandler_ = null;
    }

    @Override
    public void onLoadingStateChange(CefBrowser cefBrowser, boolean bl, boolean bl2, boolean bl3) {
        if (this.loadHandler_ != null && cefBrowser != null) {
            this.loadHandler_.onLoadingStateChange(cefBrowser, bl, bl2, bl3);
        }
    }

    @Override
    public void onLoadStart(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest.TransitionType transitionType) {
        if (this.loadHandler_ != null && cefBrowser != null) {
            this.loadHandler_.onLoadStart(cefBrowser, cefFrame, transitionType);
        }
    }

    @Override
    public void onLoadEnd(CefBrowser cefBrowser, CefFrame cefFrame, int n) {
        if (this.loadHandler_ != null && cefBrowser != null) {
            this.loadHandler_.onLoadEnd(cefBrowser, cefFrame, n);
        }
    }

    @Override
    public void onLoadError(CefBrowser cefBrowser, CefFrame cefFrame, CefLoadHandler.ErrorCode errorCode, String string, String string2) {
        if (this.loadHandler_ != null && cefBrowser != null) {
            this.loadHandler_.onLoadError(cefBrowser, cefFrame, errorCode, string, string2);
        }
    }

    public CefClient addPrintHandler(CefPrintHandler cefPrintHandler) {
        if (this.printHandler_ == null) {
            this.printHandler_ = cefPrintHandler;
        }
        return this;
    }

    public void removePrintHandler() {
        this.printHandler_ = null;
    }

    @Override
    public void onPrintStart(CefBrowser cefBrowser) {
        if (this.printHandler_ != null && cefBrowser != null) {
            this.printHandler_.onPrintStart(cefBrowser);
        }
    }

    @Override
    public void onPrintSettings(CefBrowser cefBrowser, CefPrintSettings cefPrintSettings, boolean bl) {
        if (this.printHandler_ != null && cefBrowser != null) {
            this.printHandler_.onPrintSettings(cefBrowser, cefPrintSettings, bl);
        }
    }

    @Override
    public boolean onPrintDialog(CefBrowser cefBrowser, boolean bl, CefPrintDialogCallback cefPrintDialogCallback) {
        if (this.printHandler_ != null && cefBrowser != null) {
            return this.printHandler_.onPrintDialog(cefBrowser, bl, cefPrintDialogCallback);
        }
        return false;
    }

    @Override
    public boolean onPrintJob(CefBrowser cefBrowser, String string, String string2, CefPrintJobCallback cefPrintJobCallback) {
        if (this.printHandler_ != null && cefBrowser != null) {
            return this.printHandler_.onPrintJob(cefBrowser, string, string2, cefPrintJobCallback);
        }
        return false;
    }

    @Override
    public void onPrintReset(CefBrowser cefBrowser) {
        if (this.printHandler_ != null && cefBrowser != null) {
            this.printHandler_.onPrintReset(cefBrowser);
        }
    }

    @Override
    public Dimension getPdfPaperSize(CefBrowser cefBrowser, int n) {
        if (this.printHandler_ != null && cefBrowser != null) {
            return this.printHandler_.getPdfPaperSize(cefBrowser, n);
        }
        return null;
    }

    @Override
    public synchronized void addMessageRouter(CefMessageRouter cefMessageRouter) {
        super.addMessageRouter(cefMessageRouter);
    }

    @Override
    public synchronized void removeMessageRouter(CefMessageRouter cefMessageRouter) {
        super.removeMessageRouter(cefMessageRouter);
    }

    @Override
    public Rectangle getViewRect(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            return cefRenderHandler.getViewRect(cefBrowser);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public Point getScreenPoint(CefBrowser cefBrowser, Point point) {
        if (cefBrowser == null) {
            return new Point(0, 0);
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            return cefRenderHandler.getScreenPoint(cefBrowser, point);
        }
        return new Point(0, 0);
    }

    @Override
    public void onPopupShow(CefBrowser cefBrowser, boolean bl) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.onPopupShow(cefBrowser, bl);
        }
    }

    @Override
    public void onPopupSize(CefBrowser cefBrowser, Rectangle rectangle) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.onPopupSize(cefBrowser, rectangle);
        }
    }

    @Override
    public void onPaint(CefBrowser cefBrowser, boolean bl, Rectangle[] rectangleArray, ByteBuffer byteBuffer, int n, int n2) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.onPaint(cefBrowser, bl, rectangleArray, byteBuffer, n, n2);
        }
    }

    @Override
    public void addOnPaintListener(Consumer<CefPaintEvent> consumer) {
    }

    @Override
    public void setOnPaintListener(Consumer<CefPaintEvent> consumer) {
    }

    @Override
    public void removeOnPaintListener(Consumer<CefPaintEvent> consumer) {
    }

    @Override
    public boolean startDragging(CefBrowser cefBrowser, CefDragData cefDragData, int n, int n2, int n3) {
        if (cefBrowser == null) {
            return false;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            return cefRenderHandler.startDragging(cefBrowser, cefDragData, n, n2, n3);
        }
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser cefBrowser, int n) {
        if (cefBrowser == null) {
            return;
        }
        CefRenderHandler cefRenderHandler = cefBrowser.getRenderHandler();
        if (cefRenderHandler != null) {
            cefRenderHandler.updateDragCursor(cefBrowser, n);
        }
    }

    public CefClient addRequestHandler(CefRequestHandler cefRequestHandler) {
        if (this.requestHandler_ == null) {
            this.requestHandler_ = cefRequestHandler;
        }
        return this;
    }

    public void removeRequestHandler() {
        this.requestHandler_ = null;
    }

    @Override
    public boolean onBeforeBrowse(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest cefRequest, boolean bl, boolean bl2) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.onBeforeBrowse(cefBrowser, cefFrame, cefRequest, bl, bl2);
        }
        return false;
    }

    @Override
    public boolean onOpenURLFromTab(CefBrowser cefBrowser, CefFrame cefFrame, String string, boolean bl) {
        if (this.isDisposed_) {
            return true;
        }
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.onOpenURLFromTab(cefBrowser, cefFrame, string, bl);
        }
        return false;
    }

    @Override
    public CefResourceRequestHandler getResourceRequestHandler(CefBrowser cefBrowser, CefFrame cefFrame, CefRequest cefRequest, boolean bl, boolean bl2, String string, BoolRef boolRef) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.getResourceRequestHandler(cefBrowser, cefFrame, cefRequest, bl, bl2, string, boolRef);
        }
        return null;
    }

    @Override
    public boolean getAuthCredentials(CefBrowser cefBrowser, String string, boolean bl, String string2, int n, String string3, String string4, CefAuthCallback cefAuthCallback) {
        if (this.requestHandler_ != null && cefBrowser != null) {
            return this.requestHandler_.getAuthCredentials(cefBrowser, string, bl, string2, n, string3, string4, cefAuthCallback);
        }
        return false;
    }

    @Override
    public boolean onCertificateError(CefBrowser cefBrowser, CefLoadHandler.ErrorCode errorCode, String string, CefCallback cefCallback) {
        if (this.requestHandler_ != null) {
            return this.requestHandler_.onCertificateError(cefBrowser, errorCode, string, cefCallback);
        }
        return false;
    }

    @Override
    public void onRenderProcessTerminated(CefBrowser cefBrowser, CefRequestHandler.TerminationStatus terminationStatus, int n, String string) {
        if (this.requestHandler_ != null) {
            this.requestHandler_.onRenderProcessTerminated(cefBrowser, terminationStatus, n, string);
        }
    }

    @Override
    public Rectangle getRect(CefBrowser cefBrowser) {
        if (cefBrowser == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        CefWindowHandler cefWindowHandler = cefBrowser.getWindowHandler();
        if (cefWindowHandler != null) {
            return cefWindowHandler.getRect(cefBrowser);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public void onMouseEvent(CefBrowser cefBrowser, int n, int n2, int n3, int n4, int n5) {
        if (cefBrowser == null) {
            return;
        }
        CefWindowHandler cefWindowHandler = cefBrowser.getWindowHandler();
        if (cefWindowHandler != null) {
            cefWindowHandler.onMouseEvent(cefBrowser, n, n2, n3, n4, n5);
        }
    }

    @Override
    public boolean getScreenInfo(CefBrowser cefBrowser, CefScreenInfo cefScreenInfo) {
        return false;
    }
}

