/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import javax.swing.SwingUtilities;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefDevToolsClient;
import org.cef.browser.CefDevToolsMessageObserver;
import org.cef.browser.CefFrame;
import org.cef.browser.CefRegistration;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.callback.CefNativeAdapter;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefWindowHandler;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.network.CefRequest;

abstract class CefBrowser_N
extends CefNativeAdapter
implements CefBrowser {
    private volatile boolean isPending_ = false;
    private final CefClient client_;
    private final String url_;
    private final CefRequestContext request_context_;
    private volatile CefBrowser_N parent_ = null;
    private volatile Point inspectAt_ = null;
    private volatile CefDevToolsClient devToolsClient_ = null;
    private boolean closeAllowed_ = false;
    private volatile boolean isClosed_ = false;
    private volatile boolean isClosing_ = false;
    private final CefBrowserSettings settings_;

    protected CefBrowser_N(CefClient cefClient, String string, CefRequestContext cefRequestContext, CefBrowser_N cefBrowser_N, Point point, CefBrowserSettings cefBrowserSettings) {
        this.client_ = cefClient;
        this.url_ = string;
        this.request_context_ = cefRequestContext;
        this.parent_ = cefBrowser_N;
        this.inspectAt_ = point;
        this.settings_ = cefBrowserSettings != null ? cefBrowserSettings.clone() : new CefBrowserSettings();
    }

    protected String getUrl() {
        return this.url_;
    }

    protected CefRequestContext getRequestContext() {
        return this.request_context_;
    }

    protected CefBrowser_N getParentBrowser() {
        return this.parent_;
    }

    protected Point getInspectAt() {
        return this.inspectAt_;
    }

    protected boolean isClosed() {
        return this.isClosed_;
    }

    @Override
    public CefClient getClient() {
        return this.client_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return null;
    }

    @Override
    public CefWindowHandler getWindowHandler() {
        return null;
    }

    @Override
    public synchronized void setCloseAllowed() {
        this.closeAllowed_ = true;
    }

    @Override
    public synchronized boolean doClose() {
        if (this.closeAllowed_) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component component = SwingUtilities.getRoot(CefBrowser_N.this.getUIComponent());
                if (component != null) {
                    component.dispatchEvent(new WindowEvent((Window)component, 201));
                }
            }
        });
        return true;
    }

    @Override
    public synchronized void onBeforeClose() {
        this.isClosed_ = true;
        if (this.request_context_ != null) {
            this.request_context_.dispose();
        }
        if (this.parent_ != null) {
            this.parent_.closeDevTools();
            this.parent_ = null;
        }
        if (this.devToolsClient_ != null) {
            this.devToolsClient_.close();
        }
    }

    @Override
    public void openDevTools() {
        this.openDevTools(null);
    }

    @Override
    public synchronized void openDevTools(Point point) {
        this.createDevToolsBrowser(this.client_, this.url_, this.request_context_, this, point).createImmediately();
    }

    @Override
    public synchronized CefDevToolsClient getDevToolsClient() {
        if (!this.isPending_ || this.isClosing_ || this.isClosed_) {
            return null;
        }
        if (this.devToolsClient_ == null || this.devToolsClient_.isClosed()) {
            this.devToolsClient_ = new CefDevToolsClient(this);
        }
        return this.devToolsClient_;
    }

    CompletableFuture<Integer> executeDevToolsMethod(final String string, String string2) {
        final CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        this.N_ExecuteDevToolsMethod(string, string2, new IntCallback(){

            @Override
            public void onComplete(int n) {
                if (n <= 0) {
                    completableFuture.completeExceptionally(new CefDevToolsClient.DevToolsException(String.format("Failed to execute DevTools method %s", string)));
                } else {
                    completableFuture.complete(n);
                }
            }
        });
        return completableFuture;
    }

    CefRegistration addDevToolsMessageObserver(CefDevToolsMessageObserver cefDevToolsMessageObserver) {
        return this.N_AddDevToolsMessageObserver(cefDevToolsMessageObserver);
    }

    protected abstract CefBrowser_N createDevToolsBrowser(CefClient var1, String var2, CefRequestContext var3, CefBrowser_N var4, Point var5);

    protected void createBrowser(CefClientHandler cefClientHandler, long l, String string, boolean bl, boolean bl2, Component component, CefRequestContext cefRequestContext) {
        if (this.getNativeRef("CefBrowser") == 0L && !this.isPending_) {
            try {
                this.N_CreateBrowser(cefClientHandler, l, string, bl, bl2, component, cefRequestContext, this.settings_);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
    }

    private void notifyBrowserCreated() {
        this.isPending_ = true;
    }

    protected final void createDevTools(CefBrowser_N cefBrowser_N, CefClientHandler cefClientHandler, long l, boolean bl, boolean bl2, Component component, Point point) {
        if (this.getNativeRef("CefBrowser") == 0L && !this.isPending_) {
            try {
                this.isPending_ = this.N_CreateDevTools(cefBrowser_N, cefClientHandler, l, bl, bl2, component, point);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
    }

    protected final long getWindowHandle(long l) {
        try {
            return this.N_GetWindowHandle(l);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.close(true);
        super.finalize();
    }

    @Override
    public boolean canGoBack() {
        try {
            return this.N_CanGoBack();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return false;
        }
    }

    @Override
    public void goBack() {
        try {
            this.N_GoBack();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public boolean canGoForward() {
        try {
            return this.N_CanGoForward();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return false;
        }
    }

    @Override
    public void goForward() {
        try {
            this.N_GoForward();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public boolean isLoading() {
        try {
            return this.N_IsLoading();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return false;
        }
    }

    @Override
    public void reload() {
        try {
            this.N_Reload();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void reloadIgnoreCache() {
        try {
            this.N_ReloadIgnoreCache();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void stopLoad() {
        try {
            this.N_StopLoad();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public int getIdentifier() {
        try {
            return this.N_GetIdentifier();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return -1;
        }
    }

    @Override
    public CefFrame getMainFrame() {
        try {
            return this.N_GetMainFrame();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return null;
        }
    }

    @Override
    public CefFrame getFocusedFrame() {
        try {
            return this.N_GetFocusedFrame();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return null;
        }
    }

    @Override
    public CefFrame getFrameByIdentifier(String string) {
        try {
            return this.N_GetFrameByIdentifier(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return null;
        }
    }

    @Override
    public CefFrame getFrameByName(String string) {
        try {
            return this.N_GetFrameByName(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return null;
        }
    }

    @Override
    public Vector<String> getFrameIdentifiers() {
        try {
            return this.N_GetFrameIdentifiers();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return null;
        }
    }

    @Override
    public Vector<String> getFrameNames() {
        try {
            return this.N_GetFrameNames();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return null;
        }
    }

    @Override
    public int getFrameCount() {
        try {
            return this.N_GetFrameCount();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return -1;
        }
    }

    @Override
    public boolean isPopup() {
        try {
            return this.N_IsPopup();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean hasDocument() {
        try {
            return this.N_HasDocument();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return false;
        }
    }

    @Override
    public void viewSource() {
        try {
            this.N_ViewSource();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void getSource(CefStringVisitor cefStringVisitor) {
        try {
            this.N_GetSource(cefStringVisitor);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void getText(CefStringVisitor cefStringVisitor) {
        try {
            this.N_GetText(cefStringVisitor);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void loadRequest(CefRequest cefRequest) {
        try {
            this.N_LoadRequest(cefRequest);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void loadURL(String string) {
        try {
            this.N_LoadURL(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void executeJavaScript(String string, String string2, int n) {
        try {
            this.N_ExecuteJavaScript(string, string2, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public String getURL() {
        try {
            return this.N_GetURL();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return "";
        }
    }

    @Override
    public void close(boolean bl) {
        if (this.isClosing_ || this.isClosed_) {
            return;
        }
        if (bl) {
            this.isClosing_ = true;
        }
        try {
            this.N_Close(bl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void setFocus(boolean bl) {
        try {
            this.N_SetFocus(bl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void setWindowVisibility(boolean bl) {
        try {
            this.N_SetWindowVisibility(bl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public double getZoomLevel() {
        try {
            return this.N_GetZoomLevel();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public void setZoomLevel(double d) {
        try {
            this.N_SetZoomLevel(d);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void runFileDialog(CefDialogHandler.FileDialogMode fileDialogMode, String string, String string2, Vector<String> vector, int n, CefRunFileDialogCallback cefRunFileDialogCallback) {
        try {
            this.N_RunFileDialog(fileDialogMode, string, string2, vector, n, cefRunFileDialogCallback);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void startDownload(String string) {
        try {
            this.N_StartDownload(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void print() {
        try {
            this.N_Print();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void printToPDF(String string, CefPdfPrintSettings cefPdfPrintSettings, CefPdfPrintCallback cefPdfPrintCallback) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("path was null or empty");
        }
        try {
            this.N_PrintToPDF(string, cefPdfPrintSettings, cefPdfPrintCallback);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void find(String string, boolean bl, boolean bl2, boolean bl3) {
        try {
            this.N_Find(string, bl, bl2, bl3);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void stopFinding(boolean bl) {
        try {
            this.N_StopFinding(bl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void closeDevTools() {
        try {
            this.N_CloseDevTools();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void replaceMisspelling(String string) {
        try {
            this.N_ReplaceMisspelling(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void wasResized(int n, int n2) {
        try {
            this.N_WasResized(n, n2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void invalidate() {
        try {
            this.N_Invalidate();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void sendKeyEvent(KeyEvent keyEvent) {
        try {
            this.N_SendKeyEvent(keyEvent);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void sendMouseEvent(MouseEvent mouseEvent) {
        try {
            this.N_SendMouseEvent(mouseEvent);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void sendMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        try {
            this.N_SendMouseWheelEvent(mouseWheelEvent);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void dragTargetDragEnter(CefDragData cefDragData, Point point, int n, int n2) {
        try {
            this.N_DragTargetDragEnter(cefDragData, point, n, n2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void dragTargetDragOver(Point point, int n, int n2) {
        try {
            this.N_DragTargetDragOver(point, n, n2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void dragTargetDragLeave() {
        try {
            this.N_DragTargetDragLeave();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void dragTargetDrop(Point point, int n) {
        try {
            this.N_DragTargetDrop(point, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void dragSourceEndedAt(Point point, int n) {
        try {
            this.N_DragSourceEndedAt(point, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void dragSourceSystemDragEnded() {
        try {
            this.N_DragSourceSystemDragEnded();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void updateUI(Rectangle rectangle, Rectangle rectangle2) {
        try {
            this.N_UpdateUI(rectangle, rectangle2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void setParent(long l, Component component) {
        if (this.isClosing_ || this.isClosed_) {
            return;
        }
        try {
            this.N_SetParent(l, component);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    protected final void notifyMoveOrResizeStarted() {
        try {
            this.N_NotifyMoveOrResizeStarted();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public void setWindowlessFrameRate(int n) {
        try {
            this.N_SetWindowlessFrameRate(n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    @Override
    public CompletableFuture<Integer> getWindowlessFrameRate() {
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        try {
            this.N_GetWindowlessFrameRate(completableFuture::complete);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            completableFuture.complete(0);
        }
        return completableFuture;
    }

    private final native boolean N_CreateBrowser(CefClientHandler var1, long var2, String var4, boolean var5, boolean var6, Component var7, CefRequestContext var8, CefBrowserSettings var9);

    private final native boolean N_CreateDevTools(CefBrowser var1, CefClientHandler var2, long var3, boolean var5, boolean var6, Component var7, Point var8);

    private final native void N_ExecuteDevToolsMethod(String var1, String var2, IntCallback var3);

    private final native CefRegistration N_AddDevToolsMessageObserver(CefDevToolsMessageObserver var1);

    private final native long N_GetWindowHandle(long var1);

    private final native boolean N_CanGoBack();

    private final native void N_GoBack();

    private final native boolean N_CanGoForward();

    private final native void N_GoForward();

    private final native boolean N_IsLoading();

    private final native void N_Reload();

    private final native void N_ReloadIgnoreCache();

    private final native void N_StopLoad();

    private final native int N_GetIdentifier();

    private final native CefFrame N_GetMainFrame();

    private final native CefFrame N_GetFocusedFrame();

    private final native CefFrame N_GetFrameByIdentifier(String var1);

    private final native CefFrame N_GetFrameByName(String var1);

    private final native Vector<String> N_GetFrameIdentifiers();

    private final native Vector<String> N_GetFrameNames();

    private final native int N_GetFrameCount();

    private final native boolean N_IsPopup();

    private final native boolean N_HasDocument();

    private final native void N_ViewSource();

    private final native void N_GetSource(CefStringVisitor var1);

    private final native void N_GetText(CefStringVisitor var1);

    private final native void N_LoadRequest(CefRequest var1);

    private final native void N_LoadURL(String var1);

    private final native void N_ExecuteJavaScript(String var1, String var2, int var3);

    private final native String N_GetURL();

    private final native void N_Close(boolean var1);

    private final native void N_SetFocus(boolean var1);

    private final native void N_SetWindowVisibility(boolean var1);

    private final native double N_GetZoomLevel();

    private final native void N_SetZoomLevel(double var1);

    private final native void N_RunFileDialog(CefDialogHandler.FileDialogMode var1, String var2, String var3, Vector<String> var4, int var5, CefRunFileDialogCallback var6);

    private final native void N_StartDownload(String var1);

    private final native void N_Print();

    private final native void N_PrintToPDF(String var1, CefPdfPrintSettings var2, CefPdfPrintCallback var3);

    private final native void N_Find(String var1, boolean var2, boolean var3, boolean var4);

    private final native void N_StopFinding(boolean var1);

    private final native void N_CloseDevTools();

    private final native void N_ReplaceMisspelling(String var1);

    private final native void N_WasResized(int var1, int var2);

    private final native void N_Invalidate();

    private final native void N_SendKeyEvent(KeyEvent var1);

    private final native void N_SendMouseEvent(MouseEvent var1);

    private final native void N_SendMouseWheelEvent(MouseWheelEvent var1);

    private final native void N_DragTargetDragEnter(CefDragData var1, Point var2, int var3, int var4);

    private final native void N_DragTargetDragOver(Point var1, int var2, int var3);

    private final native void N_DragTargetDragLeave();

    private final native void N_DragTargetDrop(Point var1, int var2);

    private final native void N_DragSourceEndedAt(Point var1, int var2);

    private final native void N_DragSourceSystemDragEnded();

    private final native void N_UpdateUI(Rectangle var1, Rectangle var2);

    private final native void N_SetParent(long var1, Component var3);

    private final native void N_NotifyMoveOrResizeStarted();

    private final native void N_SetWindowlessFrameRate(int var1);

    private final native void N_GetWindowlessFrameRate(IntCallback var1);

    private static interface IntCallback {
        public void onComplete(int var1);
    }
}

