/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.BadLocationException;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.scinotes.KeywordEvent;
import org.scilab.modules.scinotes.MatchingBlockManager;
import org.scilab.modules.scinotes.MatchingBlockScanner;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.w3c.dom.Document;

public final class HelpOnTypingManager
implements KeyListener {
    private static HelpOnTypingManager instance;
    private boolean openers;
    private boolean keywords;

    private HelpOnTypingManager() {
        instance = this;
        this.openers = SciNotesOptions.getSciNotesDisplay().autoCompleteOpeners;
        this.keywords = SciNotesOptions.getSciNotesDisplay().autoCompleteKeywords;
    }

    public static void close() {
        instance = null;
    }

    public static HelpOnTypingManager getInstance() {
        if (instance == null) {
            instance = new HelpOnTypingManager();
        }
        return instance;
    }

    public void enableOpeners(boolean bl) {
        this.openers = bl;
        SciNotesOptions.getSciNotesDisplay().autoCompleteOpeners = bl;
        XConfiguration.set((Document)XConfiguration.getXConfigurationDocument(), (String)"//scinotes/display/body/scinotes-display/@auto-complete-openers", (String)Boolean.toString(bl));
    }

    public void enableKeywords(boolean bl) {
        this.keywords = bl;
        SciNotesOptions.getSciNotesDisplay().autoCompleteKeywords = bl;
        XConfiguration.set((Document)XConfiguration.getXConfigurationDocument(), (String)"//scinotes/display/body/scinotes-display/@auto-complete-keywords", (String)Boolean.toString(bl));
    }

    public boolean isActive() {
        return this.openers || this.keywords;
    }

    public boolean isOpenersActive() {
        return this.openers;
    }

    public boolean isKeywordsActive() {
        return this.keywords;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        ScilabEditorPane scilabEditorPane = ScilabEditorPane.getFocusedPane();
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        if (this.isActive() && c != '\uffff' && scilabEditorPane.getSelectionStart() == scilabEditorPane.getSelectionEnd()) {
            int n = scilabEditorPane.getCaretPosition();
            if (c == ' ' && keyEvent.getModifiers() == 0) {
                int n2 = scilabDocument.getDefaultRootElement().getElement(scilabDocument.getDefaultRootElement().getElementIndex(n)).getEndOffset() - 1;
                if (n == n2) {
                    try {
                        scilabDocument.insertString(n, " ", null);
                        keyEvent.consume();
                        KeywordEvent keywordEvent = scilabEditorPane.getKeywordEvent(n);
                        switch (keywordEvent.getType()) {
                            case 3: {
                                String string = scilabDocument.getText(keywordEvent.getStart(), keywordEvent.getLength());
                                if ("if".equals(string)) {
                                    if (!HelpOnTypingManager.complete("end", scilabEditorPane, scilabDocument, n)) break;
                                    scilabDocument.insertString(n + 1, " then\nend", null);
                                    int[] nArray = scilabEditorPane.getIndentManager().indentDoc(n + 1, n + 9);
                                    scilabEditorPane.setCaretPosition(nArray[0]);
                                    break;
                                }
                                if ("end".equals(string) || !HelpOnTypingManager.complete("end", scilabEditorPane, scilabDocument, n)) break;
                                scilabDocument.insertString(n + 1, "\nend", null);
                                int[] nArray = scilabEditorPane.getIndentManager().indentDoc(n + 1, n + 4);
                                scilabEditorPane.setCaretPosition(nArray[0]);
                                break;
                            }
                            case 2: {
                                String string = scilabDocument.getText(keywordEvent.getStart(), keywordEvent.getLength());
                                if (!"elseif".equals(string)) break;
                                scilabDocument.insertString(n + 1, " then", null);
                                scilabEditorPane.setCaretPosition(n + 1);
                                break;
                            }
                            case 14: {
                                if (!"f".equals(scilabDocument.getText(keywordEvent.getStart(), 1)) || !HelpOnTypingManager.complete("endfunction", scilabEditorPane, scilabDocument, n)) break;
                                scilabDocument.insertString(n + 1, "()\nendfunction", null);
                                scilabEditorPane.getIndentManager().indentDoc(n + 3, n + 14);
                                scilabEditorPane.setCaretPosition(n + 1);
                                break;
                            }
                        }
                    }
                    catch (NullPointerException | BadLocationException exception) {
                        System.err.println(exception);
                    }
                }
            } else if (this.openers) {
                int n3;
                if (SciNotesOptions.getSciNotesPreferences().completeAtEOL && n != (n3 = scilabDocument.getDefaultRootElement().getElement(scilabDocument.getDefaultRootElement().getElementIndex(n)).getEndOffset() - 1)) {
                    return;
                }
                try {
                    String string;
                    switch (c) {
                        case '(': {
                            if (HelpOnTypingManager.complete(')', scilabEditorPane, scilabDocument, n)) {
                                string = "()";
                                break;
                            }
                            return;
                        }
                        case '[': {
                            if (HelpOnTypingManager.complete(']', scilabEditorPane, scilabDocument, n)) {
                                string = "[]";
                                break;
                            }
                            return;
                        }
                        case '{': {
                            if (HelpOnTypingManager.complete('}', scilabEditorPane, scilabDocument, n)) {
                                string = "{}";
                                break;
                            }
                            return;
                        }
                        case '\"': {
                            string = "\"\"";
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    scilabDocument.insertString(n, string, null);
                    keyEvent.consume();
                    scilabEditorPane.setCaretPosition(n + 1);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
            }
        }
    }

    private static boolean complete(char c, ScilabEditorPane scilabEditorPane, ScilabDocument scilabDocument, int n) throws BadLocationException {
        MatchingBlockManager matchingBlockManager = scilabEditorPane.getMatchingBlockManager(true);
        MatchingBlockScanner matchingBlockScanner = matchingBlockManager.getScanner();
        MatchingBlockScanner.MatchingPositions matchingPositions = matchingBlockScanner.getNextBlock(n, true);
        if (matchingPositions != null) {
            char c2 = scilabDocument.getText(matchingPositions.secondB, 1).charAt(0);
            return c2 != c;
        }
        return true;
    }

    private static boolean complete(String string, ScilabEditorPane scilabEditorPane, ScilabDocument scilabDocument, int n) throws BadLocationException {
        MatchingBlockManager matchingBlockManager = scilabEditorPane.getMatchingBlockManager(true);
        MatchingBlockScanner matchingBlockScanner = matchingBlockManager.getScanner();
        MatchingBlockScanner.MatchingPositions matchingPositions = matchingBlockScanner.getNextBlock(n, true);
        if (matchingPositions != null) {
            String string2 = scilabDocument.getText(matchingPositions.secondB, matchingPositions.secondE - matchingPositions.secondB);
            return !string.equals(string2);
        }
        return true;
    }
}

