/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.scilab.modules.commons.gui.ScilabCaret;
import org.scilab.modules.scinotes.ScilabEditorPane;

public class SciNotesCaret
extends ScilabCaret {
    private static final long serialVersionUID = 2406847391415867003L;
    private ScilabEditorPane pane;
    private SciNotesNavigationFilter filter;
    private NavigationFilter saveFilter;
    private List<Object> selections = new ArrayList<Object>();
    private int[][] positions;
    private boolean protect;

    public SciNotesCaret(ScilabEditorPane scilabEditorPane) {
        super((JTextComponent)scilabEditorPane);
        this.pane = scilabEditorPane;
    }

    public void clean() {
        this.pane = null;
        this.filter = null;
        this.saveFilter = null;
        this.selections = null;
        this.positions = null;
    }

    public void protectHighlights(boolean bl) {
        this.protect = bl;
    }

    public void updateHighlights() {
        Highlighter highlighter = this.pane.getHighlighter();
        try {
            for (int i = 0; i < this.positions.length; ++i) {
                Object object = this.selections.get(i);
                if (object == null) continue;
                highlighter.changeHighlight(object, this.positions[i][0], this.positions[i][1]);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
    }

    public int[][] getSelectedPositions() {
        return this.positions;
    }

    public List<Object> getSelections() {
        return this.selections;
    }

    public boolean removePositions() {
        int[][] nArray = this.positions;
        if (nArray != null) {
            Document document = this.pane.getDocument();
            try {
                int n = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    int n2 = nArray[i][1] - nArray[i][0];
                    document.remove(nArray[i][0] - n, n2);
                    n += n2;
                }
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
        }
        return nArray != null;
    }

    public String getSelectedText() {
        if (this.positions != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < this.positions.length; ++i) {
                    stringBuffer.append(this.pane.getText(this.positions[i][0], this.positions[i][1] - this.positions[i][0]));
                    if (i >= this.positions.length - 1) continue;
                    stringBuffer.append("\n");
                }
                return stringBuffer.toString();
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
        }
        return null;
    }

    public boolean isEmptySelection() {
        return this.positions == null;
    }

    public boolean copyPositionsInClipboard() {
        if (this.positions != null) {
            StringSelection stringSelection = new StringSelection(this.getSelectedText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
        return this.positions != null;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.filter != null) {
            this.filter = null;
            this.pane.setNavigationFilter(this.saveFilter);
        }
        super.mouseReleased(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.isControlDown()) {
                if (this.filter == null) {
                    this.filter = new SciNotesNavigationFilter();
                    this.saveFilter = this.pane.getNavigationFilter();
                    this.pane.setNavigationFilter(this.filter);
                }
            } else if (this.filter != null) {
                this.filter = null;
                this.pane.setNavigationFilter(this.saveFilter);
            }
            super.mouseDragged(mouseEvent);
        }
    }

    public void removeHighlights() {
        if (!this.protect) {
            Highlighter highlighter = this.pane.getHighlighter();
            for (Object object : this.selections) {
                if (object == null) continue;
                highlighter.removeHighlight(object);
            }
            this.selections.clear();
            this.positions = null;
        }
    }

    public void setDot(int n, Position.Bias bias) {
        this.removeHighlights();
        super.setDot(n, bias);
    }

    class SciNotesNavigationFilter
    extends NavigationFilter {
        private int mark = -1;
        private Element root;

        public SciNotesNavigationFilter() {
            this.root = SciNotesCaret.this.pane.getDocument().getDefaultRootElement();
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass filterBypass, int n, Position.Bias bias) {
            Highlighter highlighter;
            int n2 = n;
            if (this.mark == -1) {
                this.mark = --n2;
            }
            SciNotesCaret.this.pane.setCaretPosition(n2);
            if (SciNotesCaret.this.isSelectionVisible() && (highlighter = SciNotesCaret.this.pane.getHighlighter()) != null) {
                int n3 = Math.min(n2, this.mark);
                int n4 = Math.max(n2, this.mark);
                if (!SciNotesCaret.this.selections.isEmpty()) {
                    SciNotesCaret.this.removeHighlights();
                }
                int n5 = this.root.getElementIndex(n3);
                int n6 = this.root.getElementIndex(n4);
                int n7 = n3 - this.root.getElement(n5).getStartOffset();
                int n8 = n4 - this.root.getElement(n6).getStartOffset();
                int n9 = Math.min(n7, n8);
                int n10 = Math.max(n7, n8);
                Highlighter.HighlightPainter highlightPainter = SciNotesCaret.this.getSelectionPainter();
                int n11 = n10 - n9;
                if (n3 != n4) {
                    SciNotesCaret.this.positions = new int[n6 - n5 + 1][2];
                    try {
                        for (int i = n5; i <= n6; ++i) {
                            Element element = this.root.getElement(i);
                            int n12 = element.getEndOffset();
                            int n13 = i - n5;
                            n4 = Math.min(n3 + n11, n12);
                            SciNotesCaret.this.positions[n13][0] = Math.min(element.getStartOffset() + n9, n12);
                            SciNotesCaret.this.positions[n13][1] = Math.min(SciNotesCaret.this.positions[n13][0] + n11, n12);
                            if (SciNotesCaret.this.positions[n13][0] < SciNotesCaret.this.positions[n13][1]) {
                                SciNotesCaret.this.selections.add(highlighter.addHighlight(SciNotesCaret.this.positions[n13][0], SciNotesCaret.this.positions[n13][1], highlightPainter));
                                continue;
                            }
                            SciNotesCaret.this.selections.add(null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        System.err.println(badLocationException);
                    }
                }
            }
        }
    }
}

