/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import javax.swing.text.View;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabPlainView;
import org.scilab.modules.scinotes.ScilabView;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class SciNotesLineNumberPanel
extends JPanel
implements CaretListener,
DocumentListener,
MouseMotionListener {
    private static final long serialVersionUID = -5302189665896954438L;
    private static final int PANELGAPSIZE = 10;
    private static final Border OUTER = new MatteBorder(0, 0, 0, 2, Color.GRAY);
    private static final int HEIGHT = 2146483647;
    private static Map desktopFontHints;
    private ScilabEditorPane textPane;
    private Color currentLineForeground;
    private Color foreground = Color.BLACK;
    private Color anchorColor = new Color(250, 251, 164);
    private Color alternColor1 = new Color(246, 191, 246);
    private Color alternColor2 = new Color(246, 101, 246);
    private int numbers = 1;
    private int lastLine;
    private int state;
    private ScilabDocument doc;
    private FontMetrics metrics;
    private int ascent;
    private int availableWidth;
    private int[] lineNumber;
    private byte[] lineLevel;
    private boolean whereami;
    private boolean display;

    public SciNotesLineNumberPanel(ScilabEditorPane scilabEditorPane) {
        this.textPane = scilabEditorPane;
        this.doc = (ScilabDocument)scilabEditorPane.getDocument();
        this.setOpaque(true);
        this.updateFont(scilabEditorPane.getFont());
        this.setBorderGap(10);
        this.setCurrentLineForeground(Color.RED);
        this.setAlternColors(ConfigSciNotesManager.getAlternColors());
        scilabEditorPane.addCaretListener(this);
        this.addMouseMotionListener(this);
    }

    public void setWhereamiLineNumbering(int n) {
        if (n != this.state) {
            if (n != 0) {
                if (!this.display) {
                    this.textPane.getScrollPane().setRowHeaderView(this);
                }
                this.whereami = n == 2;
                this.display = true;
            } else {
                this.textPane.getScrollPane().setRowHeaderView(null);
                this.display = false;
            }
            this.updateLineNumber();
            this.state = n;
        }
    }

    public static int getState(boolean bl, boolean bl2) {
        if (!bl) {
            return 0;
        }
        if (!bl2) {
            return 1;
        }
        return 2;
    }

    public static boolean[] getState(int n) {
        switch (n) {
            case 0: {
                return new boolean[]{false, false};
            }
            case 1: {
                return new boolean[]{true, false};
            }
            case 2: {
                return new boolean[]{true, true};
            }
        }
        return null;
    }

    public void setWhereamiLineNumbering(boolean bl, boolean bl2) {
        this.setWhereamiLineNumbering(SciNotesLineNumberPanel.getState(bl, bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getLineNumber() {
        int[] nArray = null;
        if (this.display) {
            if (this.whereami) {
                this.updateLineNumber();
                ScilabDocument scilabDocument = this.doc;
                synchronized (scilabDocument) {
                    nArray = this.lineNumber;
                }
            } else {
                nArray = new int[this.doc.getDefaultRootElement().getElementCount()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i + 1;
                }
            }
        }
        return nArray;
    }

    public int getState() {
        return this.state;
    }

    public boolean getWhereamiLineNumbering() {
        return this.whereami;
    }

    public void setAlternColors(Color[] colorArray) {
        this.alternColor1 = colorArray[0] == null ? this.getBackground() : colorArray[0];
        this.alternColor2 = colorArray[1] == null ? this.getBackground() : colorArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateFont(Font font) {
        this.setFont(font);
        this.metrics = this.textPane.getFontMetrics(font);
        ScilabDocument scilabDocument = this.doc;
        synchronized (scilabDocument) {
            this.ascent = this.metrics.getAscent();
        }
        this.updateWidth(false);
    }

    public Color getCurrentLineForeground() {
        if (this.currentLineForeground == null) {
            return this.getForeground();
        }
        return this.currentLineForeground;
    }

    public void setCurrentLineForeground(Color color) {
        this.currentLineForeground = color;
    }

    public void updateWidth(boolean bl) {
        int n;
        if (bl) {
            ++this.numbers;
        }
        this.availableWidth = n = this.metrics.charWidth('0') * this.numbers;
        Dimension dimension = this.getPreferredSize();
        dimension.setSize(this.availableWidth, 2146483647);
        this.availableWidth = n;
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (desktopFontHints == null) {
            desktopFontHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        } else {
            ((Graphics2D)graphics).addRenderingHints(desktopFontHints);
        }
        ScilabDocument scilabDocument = this.doc;
        synchronized (scilabDocument) {
            Element element = this.doc.getDefaultRootElement();
            View view = this.doc.getView();
            Rectangle rectangle = graphics.getClipBounds();
            Point point = new Point(0, rectangle.y);
            int n = this.textPane.viewToModel(point);
            point.y += rectangle.height;
            int n2 = this.textPane.viewToModel(point);
            int n3 = element.getElementIndex(n2);
            for (int i = element.getElementIndex(n); i <= n3; ++i) {
                String string;
                boolean bl = false;
                if (this.whereami && this.lineNumber != null) {
                    if (this.lineNumber[i] != -1) {
                        string = Integer.toString(this.lineNumber[i]);
                        if (this.lineLevel[i] % 3 == 1) {
                            graphics.setColor(this.alternColor1);
                            bl = true;
                        } else if (this.lineLevel[i] % 3 == 2) {
                            graphics.setColor(this.alternColor2);
                            bl = true;
                        }
                    } else {
                        string = "";
                    }
                } else {
                    string = Integer.toString(i + 1);
                }
                Element element2 = element.getElement(i);
                if (((ScilabDocument.ScilabLeafElement)element2).isAnchor()) {
                    graphics.setColor(this.anchorColor);
                    bl = true;
                }
                if (bl) {
                    if (view instanceof ScilabView) {
                        graphics.fillRect(0, ((ScilabView)view).getLineAllocation(i), this.availableWidth, this.metrics.getHeight());
                    } else {
                        graphics.fillRect(0, ((ScilabPlainView)view).getLineAllocation(i), this.availableWidth, this.metrics.getHeight());
                    }
                }
                if (i != this.lastLine) {
                    graphics.setColor(this.foreground);
                } else {
                    graphics.setColor(this.currentLineForeground);
                }
                int n4 = (this.availableWidth - this.metrics.stringWidth(string)) / 2;
                if (n4 <= 0) {
                    this.updateWidth(true);
                    n4 = (this.availableWidth - this.metrics.stringWidth(string)) / 2;
                }
                if (view instanceof ScilabView) {
                    graphics.drawString(string, n4, ((ScilabView)view).getLineAllocation(i) + this.ascent);
                    continue;
                }
                graphics.drawString(string, n4, ((ScilabPlainView)view).getLineAllocation(i) + this.ascent);
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        Element element = this.doc.getDefaultRootElement();
        int n = element.getElementIndex(this.textPane.getCaretPosition());
        if (this.lastLine != n) {
            this.lastLine = n;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLineNumber() {
        ScilabDocument scilabDocument = this.doc;
        synchronized (scilabDocument) {
            Stack<Integer> stack = new Stack<Integer>();
            Element element = this.doc.getDefaultRootElement();
            int n = element.getElementCount();
            this.lineNumber = new int[n + 1];
            this.lineLevel = new byte[n + 1];
            this.lineNumber[0] = 1;
            int n2 = 1;
            boolean bl = false;
            block8: for (int i = 0; i < n; ++i) {
                ScilabDocument.ScilabLeafElement scilabLeafElement = (ScilabDocument.ScilabLeafElement)element.getElement(i);
                int n3 = scilabLeafElement.getType();
                switch (n3) {
                    case 0: {
                        if (bl) {
                            this.lineNumber[i] = -1;
                            if (!scilabLeafElement.isBroken()) {
                                bl = false;
                            }
                        } else {
                            this.lineNumber[i] = n2++;
                        }
                        this.lineLevel[i] = (byte)stack.size();
                        continue block8;
                    }
                    case 1: {
                        stack.push(new Integer(n2));
                        this.lineLevel[i] = (byte)stack.size();
                        n2 = 2;
                        this.lineNumber[i] = 1;
                        if (!scilabLeafElement.isBroken()) continue block8;
                        bl = true;
                        continue block8;
                    }
                    case 2: {
                        this.lineNumber[i] = n2++;
                        this.lineLevel[i] = (byte)stack.size();
                        if (stack.empty()) continue block8;
                        n2 = (Integer)stack.pop() + this.lineNumber[i];
                        continue block8;
                    }
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.textPane.viewToModel(mouseEvent.getPoint());
        Element element = this.doc.getDefaultRootElement();
        ScilabDocument.ScilabLeafElement scilabLeafElement = (ScilabDocument.ScilabLeafElement)element.getElement(element.getElementIndex(n));
        if (scilabLeafElement.isAnchor()) {
            this.setToolTipText(SciNotesMessages.ANCHOR + scilabLeafElement.toString());
        } else {
            this.setToolTipText(null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleEvent(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleEvent(documentEvent);
    }

    private void handleEvent(DocumentEvent documentEvent) {
        if (this.whereami) {
            Element element = this.doc.getDefaultRootElement();
            DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
            if (elementChange == null) {
                ScilabDocument.ScilabLeafElement scilabLeafElement = (ScilabDocument.ScilabLeafElement)element.getElement(element.getElementIndex(documentEvent.getOffset()));
                if (scilabLeafElement.needLineNumberRepaint()) {
                    this.updateLineNumber();
                    this.repaint();
                }
            } else {
                this.updateLineNumber();
            }
        }
    }

    private void setBorderGap(int n) {
        EmptyBorder emptyBorder = new EmptyBorder(0, n, 0, n);
        this.setBorder(new CompoundBorder(OUTER, emptyBorder));
    }
}

