/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.scilab.modules.commons.xml.ScilabXPathFactory;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.gui.utils.ScilabFontUtils;
import org.scilab.modules.scinotes.SciNotesConfiguration;
import org.scilab.modules.scinotes.ScilabLexerConstants;
import org.scilab.modules.scinotes.ScilabPlainView;
import org.scilab.modules.scinotes.ScilabView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ScilabContext
implements ViewFactory {
    public static final String COLORSPATH = "//colors/body/syntax-highlighting-colors/item";
    public static final String SYSTEMFONTPATH = "//fonts/body/fonts";
    public static final String FONTPATH = "//fonts/body/fonts/item";
    public static final String XCONFFONTPATH = "//fonts/body/fonts/item[@xconf-uid=\"scinotes-font\"]";
    public Color[] tokenColors;
    public Font[] tokenFonts;
    public int[] tokenAttrib;
    private Font baseFont;
    private boolean isDesktop;
    private boolean compatible;
    private FontInfo[] scinotesInfos;
    private FontInfo[] desktopInfos;
    private View view;
    private boolean plain;
    private List<Integer> typeToDefault = new ArrayList<Integer>();

    public ScilabContext() {
        this.genAll();
    }

    public ScilabContext(boolean bl) {
        this();
        this.plain = bl;
    }

    public static void saveFont(Font font) {
        NodeList nodeList;
        XPathFactory xPathFactory = ScilabXPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        Document document = XConfiguration.getXConfigurationDocument();
        try {
            nodeList = (NodeList)xPath.compile("//fonts/body/fonts/item[@xconf-uid='scinotes-font']").evaluate(document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            System.err.println(xPathExpressionException);
            return;
        }
        Element element = (Element)nodeList.item(0);
        element.setAttribute("desktop", "false");
        element.setAttribute("font-name", font.getName());
        element.setAttribute("font-size", Integer.toString(font.getSize()));
        XConfiguration.save();
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    public void changeBaseFontSize(int n) {
        float f = this.baseFont.getSize2D() + (float)n;
        this.baseFont = this.baseFont.deriveFont(f);
        for (int i = 0; i < this.tokenFonts.length; ++i) {
            this.tokenFonts[i] = this.tokenFonts[i].deriveFont(f);
        }
    }

    public void configurationChanged(SciNotesConfiguration.Conf conf) {
        boolean bl = false;
        FontInfo[] fontInfoArray = null;
        FontInfo[] fontInfoArray2 = null;
        Document document = null;
        if (conf.colors) {
            this.genAll();
            bl = true;
        }
        if (!bl && conf.font && !(fontInfoArray = (FontInfo[])XConfiguration.get(FontInfo.class, (Document)(document = XConfiguration.getXConfigurationDocument()), (String)"//fonts/body/fonts/item[@name='Scinotes']"))[0].equals(this.scinotesInfos)) {
            this.genAll();
            bl = true;
        }
        if (!bl && conf.systemfont) {
            document = XConfiguration.getXConfigurationDocument();
            fontInfoArray2 = (FontInfo[])XConfiguration.get(FontInfo.class, (Document)document, (String)SYSTEMFONTPATH);
            this.genAll();
        }
    }

    public void genAll() {
        Font font;
        this.tokenAttrib = new int[36];
        this.tokenColors = new Color[36];
        this.tokenFonts = new Font[36];
        Document document = XConfiguration.getXConfigurationDocument();
        this.desktopInfos = (FontInfo[])XConfiguration.get(FontInfo.class, (Document)document, (String)SYSTEMFONTPATH);
        this.scinotesInfos = (FontInfo[])XConfiguration.get(FontInfo.class, (Document)document, (String)"//fonts/body/fonts/item[@name='Scinotes']");
        if (this.scinotesInfos[0].isDesktop()) {
            font = this.desktopInfos[0].getFont();
            this.isDesktop = true;
        } else {
            font = this.scinotesInfos[0].getFont();
            this.isDesktop = false;
        }
        if (font != this.baseFont) {
            this.compatible = ScilabFontUtils.isAllStylesSameWidths((Font)font);
            this.baseFont = font;
        }
        FontDecoration[] fontDecorationArray = (FontDecoration[])XConfiguration.get(FontDecoration.class, (Document)document, (String)COLORSPATH);
        document = null;
        for (FontDecoration fontDecoration : fontDecorationArray) {
            this.tokenAttrib[fontDecoration.getType()] = fontDecoration.getValue();
            this.tokenColors[fontDecoration.getType()] = fontDecoration.getColor();
            this.tokenFonts[fontDecoration.getType()] = this.compatible ? this.baseFont.deriveFont(fontDecoration.getFontFace()) : this.baseFont;
        }
        this.typeToDefault.clear();
        for (int i = 0; i < this.tokenColors.length; ++i) {
            if (this.tokenColors[i] != null) continue;
            this.tokenColors[i] = this.tokenColors[0];
            this.typeToDefault.add(i);
        }
        this.tokenColors[19] = this.tokenColors[13];
        this.tokenColors[3] = this.tokenColors[2];
        this.tokenColors[32] = this.tokenColors[2];
        for (Integer n : this.typeToDefault) {
            this.tokenAttrib[n.intValue()] = this.tokenAttrib[0];
        }
        this.tokenAttrib[3] = this.tokenAttrib[2];
        this.tokenAttrib[32] = this.tokenAttrib[2];
        for (int i = 0; i < this.tokenFonts.length; ++i) {
            if (this.tokenFonts[i] != null) continue;
            this.tokenFonts[i] = this.tokenFonts[0];
        }
        Font font2 = this.tokenFonts[13];
        int n = font2.getStyle();
        if (this.compatible) {
            this.tokenFonts[19] = font2.isBold() ? font2.deriveFont(n ^ 1) : font2.deriveFont(n | 1);
        }
        this.tokenFonts[3] = this.tokenFonts[2];
        this.tokenFonts[32] = this.tokenFonts[2];
    }

    public void genAttribute(String string, int n) {
        this.tokenAttrib[ScilabLexerConstants.TOKENS.get((Object)string).intValue()] = n;
        this.tokenAttrib[3] = this.tokenAttrib[2];
        this.tokenAttrib[32] = this.tokenAttrib[2];
        if (ScilabLexerConstants.TOKENS.get(string) == 0) {
            for (Integer n2 : this.typeToDefault) {
                this.tokenAttrib[n2.intValue()] = this.tokenAttrib[0];
            }
        }
    }

    public void genColors(String string, Color color) {
        this.tokenColors[ScilabLexerConstants.TOKENS.get((Object)string).intValue()] = color;
        this.tokenColors[19] = this.tokenColors[13];
        this.tokenColors[3] = this.tokenColors[2];
        this.tokenColors[32] = this.tokenColors[2];
        if (ScilabLexerConstants.TOKENS.get(string) == 0) {
            for (Integer n : this.typeToDefault) {
                this.tokenColors[n.intValue()] = this.tokenColors[0];
            }
        }
    }

    public void genFont(String string, int n) {
        Font font = this.tokenFonts[ScilabLexerConstants.TOKENS.get(string)];
        int n2 = font.getStyle();
        switch (n) {
            case -2: {
                font = font.deriveFont(n2 & 0xFFFFFFFD);
                break;
            }
            case -1: {
                font = font.deriveFont(n2 & 0xFFFFFFFE);
                break;
            }
            case 1: {
                font = font.deriveFont(n2 | 1);
                break;
            }
            case 2: {
                font = font.deriveFont(n2 | 2);
                break;
            }
        }
        this.tokenFonts[ScilabLexerConstants.TOKENS.get((Object)string).intValue()] = font;
        this.tokenFonts[3] = this.tokenFonts[2];
        this.tokenFonts[32] = this.tokenFonts[2];
        if (ScilabLexerConstants.TOKENS.get(string) == 0) {
            for (Integer n3 : this.typeToDefault) {
                this.tokenFonts[n3.intValue()] = this.tokenFonts[0];
            }
        }
    }

    public View getCurrentView() {
        return this.view;
    }

    @Override
    public View create(javax.swing.text.Element element) {
        if (this.plain) {
            this.view = new ScilabPlainView(element, this);
            ((ScilabPlainView)this.view).setDefaultTabRepresentation();
        } else {
            this.view = new ScilabView(element, this);
            ((ScilabView)this.view).setDefaultTabRepresentation();
        }
        return this.view;
    }

    @XConfiguration.XConfAttribute
    private static class FontInfo {
        String fontname;
        int fontsize;
        boolean desktop;

        @XConfiguration.XConfAttribute(attributes={"font-name", "font-size", "desktop"})
        public void set(String string, int n, boolean bl) {
            this.fontname = string;
            this.fontsize = n;
            this.desktop = bl;
        }

        public boolean isDesktop() {
            return this.desktop;
        }

        public Font getFont() {
            return new Font(this.fontname, 0, this.fontsize);
        }

        public boolean equals(Object object) {
            if (object instanceof FontInfo) {
                FontInfo fontInfo = (FontInfo)object;
                return this.fontname.equals(fontInfo.fontname) && this.fontsize == fontInfo.fontsize && this.desktop == fontInfo.desktop;
            }
            return false;
        }
    }

    @XConfiguration.XConfAttribute
    private static class FontDecoration {
        private boolean underline;
        private boolean strikeThrough;
        private boolean bold;
        private boolean italic;
        private Color color;
        private int type;

        @XConfiguration.XConfAttribute(attributes={"underline", "strike-through", "name", "italic", "color", "bold"})
        public void set(boolean bl, boolean bl2, String string, boolean bl3, Color color, boolean bl4) {
            this.underline = bl;
            this.strikeThrough = bl2;
            this.type = ScilabLexerConstants.TOKENS.get(string);
            this.color = color;
            this.italic = bl3;
            this.bold = bl4;
        }

        public int getFontFace() {
            int n = 0;
            if (this.bold) {
                n |= 1;
            }
            if (this.italic) {
                n |= 2;
            }
            return n;
        }

        public Color getColor() {
            return this.color;
        }

        public int getValue() {
            int n = 0;
            if (this.underline) {
                ++n;
            }
            if (this.strikeThrough) {
                n += 2;
            }
            return n;
        }

        public int getType() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (object instanceof FontDecoration) {
                FontDecoration fontDecoration = (FontDecoration)object;
                return this.underline == fontDecoration.underline && this.strikeThrough == fontDecoration.strikeThrough && this.bold == fontDecoration.bold && this.italic == fontDecoration.italic && this.color.equals(fontDecoration.color) && this.type == fontDecoration.type;
            }
            return false;
        }
    }
}

