/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.actions.DefaultCheckAction;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class EncodingAction
extends DefaultCheckAction {
    private static final long serialVersionUID = -5421313717126859924L;
    private static final String CHECKICON = ScilabConstants.SCI.getPath() + "/modules/gui/images/icons/check-icon.png";
    private static Map<String, String> encodings = new HashMap<String, String>();
    private static Map<String, List<String>> language = new HashMap<String, List<String>>();
    private static JRadioButtonMenuItem[] radioTypes;
    private static Menu[] menuLang;
    private String encoding;

    public EncodingAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
        this.encoding = string;
    }

    public static void close() {
        radioTypes = null;
        menuLang = null;
    }

    public JRadioButtonMenuItem createRadioButtonMenuItem(SciNotes sciNotes) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.encoding);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EncodingAction.this.doAction();
            }
        });
        return jRadioButtonMenuItem;
    }

    public static Menu createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        Menu menu = ScilabMenu.createMenu();
        menu.setText(string);
        Map<String, List<String>> map = EncodingAction.getEncodings();
        Iterator<String> iterator = map.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            n += map.get(iterator.next()).size();
        }
        if (radioTypes == null) {
            radioTypes = new JRadioButtonMenuItem[n];
            menuLang = new Menu[map.size()];
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        iterator = map.keySet().iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            List<String> list = map.get(string2);
            EncodingAction.menuLang[n3] = ScilabMenu.createMenu();
            menuLang[n3].setText(string2);
            menu.add(menuLang[n3]);
            for (int i = 0; i < list.size(); ++i) {
                EncodingAction.radioTypes[n2 + i] = new EncodingAction(list.get(i), sciNotes).createRadioButtonMenuItem(sciNotes);
                buttonGroup.add(radioTypes[n2 + i]);
                ((JMenu)menuLang[n3].getAsSimpleMenu()).add(radioTypes[n2 + i]);
                if (!list.get(i).equalsIgnoreCase(Charset.defaultCharset().toString())) continue;
                radioTypes[n2 + i].setSelected(true);
            }
            n2 += list.size();
            ++n3;
        }
        return menu;
    }

    public static Set<String> getSupportedEncodings() {
        return encodings.keySet();
    }

    public static void updateEncodingMenu(ScilabDocument scilabDocument) {
        if (radioTypes != null) {
            for (int i = 0; i < radioTypes.length; ++i) {
                if (!scilabDocument.getEncoding().equalsIgnoreCase(radioTypes[i].getText())) continue;
                radioTypes[i].setSelected(true);
                EncodingAction.updateIcon(radioTypes[i].getText());
                return;
            }
        }
    }

    public static Map<String, List<String>> getEncodings() {
        if (!language.isEmpty()) {
            return language;
        }
        Set<String> set = encodings.keySet();
        for (String string : set) {
            try {
                Charset.forName(string);
                String string2 = encodings.get(string);
                if (!language.containsKey(string2)) {
                    language.put(string2, new ArrayList());
                }
                language.get(string2).add(string);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                encodings.remove(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                encodings.remove(string);
            }
        }
        language = new TreeMap<String, List<String>>(language);
        return language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() {
        boolean bl = false;
        ScilabDocument scilabDocument = (ScilabDocument)this.getEditor().getTextPane().getDocument();
        if (scilabDocument.isContentModified() && this.getEditor().getTextPane().getName() != null) {
            switch (ScilabModalDialog.show((SimpleTab)this.getEditor(), (String)SciNotesMessages.MODIFICATIONS_WILL_BE_LOST, (String)SciNotesMessages.CONTINUE, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO)) {
                case YES_OPTION: {
                    break;
                }
                case NO_OPTION: {
                    EncodingAction.updateEncodingMenu(scilabDocument);
                    return;
                }
            }
        }
        scilabDocument.setUpdater(false);
        boolean bl2 = scilabDocument.getAutoIndent();
        scilabDocument.setAutoIndent(false);
        scilabDocument.setEncoding(this.encoding);
        EncodingAction.updateIcon(this.encoding);
        EditorKit editorKit = this.getEditor().getEditorKit();
        String string = this.getEditor().getTextPane().getName();
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            File file;
            if (string != null && (file = new File(this.getEditor().getTextPane().getName())).exists() && scilabDocument.getLength() > 0) {
                scilabDocument.getUndoManager().discardAllEdits();
                scilabDocument.disableUndoManager();
                scilabDocument.remove(0, scilabDocument.getLength());
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.encoding);
                bufferedReader = new BufferedReader(inputStreamReader);
                editorKit.read(bufferedReader, (Document)scilabDocument, 0);
                scilabDocument.enableUndoManager();
            }
            bl = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl = false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        catch (BadLocationException badLocationException) {
            bl = false;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        scilabDocument.setAutoIndent(bl2);
        scilabDocument.setUpdater(true);
        scilabDocument.setContentModified(false);
        scilabDocument.getUndoManager().discardAllEdits();
        if (!bl) {
            ScilabModalDialog.show((SimpleTab)this.getEditor(), (String)SciNotesMessages.COULD_NOT_CONVERT_FILE, (String)SciNotesMessages.SCINOTES_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
        }
    }

    private static void updateIcon(String string) {
        String string2 = encodings.get(string);
        for (int i = 0; i < menuLang.length; ++i) {
            if (((JMenu)menuLang[i].getAsSimpleMenu()).getIcon() != null) {
                ((JMenu)menuLang[i].getAsSimpleMenu()).setIcon(null);
            }
            if (!menuLang[i].getText().equals(string2)) continue;
            ((JMenu)menuLang[i].getAsSimpleMenu()).setIcon(new ImageIcon(CHECKICON));
        }
    }

    static {
        encodings.put("x-MacArabic", "Arabic");
        encodings.put("x-MacCentralEurope", "Central European");
        encodings.put("x-MacCroatian", "Central European");
        encodings.put("x-MacCyrillic", "Cyrillic");
        encodings.put("x-MacGreek", "Greek");
        encodings.put("x-MacHebrew", "Hebrew");
        encodings.put("x-MacIceland", "Western European");
        encodings.put("x-MacRoman", "Western European");
        encodings.put("x-MacRomania", "Central European");
        encodings.put("x-MacThai", "Thai");
        encodings.put("x-MacTurkish", "Turkish");
        encodings.put("x-MacUkraine", "Cyrillic");
        encodings.put("ASMO-708", "Arabic");
        encodings.put("cp866", "Cyrillic");
        encodings.put("windows-874", "Thai");
        encodings.put("shift_jis", "Japanese");
        encodings.put("gb2312", "Chinese Simplified");
        encodings.put("ks_c_5601-1987", "Korean");
        encodings.put("big5", "Chinese Traditional");
        encodings.put("utf-16", "Unicode");
        encodings.put("windows-1250", "Central European");
        encodings.put("windows-1251", "Cyrillic");
        encodings.put("windows-1252", "Western European");
        encodings.put("windows-1253", "Greek");
        encodings.put("windows-1254", "Turkish");
        encodings.put("windows-1255", "Hebrew");
        encodings.put("windows-1256", "Arabic");
        encodings.put("windows-1257", "Baltic");
        encodings.put("windows-1258", "Vietnamese");
        encodings.put("Johab", "Korean");
        encodings.put("utf-32", "Unicode");
        encodings.put("utf-32BE", "Unicode");
        encodings.put("us-ascii", "US-ASCII");
        encodings.put("koi8-r", "Cyrillic");
        encodings.put("EUC-JP", "Japanese");
        encodings.put("koi8-u", "Cyrillic");
        encodings.put("iso-8859-1", "Western European");
        encodings.put("iso-8859-2", "Central European");
        encodings.put("iso-8859-3", "Latin");
        encodings.put("iso-8859-4", "Baltic");
        encodings.put("iso-8859-5", "Cyrillic");
        encodings.put("iso-8859-6", "Arabic");
        encodings.put("iso-8859-7", "Greek");
        encodings.put("iso-8859-8", "Hebrew");
        encodings.put("iso-8859-9", "Turkish");
        encodings.put("iso-8859-13", "Estonian");
        encodings.put("iso-8859-15", "Latin");
        encodings.put("iso-2022-jp", "Japanese");
        encodings.put("csISO2022JP", "Japanese");
        encodings.put("iso-2022-kr", "Korean");
        encodings.put("euc-jp", "Japanese");
        encodings.put("EUC-CN", "Chinese Simplified");
        encodings.put("euc-kr", "Korean");
        encodings.put("GB18030", "Chinese Simplified");
        encodings.put("utf-8", "Unicode");
    }
}

