/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.Color;
import java.awt.print.Paper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.utils.SciNotesMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ConfigSciNotesManager {
    public static final String RECENTBASEDIR = "recentBaseDir";
    public static final String BASEDIR = "baseDir";
    public static final String RECENTFILEPATTERN = "recentFilePattern";
    public static final String FILEPATTERN = "filePattern";
    public static final String RECENTWORDPATTERN = "recentWordPattern";
    public static final String WORDPATTERN = "wordPattern";
    private static final int BUFSIZE = 1024;
    private static final int MARGIN = 20;
    private static final String ERROR_READ = "Could not load file: ";
    private static final String ERROR_WRITE = "Could not save file: ";
    private static final String VALUE = "value";
    private static final String VERSION = "version";
    private static final String STYLE = "style";
    private static final String DEFAULT = "default";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String EDITOR = "SciNotes";
    private static final String FOREGROUNDCOLOR = "ForegroundColor";
    private static final String BACKGROUNDCOLOR = "BackgroundColor";
    private static final String ALTERNCOLORS = "AlternColors";
    private static final String COLOR1 = "color1";
    private static final String COLOR2 = "color2";
    private static final String LINECOLOR = "linecolor";
    private static final String CONTOURCOLOR = "contourcolor";
    private static final String COLORPREFIX = "#";
    private static final String NAME = "name";
    private static final String NULL = "null";
    private static final String PROFILE = "Profile";
    private static final String RECENT_SEARCH = "recentSearch";
    private static final String SEARCH = "search";
    private static final String RECENT_REPLACE = "recentReplace";
    private static final String REPLACE = "replace";
    private static final String RECURSIVE = "recursiveSearch";
    private static final String LINEBYLINE = "readLineByLine";
    private static final String FILECASE = "fileCase";
    private static final String SEARCHINFILES = "searchInFiles";
    private static final String EXPRESSION = "exp";
    private static final String REGULAR_EXPRESION = "regularExp";
    private static final String CIRCULAR = "circularSearch";
    private static final String WORD_WARP = "wordWarp";
    private static final String WHOLE_WORD = "wholeWord";
    private static final String CASE_SENSITIVE = "caseSensitive";
    private static final String STATE_FLAG = "state";
    private static final String SETTING = "Setting";
    private static final String SCINOTES = "scinotes";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String DOCUMENT = "document";
    private static final String PATH = "path";
    private static final String RECENT_FILES = "recentFiles";
    private static final String OPEN_FILES = "openFiles";
    private static final String RESTOREFILES = "RestoreFiles";
    private static final String EDITORINST = "editorInstance";
    private static final String EDITORUUID = "EditorUUID";
    private static final String PANEINST = "paneInstance";
    private static final String PANEINST_EX = "paneInstanceExtra";
    private static final String FAVORITE_DIRS = "favoriteDirectories";
    private static final String DIRECTORY = "Directory";
    private static final String PAPER = "PaperFormat";
    private static final String MARGINLEFT = "MarginLeft";
    private static final String MARGINRIGHT = "MarginRight";
    private static final String MARGINTOP = "MarginTop";
    private static final String MARGINBOTTOM = "MarginBottom";
    private static final String CODENAVIGATOR = "CodeNavigator";
    private static final String SCI = "SCI";
    private static final String SCINOTES_CONFIG_FILE = System.getenv("SCI") + "/modules/scinotes/etc/scinotesConfiguration.xml";
    private static final int MAXRECENT = 20;
    private static Document document;
    private static boolean updated;
    private static boolean mustSave;
    private static String USER_SCINOTES_CONFIG_FILE;

    private ConfigSciNotesManager() {
        throw new UnsupportedOperationException();
    }

    public static void createUserCopy() {
        if (ConfigSciNotesManager.checkVersion() && mustSave) {
            ScilabCommonsUtils.copyFile((File)new File(SCINOTES_CONFIG_FILE), (File)new File(USER_SCINOTES_CONFIG_FILE));
            document = null;
            updated = true;
        }
    }

    public static String getUserConfigFile() {
        return USER_SCINOTES_CONFIG_FILE;
    }

    public static boolean checkVersion() {
        if (updated) {
            return false;
        }
        File file = new File(USER_SCINOTES_CONFIG_FILE);
        if (file.exists()) {
            document = null;
            ConfigSciNotesManager.readDocument(SCINOTES_CONFIG_FILE);
            Node node = ConfigSciNotesManager.getNodeChild(null, SETTING);
            String string = ((Element)node).getAttribute(VERSION);
            if (string != null && string.length() != 0) {
                float f = Float.parseFloat(string);
                document = null;
                ConfigSciNotesManager.readDocument();
                node = ConfigSciNotesManager.getNodeChild(null, SETTING);
                string = ((Element)node).getAttribute(VERSION);
                document = null;
                if (string != null && string.length() != 0) {
                    float f2 = Float.parseFloat(string);
                    return f != f2;
                }
            }
        }
        return true;
    }

    public static Paper getPaperFormat() {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(PROFILE);
        Element element2 = (Element)nodeList.item(0);
        NodeList nodeList2 = element2.getElementsByTagName(PAPER);
        Element element3 = (Element)nodeList2.item(0);
        if (element3 == null) {
            return new Paper();
        }
        Paper paper = new Paper();
        double d = Double.parseDouble(element3.getAttribute(WIDTH));
        double d2 = Double.parseDouble(element3.getAttribute(HEIGHT));
        double d3 = Double.parseDouble(element3.getAttribute(MARGINLEFT));
        double d4 = Double.parseDouble(element3.getAttribute(MARGINRIGHT));
        double d5 = Double.parseDouble(element3.getAttribute(MARGINTOP));
        double d6 = Double.parseDouble(element3.getAttribute(MARGINBOTTOM));
        paper.setSize(d, d2);
        paper.setImageableArea(d3, d5, d - (d3 + d4), d2 - (d5 + d6));
        return paper;
    }

    public static void savePaperFormat(Paper paper) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(PROFILE);
        Element element2 = (Element)nodeList.item(0);
        NodeList nodeList2 = element2.getElementsByTagName(PAPER);
        Element element3 = (Element)nodeList2.item(0);
        if (element3 == null) {
            element3 = document.createElement(PAPER);
            element2.appendChild(element3);
        }
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        double d3 = paper.getImageableX();
        double d4 = d - (d3 + paper.getImageableWidth());
        double d5 = paper.getImageableY();
        double d6 = d2 - (d5 + paper.getImageableHeight());
        element3.setAttribute(WIDTH, Double.toString(d));
        element3.setAttribute(HEIGHT, Double.toString(d2));
        element3.setAttribute(MARGINLEFT, Double.toString(d3));
        element3.setAttribute(MARGINRIGHT, Double.toString(d4));
        element3.setAttribute(MARGINTOP, Double.toString(d5));
        element3.setAttribute(MARGINBOTTOM, Double.toString(d6));
        ConfigSciNotesManager.writeDocument();
    }

    public static Color[] getAlternColors() {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(PROFILE);
        Element element2 = (Element)nodeList.item(0);
        NodeList nodeList2 = element2.getElementsByTagName(ALTERNCOLORS);
        Element element3 = (Element)nodeList2.item(0);
        Color[] colorArray = new Color[2];
        Color color = NULL.equals(element3.getAttribute(COLOR1)) ? null : Color.decode(element3.getAttribute(COLOR1));
        colorArray[0] = color;
        color = NULL.equals(element3.getAttribute(COLOR2)) ? null : Color.decode(element3.getAttribute(COLOR2));
        colorArray[1] = color;
        return colorArray;
    }

    public static List<File> getAllRecentOpenedFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(RECENT_FILES).item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName(DOCUMENT);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                File file = new File(element2.getAttribute(PATH));
                if (file.exists()) {
                    arrayList.add(file);
                    continue;
                }
                element.removeChild(element2);
            }
        }
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
        return arrayList;
    }

    public static List<File> getAllFavoriteDirs() {
        ArrayList<File> arrayList = new ArrayList<File>();
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(FAVORITE_DIRS).item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName(DIRECTORY);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                File file = new File(element2.getAttribute(PATH));
                if (file.exists()) {
                    arrayList.add(file);
                    continue;
                }
                element.removeChild(element2);
            }
        }
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
        return arrayList;
    }

    public static void saveFavoriteDirectory(String string) {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(FAVORITE_DIRS).item(0);
        Element element2 = document.createElement(DIRECTORY);
        element2.setAttribute(PATH, string);
        element.appendChild(element2);
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
    }

    public static void rmLastFavoriteDirectory() {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(FAVORITE_DIRS).item(0);
        NodeList nodeList = element.getElementsByTagName(DIRECTORY);
        if (nodeList.getLength() != 0) {
            element.removeChild(nodeList.item(nodeList.getLength() - 1));
        }
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
    }

    public static void saveToRecentOpenedFiles(String string) {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(RECENT_FILES).item(0);
        NodeList nodeList = element.getElementsByTagName(DOCUMENT);
        int n = nodeList.getLength();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!string.equals(element2.getAttribute(PATH))) continue;
            element.removeChild(element2);
            --n;
        }
        while (nodeList.getLength() >= 20) {
            element.removeChild(element.getFirstChild());
        }
        Element element3 = document.createElement(DOCUMENT);
        element3.setAttribute(PATH, string);
        element.appendChild(element3);
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
    }

    public static boolean getRestoreOpenedFiles() {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(PROFILE);
        Element element2 = (Element)nodeList.item(0);
        NodeList nodeList2 = element2.getElementsByTagName(RESTOREFILES);
        Element element3 = (Element)nodeList2.item(0);
        return TRUE.equals(element3.getAttribute(VALUE));
    }

    public static void saveRestoreOpenedFiles(boolean bl) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(PROFILE);
        Element element2 = (Element)nodeList.item(0);
        NodeList nodeList2 = element2.getElementsByTagName(RESTOREFILES);
        Element element3 = (Element)nodeList2.item(0);
        if (element3 == null) {
            Element element4 = document.createElement(RESTOREFILES);
            element3.setAttribute(VALUE, new Boolean(bl).toString());
            element3.appendChild(element4);
        } else {
            element3.setAttribute(VALUE, new Boolean(bl).toString());
        }
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
    }

    public static int countExistingOpenFiles(UUID uUID) {
        int n = 0;
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName(DOCUMENT);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                File file;
                Element element2 = (Element)nodeList.item(i);
                if (!element2.getAttribute(EDITORINST).equals(uUID.toString()) || !(file = new File(element2.getAttribute(PATH))).exists()) continue;
                ++n;
            }
        }
        return n;
    }

    public static List<File> getOpenFilesByEditor(UUID uUID) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName(DOCUMENT);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (!uUID.equals(UUID.fromString(element2.getAttribute(EDITORINST)))) continue;
                File file = new File(element2.getAttribute(PATH));
                if (file.exists() && !arrayList.contains(file)) {
                    arrayList.add(file);
                    continue;
                }
                element.removeChild(element2);
                --i;
            }
            ConfigSciNotesManager.clean(element);
            ConfigSciNotesManager.writeDocument();
        }
        return arrayList;
    }

    public static List<UUID> getOpenFilesEditorList() {
        ArrayList<UUID> arrayList = new ArrayList<UUID>();
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName(DOCUMENT);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                UUID uUID = UUID.fromString(element2.getAttribute(EDITORINST));
                if (arrayList.contains(uUID)) continue;
                arrayList.add(uUID);
            }
        }
        return arrayList;
    }

    public static void saveToOpenFiles(String string, SciNotes sciNotes, ScilabEditorPane scilabEditorPane) {
        ConfigSciNotesManager.saveToOpenFiles(string, sciNotes, scilabEditorPane, -1);
    }

    public static void saveToOpenFiles(String string, SciNotes sciNotes, ScilabEditorPane scilabEditorPane, int n) {
        ConfigSciNotesManager.readDocument();
        ConfigSciNotesManager.removeFromOpenFiles(sciNotes.getUUID(), Arrays.asList(string));
        UUID uUID = new UUID(0L, 0L);
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        NodeList nodeList = element.getElementsByTagName(DOCUMENT);
        int n2 = nodeList.getLength();
        Node node = null;
        if (n != -1 && n < n2) {
            node = nodeList.item(n);
        }
        Element element2 = document.createElement(DOCUMENT);
        element2.setAttribute(PATH, string);
        element2.setAttribute(EDITORINST, sciNotes.getUUID().toString());
        element2.setAttribute(PANEINST, scilabEditorPane.getUUID().toString());
        element2.setAttribute(PANEINST_EX, uUID.toString());
        if (node != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
    }

    public static void removeFromOpenFiles(SciNotes sciNotes, ScilabEditorPane scilabEditorPane) {
        ConfigSciNotesManager.removeFromOpenFiles(sciNotes.getUUID(), scilabEditorPane.getUUID());
    }

    public static void removeFromOpenFiles(UUID uUID) {
        ConfigSciNotesManager.removeFromOpenFiles(uUID, new UUID(0L, 0L));
    }

    public static void removeFromOpenFiles(UUID uUID, List<String> list) {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        NodeList nodeList = element.getElementsByTagName(DOCUMENT);
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Element element2 = (Element)nodeList.item(i);
            if (!uUID.equals(UUID.fromString(element2.getAttribute(EDITORINST))) || !list.contains(element2.getAttribute(PATH))) continue;
            element.removeChild(element2);
        }
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
    }

    public static void removeFromOpenFiles(UUID uUID, UUID uUID2) {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        NodeList nodeList = element.getElementsByTagName(DOCUMENT);
        UUID uUID3 = new UUID(0L, 0L);
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Element element2 = (Element)nodeList.item(i);
            UUID uUID4 = UUID.fromString(element2.getAttribute(PANEINST));
            UUID uUID5 = UUID.fromString(element2.getAttribute(PANEINST_EX));
            if (!uUID.equals(UUID.fromString(element2.getAttribute(EDITORINST))) || !uUID2.equals(uUID3) && !uUID2.equals(uUID4) && !uUID2.equals(uUID5)) continue;
            element.removeChild(element2);
        }
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
    }

    public static void renameOpenFilesItem(String string, SciNotes sciNotes, ScilabEditorPane scilabEditorPane) {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        Element element2 = ConfigSciNotesManager.findOpenFileItem(element, sciNotes.getUUID(), scilabEditorPane.getUUID());
        if (element2 != null) {
            element2.setAttribute(PATH, string);
        }
        ConfigSciNotesManager.writeDocument();
    }

    public static void tabSplitOpenFilesItem(SciNotes sciNotes, ScilabEditorPane scilabEditorPane, ScilabEditorPane scilabEditorPane2, ScilabEditorPane scilabEditorPane3) {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        Element element2 = ConfigSciNotesManager.findOpenFileItem(element, sciNotes.getUUID(), scilabEditorPane.getUUID());
        if (element2 != null) {
            element2.setAttribute(PANEINST, scilabEditorPane2.getUUID().toString());
            element2.setAttribute(PANEINST_EX, scilabEditorPane3.getUUID().toString());
        }
        ConfigSciNotesManager.writeDocument();
    }

    public static void removeTabSplitInOpenFilesItem(SciNotes sciNotes, ScilabEditorPane scilabEditorPane, ScilabEditorPane scilabEditorPane2) {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        Element element2 = ConfigSciNotesManager.findOpenFileItem(element, sciNotes.getUUID(), scilabEditorPane.getUUID());
        if (element2 != null) {
            UUID uUID = new UUID(0L, 0L);
            element2.setAttribute(PANEINST, scilabEditorPane2.getUUID().toString());
            element2.setAttribute(PANEINST_EX, uUID.toString());
        }
        ConfigSciNotesManager.writeDocument();
    }

    public static Element findOpenFileItem(Element element, UUID uUID, UUID uUID2) {
        NodeList nodeList = element.getElementsByTagName(DOCUMENT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            UUID uUID3 = UUID.fromString(element2.getAttribute(PANEINST));
            UUID uUID4 = UUID.fromString(element2.getAttribute(PANEINST_EX));
            if (!uUID.equals(UUID.fromString(element2.getAttribute(EDITORINST))) || !uUID2.equals(uUID3) && !uUID2.equals(uUID4)) continue;
            return element2;
        }
        return null;
    }

    public static void removeAllOpenFiles() {
        ConfigSciNotesManager.readDocument();
        Element element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        NodeList nodeList = element.getElementsByTagName(DOCUMENT);
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Element element2 = (Element)nodeList.item(i);
            element.removeChild(element2);
        }
        ConfigSciNotesManager.clean(element);
        ConfigSciNotesManager.writeDocument();
    }

    public static void resetDocument() {
        document = null;
    }

    private static void readDocument() {
        ConfigSciNotesManager.readDocument(USER_SCINOTES_CONFIG_FILE);
    }

    private static void readDocument(String string) {
        File file = new File(USER_SCINOTES_CONFIG_FILE);
        if (!file.exists()) {
            ConfigSciNotesManager.createUserCopy();
        }
        File file2 = null;
        DocumentBuilder documentBuilder = null;
        String string2 = ScilabDocumentBuilderFactory.useDefaultDocumentBuilderFactoryImpl();
        try {
            if (document == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                file2 = new File(string);
                document = documentBuilder.parse(file2);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(ERROR_READ + string);
        }
        catch (SAXException sAXException) {
            System.err.println(ERROR_READ + string);
        }
        catch (IOException iOException) {
            System.err.println(ERROR_READ + string);
        }
        ScilabDocumentBuilderFactory.restoreDocumentBuilderFactoryImpl((String)string2);
        if (document == null && file.exists()) {
            ScilabModalDialog.show(null, (String)SciNotesMessages.CORRUPTED_CONF_FILE, (String)SciNotesMessages.SCINOTES_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
            file.delete();
            ConfigSciNotesManager.createUserCopy();
            ConfigSciNotesManager.readDocument(string);
        }
    }

    private static void writeDocument() {
        if (mustSave) {
            ScilabXMLUtilities.writeDocument((Document)document, (String)USER_SCINOTES_CONFIG_FILE);
        }
    }

    public static void saveCodeNavigatorState(String string, String string2) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(CODENAVIGATOR);
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("uuid").equals(string2)) continue;
            element2.setAttribute("depends", string);
            bl = true;
            break;
        }
        if (!bl) {
            ScilabXMLUtilities.createNode((Document)document, (Element)element, (String)CODENAVIGATOR, (Object[])new String[]{"uuid", string2, "depends", string});
        }
        ConfigSciNotesManager.writeDocument();
    }

    public static String getCodeNavigatorState(String string) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(CODENAVIGATOR);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("uuid").equals(string)) continue;
            return element2.getAttribute("depends");
        }
        return null;
    }

    public static String getCodeNavigatorStateForEditor(String string) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(CODENAVIGATOR);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("depends").equals(string)) continue;
            return element2.getAttribute("uuid");
        }
        return null;
    }

    public static void saveSearchInFilesState(String string, String string2) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(SEARCHINFILES);
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("uuid").equals(string2)) continue;
            element2.setAttribute("depends", string);
            bl = true;
            break;
        }
        if (!bl) {
            ScilabXMLUtilities.createNode((Document)document, (Element)element, (String)SEARCHINFILES, (Object[])new String[]{"uuid", string2, "depends", string});
        }
        ConfigSciNotesManager.writeDocument();
    }

    public static String getSearchInFilesState(String string) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(SEARCHINFILES);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("uuid").equals(string)) continue;
            return element2.getAttribute("depends");
        }
        return null;
    }

    public static String getSearchInFilesStateForEditor(String string) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(SEARCHINFILES);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("depends").equals(string)) continue;
            return element2.getAttribute("uuid");
        }
        return null;
    }

    public static void saveEditorUUID(String string) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(EDITORUUID);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("uuid").equals(string)) continue;
            return;
        }
        ScilabXMLUtilities.createNode((Document)document, (Element)element, (String)EDITORUUID, (Object[])new String[]{"uuid", string});
        ConfigSciNotesManager.writeDocument();
    }

    public static void removeEditorUUID(String string) {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(EDITORUUID);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("uuid").equals(string)) continue;
            element.removeChild(element2);
        }
        element = (Element)document.getDocumentElement().getElementsByTagName(OPEN_FILES).item(0);
        if (element != null) {
            NodeList nodeList2 = element.getElementsByTagName(DOCUMENT);
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element3 = (Element)nodeList2.item(i);
                if (!element3.getAttribute(EDITORINST).equals(string)) continue;
                element.removeChild(element3);
            }
        }
        ConfigSciNotesManager.writeDocument();
    }

    public static List<String> getEditorsUUID() {
        ConfigSciNotesManager.readDocument();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName(EDITORUUID);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            arrayList.add(element2.getAttribute("uuid"));
        }
        return arrayList;
    }

    public static void saveRecentSearch(String string) {
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null || string == null || string.compareTo("") == 0) {
            return;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, RECENT_SEARCH);
        if (node2 == null) {
            node2 = document.createElement(RECENT_SEARCH);
            node.appendChild(node2);
        }
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, SEARCH);
        while (list.size() >= 20) {
            ConfigSciNotesManager.removeRecentSearch(((Element)list.get(0)).getAttribute(EXPRESSION));
            list = ConfigSciNotesManager.getNodeChildren(node2, SEARCH);
        }
        for (Node node3 : list) {
            if (string.compareTo(((Element)node3).getAttribute(EXPRESSION)) != 0) continue;
            return;
        }
        Element element = document.createElement(SEARCH);
        element.setAttribute(EXPRESSION, string);
        node2.appendChild(element);
        ConfigSciNotesManager.clean(node2);
        ConfigSciNotesManager.writeDocument();
    }

    public static void removeRecentSearch(String string) {
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null) {
            return;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, RECENT_SEARCH);
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, SEARCH);
        for (Node node3 : list) {
            if (string.compareTo(((Element)node3).getAttribute(EXPRESSION)) != 0) continue;
            node2.removeChild(node3);
            break;
        }
        ConfigSciNotesManager.clean(node2);
        ConfigSciNotesManager.writeDocument();
    }

    public static List<String> getRecentSearch() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null) {
            return arrayList;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, RECENT_SEARCH);
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, SEARCH);
        for (Node node3 : list) {
            String string = ((Element)node3).getAttribute(EXPRESSION);
            if (string == null || string.compareTo("") == 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static void saveRecent(String string, String string2, String string3) {
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null || string == null || string.compareTo("") == 0) {
            return;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, string2);
        if (node2 == null) {
            node2 = document.createElement(string2);
            node.appendChild(node2);
        }
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, string3);
        while (list.size() >= 20) {
            ConfigSciNotesManager.removeRecent(((Element)list.get(0)).getAttribute(EXPRESSION), string2, string3);
            list = ConfigSciNotesManager.getNodeChildren(node2, string3);
        }
        for (Node node3 : list) {
            if (string.compareTo(((Element)node3).getAttribute(EXPRESSION)) != 0) continue;
            return;
        }
        Element element = document.createElement(string3);
        element.setAttribute(EXPRESSION, string);
        node2.appendChild(element);
        ConfigSciNotesManager.clean(node2);
        ConfigSciNotesManager.writeDocument();
    }

    public static void removeRecent(String string, String string2, String string3) {
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null) {
            return;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, string2);
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, string3);
        for (Node node3 : list) {
            if (string.compareTo(((Element)node3).getAttribute(EXPRESSION)) != 0) continue;
            node2.removeChild(node3);
            break;
        }
        ConfigSciNotesManager.clean(node2);
        ConfigSciNotesManager.writeDocument();
    }

    public static List<String> getRecent(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null) {
            return arrayList;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, string);
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, string2);
        for (Node node3 : list) {
            String string3 = ((Element)node3).getAttribute(EXPRESSION);
            if (string3 == null || string3.compareTo("") == 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static void saveRecentReplace(String string) {
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null || string == null || string.compareTo("") == 0) {
            return;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, RECENT_REPLACE);
        if (node2 == null) {
            node2 = document.createElement(RECENT_REPLACE);
            node.appendChild(node2);
        }
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, REPLACE);
        while (list.size() >= 20) {
            ConfigSciNotesManager.removeRecentReplace(((Element)list.get(0)).getAttribute(EXPRESSION));
            list = ConfigSciNotesManager.getNodeChildren(node2, REPLACE);
        }
        for (Node node3 : list) {
            if (string.compareTo(((Element)node3).getAttribute(EXPRESSION)) != 0) continue;
            return;
        }
        Element element = document.createElement(REPLACE);
        element.setAttribute(EXPRESSION, string);
        node2.appendChild(element);
        ConfigSciNotesManager.clean(node2);
        ConfigSciNotesManager.writeDocument();
    }

    public static void removeRecentReplace(String string) {
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null) {
            return;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, RECENT_REPLACE);
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, REPLACE);
        for (Node node3 : list) {
            if (string.compareTo(((Element)node3).getAttribute(EXPRESSION)) != 0) continue;
            node2.removeChild(node3);
            break;
        }
        ConfigSciNotesManager.clean(node2);
        ConfigSciNotesManager.writeDocument();
    }

    public static List<String> getRecentReplace() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null) {
            return arrayList;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, RECENT_REPLACE);
        List<Node> list = ConfigSciNotesManager.getNodeChildren(node2, REPLACE);
        for (Node node3 : list) {
            String string = ((Element)node3).getAttribute(EXPRESSION);
            if (string == null || string.compareTo("") == 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static boolean getRegularExpression() {
        return ConfigSciNotesManager.getBooleanAttribute(REGULAR_EXPRESION, STATE_FLAG, false);
    }

    public static void saveRegularExpression(boolean bl) {
        ConfigSciNotesManager.saveBooleanAttribute(REGULAR_EXPRESION, STATE_FLAG, bl);
    }

    public static boolean getWholeWord() {
        return ConfigSciNotesManager.getBooleanAttribute(WHOLE_WORD, STATE_FLAG, false);
    }

    public static void saveWholeWord(boolean bl) {
        ConfigSciNotesManager.saveBooleanAttribute(WHOLE_WORD, STATE_FLAG, bl);
    }

    public static boolean getRecursive() {
        return ConfigSciNotesManager.getBooleanAttribute(RECURSIVE, STATE_FLAG, true);
    }

    public static void saveRecursive(boolean bl) {
        ConfigSciNotesManager.saveBooleanAttribute(RECURSIVE, STATE_FLAG, bl);
    }

    public static boolean getLineByLine() {
        return ConfigSciNotesManager.getBooleanAttribute(LINEBYLINE, STATE_FLAG, true);
    }

    public static void saveLineByLine(boolean bl) {
        ConfigSciNotesManager.saveBooleanAttribute(LINEBYLINE, STATE_FLAG, bl);
    }

    public static boolean getFileCase() {
        return ConfigSciNotesManager.getBooleanAttribute(FILECASE, STATE_FLAG, false);
    }

    public static void saveFileCase(boolean bl) {
        ConfigSciNotesManager.saveBooleanAttribute(FILECASE, STATE_FLAG, bl);
    }

    public static boolean getCircularSearch() {
        return ConfigSciNotesManager.getBooleanAttribute(CIRCULAR, STATE_FLAG, true);
    }

    public static void saveCircularSearch(boolean bl) {
        ConfigSciNotesManager.saveBooleanAttribute(CIRCULAR, STATE_FLAG, bl);
    }

    public static boolean getCaseSensitive() {
        return ConfigSciNotesManager.getBooleanAttribute(CASE_SENSITIVE, STATE_FLAG, false);
    }

    public static void saveCaseSensitive(boolean bl) {
        ConfigSciNotesManager.saveBooleanAttribute(CASE_SENSITIVE, STATE_FLAG, bl);
    }

    private static boolean getBooleanAttribute(String string, String string2, boolean bl) {
        boolean bl2 = false;
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null) {
            return bl2;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, string);
        if (node2 != null) {
            String string3 = ((Element)node2).getAttribute(string2);
            if (string3.compareTo(TRUE) == 0) {
                bl2 = true;
            }
        } else {
            return bl;
        }
        return bl2;
    }

    private static void saveBooleanAttribute(String string, String string2, boolean bl) {
        Node node = ConfigSciNotesManager.getXcosRoot();
        if (node == null) {
            return;
        }
        Node node2 = ConfigSciNotesManager.getNodeChild(node, string);
        if (node2 == null) {
            node2 = document.createElement(string);
            node.appendChild(node2);
        }
        ((Element)node2).setAttribute(string2, new Boolean(bl).toString());
        node.appendChild(node2);
        ConfigSciNotesManager.writeDocument();
    }

    private static Node getNodeChild(Node node, String string) {
        Node node2;
        Node node3 = node;
        if (node3 == null) {
            if (document == null) {
                ConfigSciNotesManager.readDocument();
                if (document == null) {
                    return null;
                }
            }
            node3 = document;
        }
        for (node2 = node3.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeName().compareTo(string) != 0) continue;
            return node2;
        }
        return node2;
    }

    private static List<Node> getNodeChildren(Node node, String string) {
        Node node2 = node;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node2 == null) {
            if (document == null) {
                ConfigSciNotesManager.readDocument();
                if (document == null) {
                    return arrayList;
                }
            }
            node2 = document;
        }
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            if (node3.getNodeName().compareTo(string) != 0) continue;
            arrayList.add(node3);
        }
        return arrayList;
    }

    private static Node getXcosRoot() {
        Node node;
        if (document == null) {
            ConfigSciNotesManager.readDocument();
            if (document == null) {
                return null;
            }
        }
        if ((node = ConfigSciNotesManager.getNodeChild(null, SETTING)) != null) {
            List<Node> list = ConfigSciNotesManager.getNodeChildren(node, PROFILE);
            for (Node node2 : list) {
                if (((Element)node2).getAttribute(NAME).compareTo(SCINOTES) != 0) continue;
                return node2;
            }
        }
        return null;
    }

    private static void clean(Node node) {
        ScilabXMLUtilities.removeEmptyLines((Node)node);
    }

    static {
        mustSave = true;
        USER_SCINOTES_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/scinotesConfiguration.xml";
        if (ScilabConstants.SCIHOME != null && ScilabConstants.SCIHOME.canRead() && ScilabConstants.SCIHOME.canWrite()) {
            USER_SCINOTES_CONFIG_FILE = ScilabConstants.SCIHOME.toString() + "/scinotesConfiguration.xml";
        } else {
            USER_SCINOTES_CONFIG_FILE = SCINOTES_CONFIG_FILE;
            mustSave = false;
        }
    }
}

