/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.ui;

import com.artenum.rosetta.interfaces.core.ConsoleConfiguration;
import com.artenum.rosetta.interfaces.ui.GuiComponent;
import com.artenum.rosetta.interfaces.ui.InputCommandView;
import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.interfaces.ui.PromptView;
import com.artenum.rosetta.ui.CommandLineViewImpl;
import com.artenum.rosetta.util.ConfigurationBuilder;
import com.artenum.rosetta.util.ConsoleBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class Console
extends JPanel
implements GuiComponent,
Scrollable {
    private static final long serialVersionUID = 1L;
    private CommandLineViewImpl commandLine;
    private ArrayList<GuiComponent> guiComponent;
    private int scrollableBlockIncrement = 10;
    private int scrollableUnitIncrement = 10;
    private boolean horizontalWrapAllowed = true;
    private boolean verticalWrapAllowed = false;

    public Console() {
        this.setLayout(new BorderLayout());
        this.commandLine = new CommandLineViewImpl();
        this.add((Component)this.commandLine, "Center");
        this.guiComponent = new ArrayList();
        this.setOpaque(true);
    }

    public void setOutputView(OutputView output) {
        this.add((Component)((JComponent)output), "North");
        this.guiComponent.add((GuiComponent)output);
    }

    public void setInputCommandView(InputCommandView command) {
        this.commandLine.setInputCommandView((JComponent)command);
        this.guiComponent.add((GuiComponent)command);
    }

    public void setPromptView(PromptView prompt) {
        this.commandLine.setPromptView((JComponent)prompt);
        this.guiComponent.add((GuiComponent)prompt);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.guiComponent != null) {
            for (GuiComponent component : this.guiComponent) {
                component.setBackground(color);
            }
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.guiComponent != null) {
            for (GuiComponent component : this.guiComponent) {
                component.setForeground(color);
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.guiComponent != null) {
            for (GuiComponent component : this.guiComponent) {
                component.setFont(font);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension minSize = ((JViewport)this.getParent()).getExtentSize();
        Dimension prefSize = super.getPreferredSize();
        Dimension returnedSize = new Dimension(minSize);
        if (!this.getScrollableTracksViewportHeight() && prefSize.height > minSize.height) {
            returnedSize.height = prefSize.height;
        }
        if (!this.getScrollableTracksViewportWidth() && prefSize.width > minSize.width) {
            returnedSize.width = prefSize.width;
        }
        return returnedSize;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return this.scrollableUnitIncrement;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return this.scrollableBlockIncrement;
    }

    public void setScrollableUnitIncrement(int increment) {
        this.scrollableUnitIncrement = increment;
    }

    public void setScrollableBlockIncrement(int increment) {
        this.scrollableBlockIncrement = increment;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (!this.horizontalWrapAllowed) {
            boolean b = true;
            for (GuiComponent c : this.guiComponent) {
                b = b && ((JComponent)c).getPreferredSize().width < ((JViewport)this.getParent()).getExtentSize().width;
            }
            return b;
        }
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.verticalWrapAllowed;
    }

    public void setVerticalWrapAllowed(boolean wrapMode) {
        this.verticalWrapAllowed = wrapMode;
    }

    public boolean getVerticalWrapAllowed() {
        return this.verticalWrapAllowed;
    }

    public void setHorizontalWrapAllowed(boolean wrapMode) {
        this.horizontalWrapAllowed = wrapMode;
    }

    public boolean getHorizontalWrapAllowed() {
        return this.horizontalWrapAllowed;
    }

    public static void main(String[] args) throws Exception {
        String configFilePath = "./resources/configuration.xml";
        String profileName = null;
        switch (args.length) {
            case 2: {
                configFilePath = args[1];
            }
            case 1: {
                profileName = args[0];
            }
        }
        if (!new File(configFilePath).exists()) {
            System.err.println("Three way of launch:");
            System.err.println(" - 0 argument: The first profile of the ./resources/configuration.xml will be loaded.");
            System.err.println(" - 1 argument: The specified profile name of the ./resources/configuration.xml will be loaded. (args1=profileName)");
            System.err.println(" - 2 arguments: The specified profile with the specified configuration file will be loaded. (args1=profileName args2=configurationFilePath)");
        } else {
            ConsoleConfiguration config = ConfigurationBuilder.buildConfiguration(configFilePath);
            config.setActiveProfile(profileName);
            JFrame window = new JFrame("Generic console");
            window.setDefaultCloseOperation(3);
            window.getContentPane().setLayout(new BorderLayout());
            window.getContentPane().add((Component)new JScrollPane(ConsoleBuilder.buildConsole(config, window)), "Center");
            window.setSize(600, 300);
            window.setLocationRelativeTo(null);
            window.setVisible(true);
        }
    }
}

