/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.ui;

import com.artenum.rosetta.interfaces.core.InputParsingManager;
import com.artenum.rosetta.interfaces.ui.PromptView;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PromptViewImpl
extends JPanel
implements PromptView {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PROMPT = ">>> ";
    private static final String DEFAULT_IN_BLOCK_PROMPT = "... ";
    private static final String HTML_START = "<html>";
    private static final String HTML_NEW_LINE = "<br/>";
    private static final String HTML_END = "</html>";
    private String defaultPrompt = ">>> ";
    private String inBlockPrompt = "... ";
    private InputParsingManager inputParsingManager;
    private StringBuffer promptTextContent = new StringBuffer();
    private JLabel promptUI = new JLabel();

    public PromptViewImpl() {
        this.promptUI.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.promptUI.setOpaque(true);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.promptUI);
        this.add(Box.createVerticalGlue());
    }

    public void setDefaultPrompt(String defaultPrompt) {
        this.defaultPrompt = defaultPrompt;
        this.updatePrompt();
    }

    public void setInBlockPrompt(String inBlockPrompt) {
        this.inBlockPrompt = inBlockPrompt;
        this.updatePrompt();
    }

    public void setInputParsingManager(InputParsingManager inputParsingManager) {
        this.inputParsingManager = inputParsingManager;
    }

    public void updatePrompt() {
        this.promptTextContent.setLength(0);
        this.promptTextContent.append(HTML_START);
        this.promptTextContent.append(this.defaultPrompt.replaceAll(">", "&gt;"));
        int nbLineToShow = this.inputParsingManager.getNumberOfLines();
        while (nbLineToShow-- > 1) {
            this.promptTextContent.append(HTML_NEW_LINE);
            this.promptTextContent.append(this.inBlockPrompt);
        }
        this.promptTextContent.append(HTML_END);
        this.promptUI.setText(this.promptTextContent.toString());
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        if (this.promptUI != null) {
            this.promptUI.setBackground(bgColor);
        }
    }

    public String getDefaultPrompt() {
        return this.defaultPrompt;
    }

    public String getInBlockPrompt() {
        return this.inBlockPrompt;
    }
}

