/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.external_objects_java;

import java.beans.MethodDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scilab.modules.external_objects_java.Converter;
import org.scilab.modules.external_objects_java.ScilabJavaArray;
import org.scilab.modules.external_objects_java.ScilabJavaObject;

public final class FunctionArguments {
    private static final List<Converter> converters = new ArrayList<Converter>();

    public static final void registerConverter(Converter converter) {
        int n = converters.indexOf(converter);
        if (n == -1) {
            converters.add(converter);
        } else {
            converters.remove(n);
            converters.add(converter);
        }
    }

    public static final void unregisterConverter(Converter converter) {
        int n = converters.indexOf(converter);
        if (n != -1) {
            converters.remove(n);
        }
    }

    public static final Object convert(Object object, Class clazz) {
        if (object == null) {
            return null;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz.isAssignableFrom(clazz2)) {
            return object;
        }
        for (Converter converter : converters) {
            if (!converter.canConvert(clazz2, clazz)) continue;
            return converter.convert(object, clazz);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object[] findMethod(String string, MethodDescriptor[] methodDescriptorArray, Class[] classArray, Object[] objectArray) throws NoSuchMethodException {
        String string2 = string.intern();
        Method method = null;
        boolean bl = false;
        boolean bl2 = false;
        long l = Long.MAX_VALUE;
        boolean[] blArray = new boolean[1];
        HashMap<Integer, Converter> hashMap = null;
        HashMap<Integer, Converter> hashMap2 = new HashMap<Integer, Converter>();
        for (MethodDescriptor entry : methodDescriptorArray) {
            if (entry.getName() != string2) continue;
            Method method2 = entry.getMethod();
            Class[] classArray2 = method2.getParameterTypes();
            blArray[0] = false;
            long l2 = FunctionArguments.compareClassArgs(classArray2, classArray, objectArray, blArray, hashMap2);
            if (l2 != Long.MIN_VALUE && l2 < l) {
                l = l2;
                method = method2;
                bl2 = blArray[0];
                hashMap = hashMap2;
                if (l2 == 0L) break;
                hashMap2 = new HashMap();
                continue;
            }
            hashMap2.clear();
        }
        if (method != null) {
            Object[] objectArray2;
            if (!hashMap.isEmpty()) {
                objectArray2 = method.getParameterTypes();
                Class<?> clazz = ((Class)objectArray2[objectArray2.length - 1]).getComponentType();
                for (Map.Entry entry : hashMap.entrySet()) {
                    int n = (Integer)entry.getKey();
                    if (n >= 0) {
                        classArray[n] = objectArray2[n];
                        objectArray[n] = ((Converter)entry.getValue()).convert(objectArray[n], (Class<?>)objectArray2[n]);
                        continue;
                    }
                    n = -n - 1;
                    objectArray[n] = ((Converter)entry.getValue()).convert(objectArray[n], clazz);
                }
            }
            if (bl2) {
                Object object;
                objectArray2 = method.getParameterTypes();
                if (objectArray.length == 1 && objectArray2.length == 1 && objectArray[0] == null) {
                    object = null;
                } else {
                    void var16_24;
                    Class<?> clazz = ((Class)objectArray2[objectArray2.length - 1]).getComponentType();
                    object = Array.newInstance(clazz, objectArray.length - objectArray2.length + 1);
                    boolean bl3 = false;
                    while (var16_24 < objectArray.length - objectArray2.length + 1) {
                        Array.set(object, (int)var16_24, objectArray[var16_24 + objectArray2.length - true]);
                        ++var16_24;
                    }
                }
                Object[] objectArray3 = new Object[objectArray2.length];
                System.arraycopy(objectArray, 0, objectArray3, 0, objectArray2.length - 1);
                objectArray3[objectArray2.length - 1] = object;
                return new Object[]{method, objectArray3};
            }
            return new Object[]{method};
        }
        throw new NoSuchMethodException("");
    }

    /*
     * WARNING - void declaration
     */
    public static final Object[] findConstructor(Constructor[] constructorArray, Class[] classArray, Object[] objectArray) throws NoSuchMethodException {
        Constructor object = null;
        boolean bl = false;
        boolean bl2 = false;
        long l = Long.MAX_VALUE;
        boolean[] blArray = new boolean[1];
        HashMap<Integer, Converter> hashMap = null;
        HashMap<Integer, Converter> hashMap2 = new HashMap<Integer, Converter>();
        for (Constructor entry : constructorArray) {
            if (!Modifier.isPublic(entry.getModifiers())) continue;
            Class[] classArray2 = entry.getParameterTypes();
            blArray[0] = false;
            long l2 = FunctionArguments.compareClassArgs(classArray2, classArray, objectArray, blArray, hashMap2);
            if (l2 != Long.MIN_VALUE && l2 < l) {
                l = l2;
                object = entry;
                bl2 = blArray[0];
                hashMap = hashMap2;
                if (l2 == 0L) break;
                hashMap2 = new HashMap();
                continue;
            }
            hashMap2.clear();
        }
        if (object != null) {
            GenericDeclaration[] genericDeclarationArray;
            if (!hashMap.isEmpty()) {
                genericDeclarationArray = object.getParameterTypes();
                Class<?> clazz = ((Class)genericDeclarationArray[genericDeclarationArray.length - 1]).getComponentType();
                for (Map.Entry entry : hashMap.entrySet()) {
                    int n = (Integer)entry.getKey();
                    if (n >= 0) {
                        classArray[n] = genericDeclarationArray[n];
                        objectArray[n] = ((Converter)entry.getValue()).convert(objectArray[n], (Class<?>)genericDeclarationArray[n]);
                        continue;
                    }
                    n = -n - 1;
                    objectArray[n] = ((Converter)entry.getValue()).convert(objectArray[n], clazz);
                }
            }
            if (bl2) {
                Object object2;
                genericDeclarationArray = object.getParameterTypes();
                if (objectArray.length == 1 && genericDeclarationArray.length == 1 && objectArray[0] == null) {
                    object2 = null;
                } else {
                    void var14_22;
                    Class<?> clazz = ((Class)genericDeclarationArray[genericDeclarationArray.length - 1]).getComponentType();
                    object2 = Array.newInstance(clazz, objectArray.length - genericDeclarationArray.length + 1);
                    boolean bl3 = false;
                    while (var14_22 < objectArray.length - genericDeclarationArray.length + 1) {
                        Array.set(object2, (int)var14_22, objectArray[var14_22 + genericDeclarationArray.length - true]);
                        ++var14_22;
                    }
                }
                Object[] objectArray2 = new Object[genericDeclarationArray.length];
                System.arraycopy(objectArray, 0, objectArray2, 0, genericDeclarationArray.length - 1);
                objectArray2[genericDeclarationArray.length - 1] = object2;
                return new Object[]{object, objectArray2};
            }
            return new Object[]{object};
        }
        throw new NoSuchMethodException("");
    }

    private static final long compareClassArgs(Class[] classArray, Class[] classArray2, Object[] objectArray, boolean[] blArray, Map<Integer, Converter> map) {
        if (classArray.length > classArray2.length) {
            return Long.MIN_VALUE;
        }
        long l = 0L;
        int n = classArray.length;
        if (classArray.length > 0 && classArray[classArray.length - 1].isArray() && (classArray.length < classArray2.length || classArray.length == 1 && classArray2.length == 1 && (classArray2[0] == null || !classArray2[0].isArray()))) {
            Class<?> clazz = classArray[classArray.length - 1].getComponentType();
            blArray[0] = true;
            --n;
            l = 256L;
            for (int i = classArray.length - 1; i < classArray2.length; ++i) {
                long l2 = FunctionArguments.dist(clazz, classArray2[i]);
                if (l2 == -1L) {
                    for (Converter converter : converters) {
                        if (!converter.canConvert(classArray2[i], clazz)) continue;
                        l2 = 2048L;
                        map.put(-i - 1, converter);
                        break;
                    }
                    if (l2 != 2048L) {
                        return Long.MIN_VALUE;
                    }
                }
                l += l2 * l2;
            }
        } else if (classArray.length < classArray2.length) {
            return Long.MIN_VALUE;
        }
        for (int i = 0; i < n; ++i) {
            long l3 = FunctionArguments.dist(classArray[i], classArray2[i]);
            if (l3 == -1L) {
                for (Converter converter : converters) {
                    if (!converter.canConvert(classArray2[i], classArray[i])) continue;
                    l3 = 2048L;
                    map.put(i, converter);
                    break;
                }
                if (l3 != 2048L) {
                    return Long.MIN_VALUE;
                }
            }
            l += l3 * l3;
        }
        return l;
    }

    private static final long dist(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null) {
            return 0L;
        }
        if (!clazz.isPrimitive() && clazz2.isPrimitive()) {
            clazz2 = ScilabJavaObject.primTypes.get(clazz2);
        }
        if (clazz == clazz2) {
            return 0L;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            long l = 0L;
            do {
                ++l;
            } while ((clazz2 = clazz2.getSuperclass()) != null && clazz.isAssignableFrom(clazz2));
            return l;
        }
        return -1L;
    }

    static {
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return ((Number)object).intValue();
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return !(clazz2 != Integer.TYPE && clazz2 != Integer.class || !Number.class.isAssignableFrom(clazz) && !ScilabJavaObject.primTypes.containsKey(clazz));
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return Float.valueOf(((Number)object).floatValue());
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return !(clazz2 != Float.TYPE && clazz2 != Float.class || clazz != Double.TYPE && clazz != Double.class);
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return ScilabJavaArray.toIntArray((double[])object);
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return clazz2 == int[].class && clazz == double[].class;
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return ScilabJavaArray.fromPrimitive(object);
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                if (clazz.isArray() && clazz2.isArray()) {
                    Class clazz3 = ScilabJavaArray.getArrayBaseType(clazz);
                    Class clazz4 = ScilabJavaArray.getArrayBaseType(clazz2);
                    return ScilabJavaObject.primTypes.get(clazz3) == clazz4;
                }
                return false;
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return ScilabJavaArray.toList(object);
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return clazz.isArray() && clazz2.isAssignableFrom(ArrayList.class);
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return Enum.valueOf(clazz, (String)object);
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return String.class.isAssignableFrom(clazz) && clazz2.isEnum();
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return ScilabJavaArray.toOneDim(object);
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return clazz2.isArray() && clazz.isArray() && clazz.getComponentType().isArray() && clazz2.getComponentType() == clazz.getComponentType().getComponentType();
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return ScilabJavaArray.toBiDim(object);
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return clazz2.isArray() && clazz.isArray() && clazz2.getComponentType().isArray() && clazz.getComponentType() == clazz2.getComponentType().getComponentType();
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return ScilabJavaArray.singleToOneDim(clazz.getComponentType(), object);
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return clazz2.isArray() && clazz == clazz2.getComponentType();
            }
        });
        FunctionArguments.registerConverter(new Converter(){

            @Override
            public Object convert(Object object, Class<?> clazz) {
                return ScilabJavaArray.singleToOneDim(clazz.getComponentType(), object);
            }

            @Override
            public boolean canConvert(Class<?> clazz, Class<?> clazz2) {
                return clazz2.isArray() && ScilabJavaArray.mappings.get(clazz) == clazz2.getComponentType();
            }
        });
    }
}

