/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.preferences.Component.Panel;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class FileSelector
extends Panel
implements XComponent,
XChooser,
DocumentListener {
    private static final long serialVersionUID = -7007541669965737408L;
    private static final Color NORMALCOLOR = Color.BLACK;
    private static final Color ERRORCOLOR = Color.RED;
    private ActionListener actionListener;
    private JTextField textField;
    private JButton button;
    private String currentDir = System.getProperty("user.home");
    private boolean dirSelection;
    private boolean checkEntry;
    private String previousPath;

    public FileSelector(final Node node) {
        super(node);
        this.setLayout(new GridBagLayout());
        this.textField = new JTextField();
        this.textField.setEditable(true);
        this.textField.setColumns(10);
        this.textField.getDocument().addDocumentListener(this);
        this.button = new JButton("...");
        this.button.setPreferredSize(new Dimension(this.button.getPreferredSize().width, this.textField.getPreferredSize().height));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, FileSelector.this);
                SwingScilabFileChooser swingScilabFileChooser = new SwingScilabFileChooser();
                swingScilabFileChooser.setInitialDirectory(FileSelector.this.currentDir);
                swingScilabFileChooser.setParentFrame(jFrame);
                swingScilabFileChooser.setMultipleSelection(false);
                swingScilabFileChooser.setFileSelectionMode(FileSelector.this.dirSelection ? 1 : 0);
                String string = XCommonManager.getAttribute(node, "mask");
                String string2 = XCommonManager.getAttribute(node, "desc");
                if (!string.equals("\"not an value'") && !string2.equals("\"not an value'")) {
                    swingScilabFileChooser.addMask(new String[]{string}, new String[]{string2});
                }
                swingScilabFileChooser.displayAndWait();
                String[] stringArray = swingScilabFileChooser.getSelection();
                if (stringArray != null && stringArray.length != 0 && !stringArray[0].isEmpty()) {
                    File file = new File(stringArray[0]);
                    FileSelector.this.currentDir = FileSelector.this.dirSelection ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath();
                    FileSelector.this.textField.setText(file.getAbsolutePath());
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.button, gridBagConstraints);
        this.textField.setRequestFocusEnabled(true);
        this.textField.setFocusable(true);
        this.button.setRequestFocusEnabled(true);
        this.button.setFocusable(true);
        String string = XConfigManager.getAttribute(node, "href");
        this.href(string);
        this.textField.setCaretPosition(0);
        String string2 = XCommonManager.getAttribute(node, "dir-selection", "false");
        this.dirSelection = string2.equals("true");
        String string3 = XConfigManager.getAttribute(node, "check-entry", "true");
        this.checkEntry = string3.equals("true");
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.textField.getDocument().addDocumentListener(documentListener);
    }

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"enable", "href", "desc", "mask", "dir-selection", "check-entry"};
        return stringArray;
    }

    @Override
    public final void refresh(Node node) {
        String string = XCommonManager.getAttribute(node, "href");
        if (!string.equals(this.href())) {
            this.href(string);
        }
        String string2 = XCommonManager.getAttribute(node, "dir-selection", "false");
        this.dirSelection = string2.equals("true");
        String string3 = XConfigManager.getAttribute(node, "enable", "true");
        this.textField.setEnabled(string3.equals("true"));
        this.button.setEnabled(string3.equals("true"));
        String string4 = XConfigManager.getAttribute(node, "check-entry", "true");
        this.checkEntry = string4.equals("true");
    }

    public final String href() {
        if (this.checkPath()) {
            return this.textField.getText();
        }
        return null;
    }

    public final void href(String string) {
        if (!string.equals("\"not an value'")) {
            this.textField.setText(string);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.update();
    }

    private void update() {
        if (this.checkPath() && this.actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 0, "File change", System.currentTimeMillis(), 0);
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    private boolean checkPath() {
        String string = this.textField.getText();
        if (string.isEmpty()) {
            return false;
        }
        string = ScilabCommonsUtils.getCorrectedPath((String)string);
        File file = new File(string);
        boolean bl = false;
        if (file.exists()) {
            bl = this.dirSelection ? file.isDirectory() : file.isFile();
        }
        if (!this.checkEntry || bl) {
            this.textField.setForeground(NORMALCOLOR);
        } else {
            this.textField.setForeground(ERRORCOLOR);
        }
        return this.checkEntry ? bl : true;
    }

    @Override
    public final Object choose() {
        return this.href();
    }

    @Override
    public final String toString() {
        Object object = "FileSelector";
        String string = this.href();
        if (string != null && !string.equals("\"not an value'")) {
            object = (String)object + " href='" + string + "'";
        }
        return object;
    }

    @Override
    public final void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }
}

