/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.scilab.modules.preferences.Component.Panel;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class List
extends Panel
implements XComponent,
XChooser,
ListSelectionListener {
    private static final long serialVersionUID = -6127289363733321915L;
    private ActionListener actionListener;
    private Model model;
    private JList list;
    private boolean dontChange;

    public List(Node node) {
        super(node);
        this.model = new Model(node);
        this.list = new JList(this.model);
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.add(jScrollPane);
        this.list.setRequestFocusEnabled(true);
        this.list.setFocusable(true);
        this.refresh(node);
    }

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"item", "enable", "nb-visible-rows"};
        return stringArray;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.actionListener != null && !this.dontChange && !listSelectionEvent.getValueIsAdjusting()) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "List selected Value changed", System.currentTimeMillis(), 0));
        }
    }

    @Override
    public final void refresh(Node node) {
        String string;
        this.model.setNodeList(node.getChildNodes());
        String string2 = XCommonManager.getAttribute(node, "item");
        if (!string2.equals(this.item())) {
            this.item(string2);
        }
        if (!(string = XCommonManager.getAttribute(node, "nb-visible-rows", "5")).equals(this.nbvisible())) {
            this.nbvisible(string);
        }
        String string3 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string3.equals("true"));
    }

    @Override
    public final Object choose() {
        return this.item();
    }

    @Override
    public final void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public final String item() {
        Object object = this.list.getSelectedValue();
        if (object == null) {
            object = this.model.getElementAt(0);
            this.list.setSelectedValue(object, true);
        }
        return object.toString();
    }

    public final void item(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            this.dontChange = true;
            this.list.setSelectedValue(string, true);
            this.dontChange = false;
        }
    }

    public final String nbvisible() {
        return Integer.toString(this.list.getVisibleRowCount());
    }

    public final void nbvisible(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            try {
                int n = Integer.parseInt(string);
                this.list.setVisibleRowCount(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public final String toString() {
        String string = "List ...";
        return string;
    }

    static class Model
    extends AbstractListModel {
        private static final long serialVersionUID = -4786321481195930071L;
        private NodeList nodelist;

        public Model(Node node) {
            this.setNodeList(node.getChildNodes());
        }

        public void setNodeList(NodeList nodeList) {
            this.nodelist = nodeList;
        }

        @Override
        public Object getElementAt(int n) {
            int n2 = n;
            for (int i = 0; i < this.nodelist.getLength(); ++i) {
                Node node = this.nodelist.item(i);
                if (!node.getNodeName().equals("listElement")) continue;
                if (n2 == 0) {
                    return XCommonManager.getAttribute(node, "name");
                }
                --n2;
            }
            return null;
        }

        @Override
        public int getSize() {
            int n = 0;
            for (int i = 0; i < this.nodelist.getLength(); ++i) {
                Node node = this.nodelist.item(i);
                if (!node.getNodeName().equals("listElement")) continue;
                ++n;
            }
            return n;
        }
    }
}

