/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import org.scilab.modules.gui.bridge.radiobutton.SwingScilabRadioButton;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class Radiobutton
extends SwingScilabRadioButton
implements XComponent,
XChooser {
    private static final long serialVersionUID = -7007541669965737408L;
    private String expectedValue;

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"enable", "text", "checked", "value", "expected-value"};
        return stringArray;
    }

    public Radiobutton(Node node) {
        this.setOpaque(false);
        this.refresh(node);
    }

    @Override
    public final void refresh(Node node) {
        String string;
        String string2 = XConfigManager.getAttribute(node, "text");
        if (!string2.equals(this.text())) {
            this.text(string2);
        }
        if ((string = XConfigManager.getAttribute(node, "checked")).equals("\"not an value'")) {
            this.expectedValue = XConfigManager.getAttribute(node, "expected-value");
            string = XConfigManager.getAttribute(node, "value").equals(this.expectedValue) ? "checked" : "unchecked";
        } else {
            this.expectedValue = null;
        }
        if (!string.equals(this.checked())) {
            this.checked(string);
        }
        String string3 = XConfigManager.getAttribute(node, "enable", "true");
        this.setEnabled(string3.equals("true"));
    }

    public final String text() {
        String string = this.getText();
        if (string != null) {
            return string;
        }
        return "\"not an value'";
    }

    public final void text(String string) {
        if (!string.equals("\"not an value'")) {
            this.setText(string);
        } else {
            this.setText(null);
        }
    }

    public final String checked() {
        boolean bl = this.isSelected();
        if (bl) {
            return "checked";
        }
        return "unchecked";
    }

    public final void checked(String string) {
        boolean bl = string.equals("checked");
        this.setSelected(bl);
    }

    @Override
    public final Object choose() {
        if (this.expectedValue != null) {
            return this.expectedValue;
        }
        if (this.isSelected()) {
            return "checked";
        }
        return "unchecked";
    }

    public final String toString() {
        Object object = "RadioButton";
        if (!this.text().equals("\"not an value'")) {
            object = (String)object + " text='" + this.text() + "'";
        }
        if (!this.checked().equals("\"not an value'")) {
            object = (String)object + " checked='" + this.checked() + "'";
        }
        return object;
    }
}

