/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.preferences.XConfigManager;

public class ScilabPreferences {
    private static Map<String, ToolboxInfos> tbxs = new HashMap<String, ToolboxInfos>();

    public static void openPreferences() {
        ScilabPreferences.openPreferences(null);
    }

    public static void openPreferences(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XConfigManager.openPreferences(string);
            }
        });
    }

    public static void addToolboxInfos(String string, String string2, String string3) throws Exception {
        File file = new File(string2);
        if (!file.exists()) {
            throw new Exception(Messages.gettext((String)"Invalid path:") + " " + string2 + ".");
        }
        file = new File(string3);
        if (!file.exists()) {
            throw new Exception(Messages.gettext((String)"Invalid preferences file:") + " " + string3 + ".");
        }
        tbxs.put(string2, new ToolboxInfos(string, string2, string3));
    }

    public static List<ToolboxInfos> getToolboxesInfos() {
        return new ArrayList<ToolboxInfos>(tbxs.values());
    }

    public static void removeToolboxInfos(String string) {
        tbxs.remove(string);
    }

    public static class ToolboxInfos {
        private String name;
        private String path;
        private String prefFile;

        public ToolboxInfos(String string, String string2, String string3) {
            this.name = string;
            this.path = string2;
            this.prefFile = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getPrefFile() {
            return this.prefFile;
        }

        public String toString() {
            return "Toolbox: " + this.name + "\nPath: " + this.path + "\nPreference file: " + this.prefFile;
        }
    }
}

