/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.JDialog;
import org.scilab.modules.gui.filechooser.Juigetfile;
import org.scilab.modules.preferences.XCommonManager;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public final class XWizardManager
extends XCommonManager {
    private static final String SCILAB_WIZARD_FILE = System.getenv("SCI") + "/modules/preferences/etc/XWizard.xml";
    private static final String SCILAB_WIZARD_PREFIX = System.getenv("SCI") + "/modules/preferences/etc/XWizard-";
    private static final String SCILAB_WIZARD_XSL = System.getenv("SCI") + "/modules/preferences/src/xslt/XWizard.xsl";
    private static String CURRENT_WIZARD_FILE = "\"not an value'";
    public static boolean active = false;

    private XWizardManager() {
        throw new UnsupportedOperationException();
    }

    public static void displayAndWait() {
        active = true;
        XConfigManager.active = false;
        XWizardManager.printTimeStamp("XWizardManager launched");
        System.out.println(" |  No active manager (" + XConfigManager.active + ", " + active + ").");
        XWizardManager.reloadTransformer(SCILAB_WIZARD_XSL);
        XWizardManager.printTimeStamp("XSL loaded");
        dialog = new JDialog(XWizardManager.getTopLevel(), "Scilab wizard", true);
        topSwing = dialog.getContentPane();
        dialog.setContentPane(topSwing);
        topSwing.setLayout(new BorderLayout());
        document = XWizardManager.readDocument(SCILAB_WIZARD_FILE);
        updated = false;
        XWizardManager.printTimeStamp("Model XML loaded");
        correspondance = new HashMap();
        if (XWizardManager.refreshDisplay()) {
            dialog.setVisible(true);
        }
    }

    public static void openUserBlockWizard() {
        XWizardManager.displayAndWait();
    }

    public static boolean xEvent(Node[] nodeArray, Component component) {
        if (XWizardManager.generixEvent(nodeArray, component)) {
            return true;
        }
        if (nodeArray.length == 0) {
            return false;
        }
        Node node = nodeArray[0];
        String string = XWizardManager.getAttribute(node, "callback");
        if (string.equals("load")) {
            String string2 = XWizardManager.getAttribute(node, "name");
            System.out.println(": Load '" + SCILAB_WIZARD_PREFIX + string2 + ".xml'.");
            dialog.setTitle("Scilab wizard - (" + string2 + " mode)");
            document = XWizardManager.readDocument(SCILAB_WIZARD_PREFIX + string2 + ".xml");
            XWizardManager.printTimeStamp("XML loaded");
            XWizardManager.refreshDisplay();
            updated = false;
            return true;
        }
        if (string.equals("New")) {
            System.out.println(": New.");
            XWizardManager.reloadTransformer(SCILAB_WIZARD_XSL);
            XWizardManager.printTimeStamp("XSL loaded");
            document = XWizardManager.readDocument(SCILAB_WIZARD_FILE);
            XWizardManager.printTimeStamp("XML loaded");
            updated = false;
            XWizardManager.refreshDisplay();
            return true;
        }
        if (string.equals("Open")) {
            System.out.println(": Open.");
            String[] stringArray = new String[]{"*.xml"};
            String[] stringArray2 = new String[]{"Block description"};
            Juigetfile.uigetfile((String[])stringArray, (String[])stringArray2);
            String[] stringArray3 = Juigetfile.getSelection();
            if (stringArray3.length > 0) {
                document = XWizardManager.readDocument(stringArray3[0]);
                dialog.setTitle("Scilab wizard - <<" + stringArray3[0] + ">>");
                XWizardManager.printTimeStamp("XML loaded");
                updated = false;
                XWizardManager.refreshDisplay();
            }
            return true;
        }
        if (string.equals("SaveAs")) {
            System.out.println(": Save as.");
            String[] stringArray = new String[]{"*.xml"};
            String[] stringArray4 = new String[]{"Block description"};
            Juigetfile.uiputfile((String[])stringArray, (String[])stringArray4);
            String[] stringArray5 = Juigetfile.getSelection();
            if (stringArray5.length > 0) {
                CURRENT_WIZARD_FILE = stringArray5[0];
            }
            if (CURRENT_WIZARD_FILE != "\"not an value'") {
                XWizardManager.writeDocument(CURRENT_WIZARD_FILE, document);
                dialog.setTitle("Scilab wizard - [" + CURRENT_WIZARD_FILE + "]");
            }
            return true;
        }
        if (string.equals("Save")) {
            System.out.println(": Save.");
            if (CURRENT_WIZARD_FILE == "\"not an value'") {
                String[] stringArray = new String[]{"*.xml"};
                String[] stringArray6 = new String[]{"Block description"};
                Juigetfile.uiputfile((String[])stringArray, (String[])stringArray6);
                String[] stringArray7 = Juigetfile.getSelection();
                if (stringArray7.length > 0) {
                    CURRENT_WIZARD_FILE = stringArray7[0];
                }
            }
            if (CURRENT_WIZARD_FILE != "\"not an value'") {
                XWizardManager.writeDocument(CURRENT_WIZARD_FILE, document);
            }
            return true;
        }
        if (string.equals("Ok")) {
            System.out.println(": Ok.");
            dialog.dispose();
            updated = false;
            return true;
        }
        if (string.equals("Quit")) {
            System.out.println(": Quit.");
            dialog.dispose();
            updated = false;
            return true;
        }
        return false;
    }

    public static void subscribeUpdate() {
    }

    public static void notifyUpdate() {
    }
}

